/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_twilight_forest.network;

import it.hurts.octostudios.reliquified_twilight_forest.network.EntityStartRidingPacket;
import it.hurts.octostudios.reliquified_twilight_forest.network.EntityStopRidingPacket;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record CastRideAlongAbilityPacket(int entityID, boolean isMounting) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CastRideAlongAbilityPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"reliquified_twilight_forest", (String)"cast_ride_along_ability"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CastRideAlongAbilityPacket> STREAM_CODEC = CustomPacketPayload.codec(CastRideAlongAbilityPacket::write, CastRideAlongAbilityPacket::new);

    public CastRideAlongAbilityPacket(RegistryFriendlyByteBuf buf) {
        this(buf.readInt(), buf.readBoolean());
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeBoolean(this.isMounting);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(CastRideAlongAbilityPacket packet, IPayloadContext ctx) {
        if (ctx.flow().isClientbound()) {
            return;
        }
        ctx.enqueueWork(() -> {
            Player vehicle = ctx.player();
            Entity entity = vehicle.level().getEntity(packet.entityID);
            Entity passenger = vehicle.getFirstPassenger();
            if (!packet.isMounting() && passenger != null) {
                passenger.stopRiding();
                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)passenger, (CustomPacketPayload)new EntityStopRidingPacket(passenger.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (entity != null) {
                if (passenger != null) {
                    passenger.setPos(entity.position());
                    passenger.setOldPosAndRot();
                }
                entity.getPersistentData().putBoolean("reliquified_twilight_forest:on_antlers", true);
                entity.startRiding((Entity)vehicle, true);
                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)vehicle, (CustomPacketPayload)new EntityStartRidingPacket(packet.entityID, vehicle.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        });
    }
}

