/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_twilight_forest.item.relic;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.hurts.octostudios.reliquified_twilight_forest.api.HurtByTargetGoalWithPredicate;
import it.hurts.octostudios.reliquified_twilight_forest.init.DataComponentRegistry;
import it.hurts.octostudios.reliquified_twilight_forest.init.ItemRegistry;
import it.hurts.octostudios.reliquified_twilight_forest.item.BundleLikeRelicItem;
import it.hurts.octostudios.reliquified_twilight_forest.item.Gem;
import it.hurts.octostudios.reliquified_twilight_forest.item.ability.LichCrownAbilities;
import it.hurts.octostudios.reliquified_twilight_forest.mixin.NearestAttackableTargetGoalAccessor;
import it.hurts.sskirillss.relics.client.models.items.CurioModel;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;
import twilightforest.components.entity.FortificationShieldAttachment;
import twilightforest.data.tags.EntityTagGenerator;
import twilightforest.entity.monster.LoyalZombie;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFDataAttachments;
import twilightforest.item.LifedrainScepterItem;
import twilightforest.loot.TFLootTables;
import twilightforest.util.entities.EntityUtil;

@EventBusSubscriber
public class LichCrownItem
extends BundleLikeRelicItem
implements IRenderableCurio {
    public static final Predicate<LivingEntity> HAS_CROWN = target -> !EntityUtils.findEquippedCurio((Entity)target, (Item)((Item)ItemRegistry.LICH_CROWN.get())).isEmpty();

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"bone_pact").maxLevel(0).build()).ability(AbilityData.builder((String)"soulbound_gems").stat(StatData.builder((String)"gem_amount").initialValue(1.0, 3.0).formatValue(Math::round).upgradeModifier(UpgradeOperation.ADD, 1.0).build()).maxLevel(15).build()).ability(LichCrownAbilities.ZOMBIE).ability(LichCrownAbilities.TWILIGHT).ability(LichCrownAbilities.LIFEDRAIN).ability(LichCrownAbilities.FORTIFICATION).ability(LichCrownAbilities.FROSTBITE).build()).leveling(LevelingData.builder().initialCost(250).step(250).maxLevel(15).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"zombie").gem(GemShape.SQUARE, GemColor.GREEN).build()).source(LevelingSourceData.abilityBuilder((String)"twilight").gem(GemShape.SQUARE, GemColor.BLUE).build()).source(LevelingSourceData.abilityBuilder((String)"lifedrain").gem(GemShape.SQUARE, GemColor.RED).build()).source(LevelingSourceData.abilityBuilder((String)"fortification").gem(GemShape.SQUARE, GemColor.YELLOW).build()).source(LevelingSourceData.abilityBuilder((String)"frostbite").gem(GemShape.SQUARE, GemColor.CYAN).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-11579822).borderBottom(-12238004).textured(true).build()).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof LichCrownItem)) {
            return;
        }
        LichCrownItem relic = (LichCrownItem)item;
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity.level().isClientSide) {
            return;
        }
        if (relic.isAbilityUnlocked(stack, "zombie")) {
            LichCrownAbilities.zombieTick(livingEntity, stack);
        }
        if (relic.isAbilityUnlocked(stack, "twilight")) {
            LichCrownAbilities.twilightTick(livingEntity, stack);
        }
        if (relic.isAbilityUnlocked(stack, "lifedrain")) {
            LichCrownAbilities.lifedrainTick(livingEntity, stack);
        }
        if (relic.isAbilityUnlocked(stack, "fortification")) {
            LichCrownAbilities.fortificationTick(livingEntity, stack);
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LichCrownItem newRelic;
        super.onUnequip(slotContext, newStack, stack);
        Item item = newStack.getItem();
        if (item instanceof LichCrownItem && (newRelic = (LichCrownItem)item).getAbilitiesComponent(newStack).equals((Object)this.getAbilitiesComponent(stack)) || slotContext.entity().level().isClientSide) {
            return;
        }
        if (slotContext.entity().level().isClientSide) {
            return;
        }
        LichCrownAbilities.fortificationUnequip(slotContext, stack);
        LichCrownAbilities.zombieUnequip(slotContext, stack);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        Player player;
        LichCrownItem relic;
        block3: {
            block2: {
                super.inventoryTick(stack, level, entity, slotId, isSelected);
                Item item = stack.getItem();
                if (!(item instanceof LichCrownItem)) break block2;
                relic = (LichCrownItem)item;
                if (!(entity instanceof Player)) break block2;
                player = (Player)entity;
                if (!player.level().isClientSide) break block3;
            }
            return;
        }
        relic.dropExcessive(player, stack);
    }

    @SubscribeEvent
    public static void onEntitySpawn(EntityJoinLevelEvent event) {
        if (event.getLevel().isClientSide) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof AbstractSkeleton)) {
            return;
        }
        AbstractSkeleton skeleton = (AbstractSkeleton)entity;
        skeleton.targetSelector.getAvailableGoals().removeIf(goal -> {
            NearestAttackableTargetGoal g;
            Goal patt0$temp = goal.getGoal();
            return patt0$temp instanceof NearestAttackableTargetGoal && ((NearestAttackableTargetGoalAccessor)(g = (NearestAttackableTargetGoal)patt0$temp)).getTargetType().isAssignableFrom(Player.class);
        });
        skeleton.targetSelector.getAvailableGoals().removeIf(goal -> goal.getGoal() instanceof HurtByTargetGoal);
        skeleton.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)skeleton, Player.class, true, HAS_CROWN.negate()));
        skeleton.targetSelector.addGoal(1, (Goal)new HurtByTargetGoalWithPredicate((PathfinderMob)skeleton, TargetingConditions.forCombat().ignoreLineOfSight().ignoreInvisibilityTesting().selector(HAS_CROWN.negate()), new Class[0]));
    }

    @SubscribeEvent
    public static void onLivingEntityTick(EntityTickEvent.Post e) {
        AbstractSkeleton skeleton;
        block3: {
            block2: {
                LivingEntity livingEntity;
                Entity entity = e.getEntity();
                if (entity.level().isClientSide || entity.tickCount % 10 != 0 || !(entity instanceof AbstractSkeleton) || !((livingEntity = (skeleton = (AbstractSkeleton)entity).getTarget()) instanceof Player)) break block2;
                Player player = (Player)livingEntity;
                if (!HAS_CROWN.negate().test((LivingEntity)player)) break block3;
            }
            return;
        }
        skeleton.setTarget(null);
    }

    @Override
    public int getMaxSlots(ItemStack stack) {
        return (int)Math.round(this.getStatValue(stack, "soulbound_gems", "gem_amount"));
    }

    @Override
    public void onContentsChanged(Player player, ItemStack stack, List<ItemStack> oldContents) {
        if (player.level().isClientSide) {
            return;
        }
        ServerLevel level = (ServerLevel)player.level();
        int oldShielding = this.getItemCount(stack, (Item)ItemRegistry.SHIELDING_GEM.get(), oldContents);
        int oldNecromancy = this.getItemCount(stack, (Item)ItemRegistry.NECROMANCY_GEM.get(), oldContents);
        int shielding = this.getItemCount(stack, (Item)ItemRegistry.SHIELDING_GEM.get());
        int necromancy = this.getItemCount(stack, (Item)ItemRegistry.NECROMANCY_GEM.get());
        int maxShields = shielding < 1 ? 0 : (int)Math.round(this.getStatValue(stack, "fortification", "max_shields"));
        int maxZombies = necromancy < 1 ? 0 : (int)Math.round(this.getStatValue(stack, "zombie", "max_zombies"));
        FortificationShieldAttachment attachment = (FortificationShieldAttachment)player.getData((Supplier)TFDataAttachments.FORTIFICATION_SHIELDS);
        ArrayList zombies = Lists.newArrayList((Iterable)((Iterable)stack.getOrDefault(DataComponentRegistry.ZOMBIES, List.of())));
        if (shielding < oldShielding && attachment.permanentShieldsLeft() > maxShields) {
            attachment.setShields((LivingEntity)player, maxShields, false);
        }
        if (necromancy < oldNecromancy && zombies.size() > maxZombies) {
            ArrayList toClear = maxZombies < 1 ? zombies : zombies.subList(Math.max((int)Math.round(this.getStatValue(stack, "zombie", "max_zombies")), zombies.size()) - 1, zombies.size());
            toClear.forEach(uuid -> {
                Entity patt0$temp = level.getEntity(uuid);
                if (patt0$temp instanceof LoyalZombie) {
                    LoyalZombie zombie = (LoyalZombie)patt0$temp;
                    zombie.discard();
                }
            });
            toClear.clear();
            stack.set(DataComponentRegistry.ZOMBIES, (Object)zombies);
        }
    }

    @Override
    public Predicate<ItemStack> getPredicate() {
        return stack -> stack.getItem() instanceof Gem;
    }

    public int getAbilityLevel(ItemStack stack, String ability) {
        return switch (ability) {
            case "fortification" -> this.getItemCount(stack, (Item)ItemRegistry.SHIELDING_GEM.get());
            case "zombie" -> this.getItemCount(stack, (Item)ItemRegistry.NECROMANCY_GEM.get());
            case "twilight" -> this.getItemCount(stack, (Item)ItemRegistry.TWILIGHT_GEM.get());
            case "lifedrain" -> this.getItemCount(stack, (Item)ItemRegistry.ABSORPTION_GEM.get());
            case "frostbite" -> this.getItemCount(stack, (Item)ItemRegistry.FROST_GEM.get());
            default -> super.getAbilityLevel(stack, ability);
        };
    }

    public int getAbilityMaxLevel(ItemStack stack, String ability) {
        return switch (ability) {
            case "fortification", "zombie", "twilight", "lifedrain", "frostbite" -> (int)Math.round(this.getStatValue(stack, "soulbound_gems", "gem_amount"));
            default -> super.getAbilityMaxLevel(stack, ability);
        };
    }

    public boolean mayUpgrade(ItemStack stack, String ability) {
        return switch (ability) {
            case "fortification", "zombie", "twilight", "lifedrain", "frostbite" -> false;
            default -> super.mayUpgrade(stack, ability);
        };
    }

    public boolean mayReset(ItemStack stack, String ability) {
        return switch (ability) {
            case "fortification", "zombie", "twilight", "lifedrain", "frostbite" -> false;
            default -> super.mayReset(stack, ability);
        };
    }

    public boolean isAbilityEnabled(ItemStack stack, String ability) {
        return switch (ability) {
            case "fortification", "zombie", "twilight", "lifedrain", "frostbite" -> {
                if (this.getAbilityLevel(stack, ability) > 0) {
                    yield true;
                }
                yield false;
            }
            default -> super.isAbilityEnabled(stack, ability);
        };
    }

    public boolean isAbilityUpgradeEnabled(ItemStack stack, String ability) {
        return switch (ability) {
            case "fortification", "zombie", "twilight", "lifedrain", "frostbite" -> false;
            default -> super.isAbilityUpgradeEnabled(stack, ability);
        };
    }

    public boolean isAbilityResetEnabled(ItemStack stack, String ability) {
        return switch (ability) {
            case "fortification", "zombie", "twilight", "lifedrain", "frostbite" -> false;
            default -> super.isAbilityResetEnabled(stack, ability);
        };
    }

    public boolean isRelicFlawless(ItemStack stack) {
        return this.isAbilityFlawless(stack, "soulbound_gems") && this.isAbilityMaxLevel(stack, "soulbound_gems") && this.getContents(stack).size() >= this.getMaxSlots(stack);
    }

    public static void makeRedMagicTrail(Level level, LivingEntity source, Vec3 target) {
        float r = 1.0f;
        float g = 0.5f;
        float b = 0.5f;
        Vec3 pos = source.position().add(0.0, (double)(source.getBbHeight() / 2.0f), 0.0);
        double distance = pos.distanceTo(target);
        for (double i = 0.0; i <= distance * 6.0; i += 1.0) {
            Vec3 particlePos = pos.subtract(target).scale(i / (distance * 6.0));
            particlePos = pos.subtract(particlePos);
            level.addParticle(ParticleUtils.constructSimpleSpark((Color)new Color(r, g, b, 0.25f), (float)0.35f, (int)20, (float)0.75f), particlePos.x, particlePos.y, particlePos.z, 0.0, 0.05, 0.0);
        }
    }

    public static void explodeEntity(LivingEntity living, LivingEntity target, DamageSource damageSource) {
        SoundEvent deathSound;
        Level level = target.level();
        if (!target.getType().is(EntityTagGenerator.LIFEDRAIN_DROPS_NO_FLESH) && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (living instanceof Player) {
                Player player = (Player)living;
                LootParams ctx = new LootParams.Builder(serverLevel).withParameter(LootContextParams.THIS_ENTITY, (Object)target).withParameter(LootContextParams.ORIGIN, (Object)target.getEyePosition()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)damageSource).withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)player).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)player).withParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)player).create(LootContextParamSets.ENTITY);
                serverLevel.getServer().reloadableRegistries().getLootTable(TFLootTables.LIFEDRAIN_SCEPTER_KILL_BONUS).getRandomItems(ctx).forEach(arg_0 -> ((LivingEntity)target).spawnAtLocation(arg_0));
                LifedrainScepterItem.animateTargetShatter((ServerLevel)serverLevel, (LivingEntity)target);
            }
        }
        if (target instanceof Mob) {
            Mob mob = (Mob)target;
            mob.spawnAnim();
        }
        if ((deathSound = EntityUtil.getDeathSound((LivingEntity)target)) != null) {
            level.playSound(null, target.blockPosition(), deathSound, SoundSource.HOSTILE, 1.0f, target.getVoicePitch());
        }
        if (!target.isDeadOrDying()) {
            if (target instanceof Player) {
                target.hurt(TFDamageTypes.getEntityDamageSource((Level)level, (ResourceKey)TFDamageTypes.LIFEDRAIN, (Entity)living, (EntityType[])new EntityType[0]), Float.MAX_VALUE);
            } else {
                target.die(TFDamageTypes.getEntityDamageSource((Level)level, (ResourceKey)TFDamageTypes.LIFEDRAIN, (Entity)living, (EntityType[])new EntityType[0]));
                target.discard();
            }
        }
    }

    @Override
    public String getConfigRoute() {
        return "reliquified_twilight_forest";
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<String> headParts() {
        return List.of("head");
    }

    @OnlyIn(value=Dist.CLIENT)
    public LayerDefinition constructLayerDefinition() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition bone = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 22).addBox(-2.5f, -9.0f, -4.5f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.005f)).texOffs(0, 33).addBox(-2.5f, -9.0f, 2.5f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(16, 29).addBox(-1.0f, -7.0f, -4.5f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(12, 26).addBox(-0.5f, -16.0f, -3.5f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(30, 4).addBox(-4.5f, -7.0f, -4.5f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(30, 6).addBox(2.5f, -7.0f, -4.5f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(30, 4).addBox(-4.5f, -7.0f, 4.5f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(30, 4).addBox(-4.499f, -7.0f, 2.501f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(30, 4).addBox(-4.499f, -7.0f, -4.499f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(30, 4).addBox(4.501f, -7.0f, -4.499f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(30, 4).addBox(4.501f, -7.0f, 2.501f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(30, 4).addBox(-4.5f, -7.0f, 4.5f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(16, 29).addBox(-1.0f, -7.0f, 4.5f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(30, 6).addBox(2.5f, -7.0f, 4.5f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(14, 22).addBox(2.5f, -14.0f, -4.5f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(22, 20).addBox(-4.5f, -14.0f, -4.5f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(22, 4).addBox(-1.0f, -15.0f, -4.5f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(30, 4).addBox(2.5f, -11.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(30, 4).addBox(-4.5f, -11.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(14, 22).addBox(2.5f, -14.0f, 2.5f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(22, 4).addBox(-1.0f, -15.0f, 2.5f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(22, 20).addBox(-4.5f, -14.0f, 2.5f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(12, 26).addBox(-0.5f, -16.0f, 3.5f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-4.5f, -9.0f, -4.5f, 2.0f, 2.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(0, 11).addBox(2.5f, -9.0f, -4.5f, 2.0f, 2.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @OnlyIn(value=Dist.CLIENT)
    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CurioModel model = this.getModel(stack);
        matrixStack.pushPose();
        LivingEntity entity = slotContext.entity();
        ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{model});
        model.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTicks);
        model.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        VertexConsumer vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.entityCutout((ResourceLocation)this.getTexture(stack)), (boolean)stack.hasFoil());
        matrixStack.scale(1.0047f, 1.0047f, 1.0047f);
        model.renderToBuffer(matrixStack, vertexconsumer, light, OverlayTexture.NO_OVERLAY);
        matrixStack.popPose();
    }
}

