/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_twilight_forest.item.relic;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.hurts.octostudios.reliquified_twilight_forest.data.loot.LootEntries;
import it.hurts.octostudios.reliquified_twilight_forest.network.CastRideAlongAbilityPacket;
import it.hurts.octostudios.reliquified_twilight_forest.network.EntityStopRidingPacket;
import it.hurts.octostudios.reliquified_twilight_forest.util.MathButCool;
import it.hurts.sskirillss.relics.client.models.items.CurioModel;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityMountEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

@EventBusSubscriber
public class DeerAntlerItem
extends RelicItem
implements IRenderableCurio {
    public static final String ON_ANTLERS = "reliquified_twilight_forest:on_antlers";

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"ride_along").stat(StatData.builder((String)"entity_volume").initialValue(0.5, 2.0).upgradeModifier(UpgradeOperation.MULTIPLY_TOTAL, 1.0).formatValue(MathButCool::roundSingleDigit).build()).active(CastData.builder().type(CastType.INSTANTANEOUS).build()).build()).build()).leveling(LevelingData.builder().sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"ride_along").gem(GemShape.SQUARE, GemColor.ORANGE).build()).build()).maxLevel(5).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.TWILIGHT}).build()).style(StyleData.builder().beams(BeamsData.builder().startColor(-2080756).endColor(8929548).build()).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Item item;
        super.curioTick(slotContext, stack);
        LivingEntity entity = slotContext.entity();
        if (entity.level().isClientSide || entity.tickCount % 60 != 0 || entity.getPassengers().isEmpty() || !((Entity)entity.getPassengers().getFirst()).getPersistentData().getBoolean(ON_ANTLERS) || !((item = stack.getItem()) instanceof DeerAntlerItem)) {
            return;
        }
        DeerAntlerItem relic = (DeerAntlerItem)item;
        relic.spreadRelicExperience(entity, stack, 1);
    }

    public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
        LivingEntity passenger;
        EntityHitResult result;
        super.castActiveAbility(stack, player, ability, type, stage);
        if (!player.level().isClientSide || !ability.equals("ride_along") || stage != CastStage.END) {
            return;
        }
        boolean isMounting = player.getPassengers().isEmpty();
        int passengerId = -1;
        EntityHitResult entityHitResult = DeerAntlerItem.getEntityLookingAt(player, player.entityInteractionRange());
        if (entityHitResult instanceof EntityHitResult && (entityHitResult = (result = entityHitResult).getEntity()) instanceof LivingEntity && DeerAntlerItem.getBoundingBoxVolume((passenger = (LivingEntity)entityHitResult).getBoundingBox()) <= this.getStatValue(stack, ability, "entity_volume")) {
            passengerId = passenger.getId();
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new CastRideAlongAbilityPacket(passengerId, isMounting), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static EntityHitResult getEntityLookingAt(Player player, double maxDistance) {
        Vec3 eyePosition = player.getEyePosition(1.0f);
        Vec3 lookVector = player.getViewVector(1.0f);
        Vec3 reachEnd = eyePosition.add(lookVector.scale(maxDistance));
        return ProjectileUtil.getEntityHitResult((Entity)player, (Vec3)eyePosition, (Vec3)reachEnd, (AABB)player.getBoundingBox().expandTowards(lookVector.scale(maxDistance)).inflate(1.0), entity -> entity instanceof LivingEntity && entity.isAlive() && player.hasLineOfSight(entity) && !player.getPassengers().contains(entity) && entity != player, (double)(maxDistance * maxDistance));
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
        if (newStack.getItem() == stack.getItem() || slotContext.entity().level().isClientSide) {
            return;
        }
        if (slotContext.entity().hasPassenger(e -> e.getPersistentData().getBoolean(ON_ANTLERS))) {
            Entity passenger = slotContext.entity().getFirstPassenger();
            passenger.stopRiding();
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)passenger, (CustomPacketPayload)new EntityStopRidingPacket(passenger.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void riding(EntityMountEvent e) {
        if (!e.getLevel().isClientSide && e.isDismounting()) {
            e.getEntityMounting().getPersistentData().remove(ON_ANTLERS);
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)e.getEntityMounting(), (CustomPacketPayload)new EntityStopRidingPacket(e.getEntityMounting().getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void livingDamage(LivingIncomingDamageEvent e) {
        Entity entity = e.getSource().getEntity();
        if (entity != null && entity.isPassenger() && entity.getPersistentData().getBoolean(ON_ANTLERS) && entity.getVehicle() == e.getEntity()) {
            e.setCanceled(true);
        }
    }

    public static double getBoundingBoxVolume(AABB box) {
        return box.getXsize() * box.getYsize() * box.getZsize();
    }

    public String getConfigRoute() {
        return "reliquified_twilight_forest";
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<String> headParts() {
        return List.of("head");
    }

    @OnlyIn(value=Dist.CLIENT)
    public LayerDefinition constructLayerDefinition() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition bone = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(8, 11).addBox(18.4642f, -20.6733f, -0.998f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.005f)).texOffs(14, 23).addBox(18.4642f, -21.6733f, 0.002f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.005f)).texOffs(8, 11).mirror().addBox(-20.4642f, -20.6733f, -0.998f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.005f)).mirror(false).texOffs(14, 23).mirror().addBox(-19.4642f, -21.6733f, 0.002f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.005f)).mirror(false), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition cube_r1 = bone.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(12, 23).mirror().addBox(5.0f, -9.0f, 3.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.005f)).mirror(false), PartPose.offsetAndRotation((float)-21.9278f, (float)-12.3603f, (float)0.005f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r2 = bone.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(10, 23).mirror().addBox(2.0f, -9.0f, 3.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.005f)).mirror(false), PartPose.offsetAndRotation((float)-16.3937f, (float)-10.068f, (float)-6.995f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r3 = bone.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(8, 23).mirror().addBox(2.0f, -9.0f, 3.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.005f)).mirror(false), PartPose.offsetAndRotation((float)-11.326f, (float)-14.4632f, (float)2.005f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r4 = bone.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(22, 10).mirror().addBox(2.0f, -9.0f, 3.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.005f)).mirror(false).texOffs(16, 11).mirror().addBox(1.0f, -8.0f, 2.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-8.2346f, (float)-8.8478f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r5 = bone.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(0, 4).mirror().addBox(-4.0f, -14.0f, 4.0f, 2.0f, 13.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(8, 4).mirror().addBox(-4.0f, -1.0f, 1.0f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(24, 10).mirror().addBox(1.0f, -1.0f, 1.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 19).mirror().addBox(-7.0f, -8.0f, -5.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(22, 4).mirror().addBox(-7.0f, -1.0f, -5.0f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 0).mirror().addBox(-12.0f, -1.0f, -1.0f, 18.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-9.0f, (float)-7.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r6 = bone.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(16, 22).mirror().addBox(-12.0f, -8.0f, 0.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(24, 15).mirror().addBox(-12.0f, -1.0f, -1.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-7.1522f, (float)-6.2346f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r7 = bone.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(12, 23).addBox(-6.0f, -9.0f, 3.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.005f)), PartPose.offsetAndRotation((float)21.9278f, (float)-12.3603f, (float)0.005f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r8 = bone.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(10, 23).addBox(-3.0f, -9.0f, 3.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.005f)), PartPose.offsetAndRotation((float)16.3937f, (float)-10.068f, (float)-6.995f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r9 = bone.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(8, 23).addBox(-3.0f, -9.0f, 3.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.005f)), PartPose.offsetAndRotation((float)11.326f, (float)-14.4632f, (float)2.005f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r10 = bone.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(22, 10).addBox(-3.0f, -9.0f, 3.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.005f)).texOffs(16, 11).addBox(-3.0f, -8.0f, 2.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.2346f, (float)-8.8478f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r11 = bone.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(0, 4).addBox(2.0f, -14.0f, 4.0f, 2.0f, 13.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(8, 4).addBox(2.0f, -1.0f, 1.0f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(24, 10).addBox(-3.0f, -1.0f, 1.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 19).addBox(5.0f, -8.0f, -5.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(22, 4).addBox(5.0f, -1.0f, -5.0f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-6.0f, -1.0f, -1.0f, 18.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)9.0f, (float)-7.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r12 = bone.addOrReplaceChild("cube_r12", CubeListBuilder.create().texOffs(16, 22).addBox(10.0f, -8.0f, 0.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(24, 15).addBox(10.0f, -1.0f, -1.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)7.1522f, (float)-6.2346f, (float)2.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @OnlyIn(value=Dist.CLIENT)
    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CurioModel model = this.getModel(stack);
        matrixStack.pushPose();
        LivingEntity entity = slotContext.entity();
        ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{model});
        model.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTicks);
        model.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        VertexConsumer vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)this.getTexture(stack)), (boolean)stack.hasFoil());
        model.renderToBuffer(matrixStack, vertexconsumer, light, OverlayTexture.NO_OVERLAY);
        matrixStack.popPose();
    }
}

