/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_twilight_forest.item.ability;

import com.google.common.collect.Lists;
import it.hurts.octostudios.reliquified_twilight_forest.init.DataComponentRegistry;
import it.hurts.octostudios.reliquified_twilight_forest.init.ItemRegistry;
import it.hurts.octostudios.reliquified_twilight_forest.item.relic.LichCrownItem;
import it.hurts.octostudios.reliquified_twilight_forest.network.LaunchTwilightBoltPacket;
import it.hurts.octostudios.reliquified_twilight_forest.network.LifedrainParticlePacket;
import it.hurts.octostudios.reliquified_twilight_forest.util.EntitiesButCool;
import it.hurts.octostudios.reliquified_twilight_forest.util.MathButCool;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import top.theillusivec4.curios.api.SlotContext;
import twilightforest.components.entity.FortificationShieldAttachment;
import twilightforest.entity.monster.LoyalZombie;
import twilightforest.entity.projectile.TwilightWandBolt;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFDataAttachments;
import twilightforest.init.TFEntities;
import twilightforest.init.TFSounds;
import twilightforest.item.LifedrainScepterItem;

public class LichCrownAbilities {
    public static final int MAX_LIFEDRAIN_TIME = 100;
    public static final int MAX_TWILIGHT_TIME = 50;
    public static final AbilityData FORTIFICATION = AbilityData.builder((String)"fortification").stat(StatData.builder((String)"max_shields").initialValue(3.0, 5.0).upgradeModifier(UpgradeOperation.ADD, 1.0).formatValue(Math::round).build()).stat(StatData.builder((String)"interval").initialValue(200.0, 160.0).upgradeModifier(UpgradeOperation.MULTIPLY_TOTAL, -0.125).formatValue(MathButCool::ticksToSecondsAndRoundSingleDigit).build()).build();
    public static final AbilityData ZOMBIE = AbilityData.builder((String)"zombie").stat(StatData.builder((String)"max_zombies").initialValue(1.0, 2.0).upgradeModifier(UpgradeOperation.ADD, 1.0).formatValue(Math::round).build()).stat(StatData.builder((String)"damage").initialValue(2.0, 3.0).upgradeModifier(UpgradeOperation.ADD, 0.5).formatValue(MathButCool::roundSingleDigit).build()).stat(StatData.builder((String)"interval").initialValue(400.0, 320.0).upgradeModifier(UpgradeOperation.MULTIPLY_TOTAL, (double)-0.075f).formatValue(MathButCool::ticksToSecondsAndRoundSingleDigit).build()).build();
    public static final AbilityData TWILIGHT = AbilityData.builder((String)"twilight").stat(StatData.builder((String)"damage").initialValue(3.0, 4.0).upgradeModifier(UpgradeOperation.ADD, 0.5).formatValue(MathButCool::roundSingleDigit).build()).stat(StatData.builder((String)"speed_scale").initialValue(0.9, 1.2).upgradeModifier(UpgradeOperation.ADD, 0.1).formatValue(MathButCool::roundSingleDigit).build()).build();
    public static final AbilityData LIFEDRAIN = AbilityData.builder((String)"lifedrain").stat(StatData.builder((String)"heal_percentage").initialValue(0.0075, 0.015).upgradeModifier(UpgradeOperation.ADD, 0.0035).formatValue(value -> MathButCool.roundSingleDigit(value * 400.0)).build()).stat(StatData.builder((String)"radius").initialValue(2.0, 5.0).upgradeModifier(UpgradeOperation.ADD, 0.5).formatValue(MathButCool::roundSingleDigit).build()).stat(StatData.builder((String)"interval").initialValue(300.0, 260.0).upgradeModifier(UpgradeOperation.MULTIPLY_TOTAL, (double)-0.1f).formatValue(MathButCool::ticksToSecondsAndRoundSingleDigit).build()).build();
    public static final AbilityData FROSTBITE = AbilityData.builder((String)"frostbite").stat(StatData.builder((String)"duration").initialValue(80.0, 100.0).upgradeModifier(UpgradeOperation.ADD, 10.0).formatValue(MathButCool::ticksToSecondsAndRoundSingleDigit).build()).build();

    public static void fortificationTick(LivingEntity entity, ItemStack stack) {
        Item item;
        if (entity.isSpectator() || !((item = stack.getItem()) instanceof LichCrownItem)) {
            return;
        }
        LichCrownItem relic = (LichCrownItem)item;
        FortificationShieldAttachment attachment = (FortificationShieldAttachment)entity.getData((Supplier)TFDataAttachments.FORTIFICATION_SHIELDS);
        int maxTime = (int)Math.round(relic.getStatValue(stack, "fortification", "interval"));
        int time = (Integer)stack.getOrDefault(DataComponentRegistry.FORTIFICATION_TIME, (Object)0);
        if ((double)attachment.permanentShieldsLeft() < relic.getStatValue(stack, "fortification", "max_shields")) {
            if (time <= 0) {
                attachment.addShields(entity, 1, false);
                time = maxTime;
                relic.spreadRelicExperience(entity, stack, 1);
            } else {
                --time;
            }
        }
        stack.set(DataComponentRegistry.FORTIFICATION_TIME, (Object)time);
    }

    public static void fortificationUnequip(SlotContext slotContext, ItemStack stack) {
        ((FortificationShieldAttachment)slotContext.entity().getData((Supplier)TFDataAttachments.FORTIFICATION_SHIELDS)).setShields(slotContext.entity(), 0, false);
    }

    public static void zombieUnequip(SlotContext slotContext, ItemStack stack) {
        ArrayList uuids = Lists.newArrayList((Iterable)((Iterable)stack.getOrDefault(DataComponentRegistry.ZOMBIES, List.of())));
        uuids.forEach(uuid -> {
            Entity entity = ((ServerLevel)slotContext.entity().level()).getEntity(uuid);
            if (entity != null) {
                entity.discard();
            }
        });
        uuids.clear();
        stack.set(DataComponentRegistry.ZOMBIES, List.of());
    }

    public static void lifedrainTick(LivingEntity entity, ItemStack stack) {
        LichCrownItem relic;
        block11: {
            block10: {
                Item item;
                if (entity.isSpectator() || !((item = stack.getItem()) instanceof LichCrownItem)) break block10;
                relic = (LichCrownItem)item;
                if (entity.isAlive()) break block11;
            }
            return;
        }
        int maxTime = (int)Math.round(relic.getStatValue(stack, "lifedrain", "interval")) + 100;
        int time = (Integer)stack.getOrDefault(DataComponentRegistry.LIFEDRAIN_TIME, (Object)0);
        float healAmount = (float)((double)entity.getMaxHealth() * relic.getStatValue(stack, "lifedrain", "heal_percentage"));
        DamageSource dmg = TFDamageTypes.getEntityDamageSource((Level)entity.level(), (ResourceKey)TFDamageTypes.LIFEDRAIN, (Entity)entity, (EntityType[])new EntityType[0]);
        if (time > maxTime - 100 && entity.getHealth() < entity.getMaxHealth() && entity.tickCount % 5 == 0) {
            List<LivingEntity> toAbsorb = EntitiesButCool.findEligibleEntities(entity, relic.getStatValue(stack, "lifedrain", "radius"), e -> !EntityUtils.isAlliedTo((Entity)entity, (Entity)e) && e.isAlive() && entity.hasLineOfSight((Entity)e));
            toAbsorb.forEach(toHurt -> {
                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)new LifedrainParticlePacket(entity.getId(), toHurt.getEyePosition()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                if (toHurt.getHealth() <= healAmount / (float)toAbsorb.size() && !toHurt.getType().is(Tags.EntityTypes.BOSSES)) {
                    LichCrownItem.explodeEntity(entity, toHurt, dmg);
                    return;
                }
                toHurt.invulnerableTime = 0;
                if (!toHurt.hurt(dmg, healAmount / (float)toAbsorb.size())) {
                    return;
                }
                if (toHurt.getMaxHealth() <= entity.getMaxHealth()) {
                    toHurt.setDeltaMovement(0.0, 0.15, 0.0);
                } else {
                    toHurt.setDeltaMovement(0.0, 0.0, 0.0);
                }
            });
            entity.heal(healAmount);
            if (!toAbsorb.isEmpty()) {
                entity.level().playSound(null, entity.blockPosition(), (SoundEvent)TFSounds.LIFE_SCEPTER_DRAIN.get(), SoundSource.PLAYERS);
                if (entity.tickCount % 10 == 0) {
                    relic.spreadRelicExperience(entity, stack, 1);
                }
            }
        }
        if (time <= 0) {
            if (entity.getHealth() / entity.getMaxHealth() <= 0.2f) {
                time = maxTime;
            }
        } else {
            --time;
        }
        stack.set(DataComponentRegistry.LIFEDRAIN_TIME, (Object)time);
    }

    public static void twilightTick(LivingEntity entity, ItemStack stack) {
        Item item;
        if (entity.isSpectator() || !((item = stack.getItem()) instanceof LichCrownItem)) {
            return;
        }
        LichCrownItem relic = (LichCrownItem)item;
        int time = (Integer)stack.getOrDefault(DataComponentRegistry.TWILIGHT_TIME, (Object)0);
        if (time > 0) {
            --time;
        }
        stack.set(DataComponentRegistry.TWILIGHT_TIME, (Object)time);
    }

    public static void zombieTick(LivingEntity entity, ItemStack stack) {
        Item item;
        if (entity.isSpectator() || !((item = stack.getItem()) instanceof LichCrownItem)) {
            return;
        }
        LichCrownItem relic = (LichCrownItem)item;
        int time = (Integer)stack.getOrDefault(DataComponentRegistry.ZOMBIE_TIME, (Object)0);
        ArrayList uuids = Lists.newArrayList((Iterable)((Iterable)stack.getOrDefault(DataComponentRegistry.ZOMBIES, List.of())));
        int maxZombies = (int)Math.round(relic.getStatValue(stack, "zombie", "max_zombies"));
        if (time <= 0 && uuids.size() < maxZombies) {
            time = (int)Math.round(relic.getStatValue(stack, "zombie", "interval"));
            LoyalZombie zombie = LichCrownAbilities.spawnZombie(entity, (float)relic.getStatValue(stack, "zombie", "damage"), entity.blockPosition());
            if (zombie != null) {
                relic.spreadRelicExperience(entity, stack, 1);
                uuids.add(zombie.getUUID());
            }
        }
        if (time > 0) {
            --time;
        }
        stack.set(DataComponentRegistry.ZOMBIE_TIME, (Object)time);
        if (entity.tickCount % 15 == 0) {
            uuids.removeIf(uuid -> {
                boolean flag;
                Entity e = ((ServerLevel)entity.level()).getEntity(uuid);
                if (e == null) {
                    return true;
                }
                boolean bl = flag = !e.isAlive() || !((ServerLevel)entity.level()).isPositionEntityTicking(e.blockPosition());
                if (flag) {
                    e.discard();
                }
                return flag;
            });
        }
        stack.set(DataComponentRegistry.ZOMBIES, (Object)uuids);
    }

    public static LoyalZombie spawnZombie(LivingEntity entity, final float damage, BlockPos position) {
        final Level level = entity.level();
        LoyalZombie zombie = new LoyalZombie((EntityType)TFEntities.LOYAL_ZOMBIE.get(), level){

            public boolean doHurtTarget(Entity entity) {
                if (entity.hurt(this.damageSources().mobAttack((LivingEntity)this), damage)) {
                    entity.push(0.0, 0.2, 0.0);
                    return true;
                }
                return false;
            }

            public InteractionResult interactAt(Player player, Vec3 vec3, InteractionHand hand) {
                return InteractionResult.PASS;
            }

            public void aiStep() {
                if (!this.hasEffect(MobEffects.DAMAGE_BOOST)) {
                    if (!level.isClientSide) {
                        LifedrainScepterItem.animateTargetShatter((ServerLevel)((ServerLevel)level), (LivingEntity)this);
                    }
                    this.hurt(TFDamageTypes.getDamageSource((Level)this.level(), (ResourceKey)TFDamageTypes.EXPIRED, (EntityType[])new EntityType[0]), Float.MAX_VALUE);
                    this.discard();
                }
                super.aiStep();
            }
        };
        zombie.moveTo(LichCrownAbilities.findSafeSpawn(position, (ServerLevel)level, 3).getBottomCenter());
        if (!level.noCollision((Entity)zombie, zombie.getBoundingBox())) {
            return null;
        }
        zombie.spawnAnim();
        zombie.setTame(true, false);
        zombie.setOwnerUUID(entity.getUUID());
        zombie.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, Integer.MAX_VALUE, 0, true, false, false));
        zombie.setBaby(true);
        level.addFreshEntity((Entity)zombie);
        level.gameEvent((Entity)entity, (Holder)GameEvent.ENTITY_PLACE, position);
        zombie.playSound((SoundEvent)TFSounds.ZOMBIE_SCEPTER_USE.get(), 1.0f, 1.0f);
        zombie.setSilent(true);
        return zombie;
    }

    public static BlockPos findSafeSpawn(BlockPos position, ServerLevel world, int radius) {
        Random random = new Random();
        for (int attempts = 0; attempts < 10; ++attempts) {
            int zOffset;
            int xOffset = random.nextInt(radius * 2) - radius;
            BlockPos potentialPos = position.offset(xOffset, 0, zOffset = random.nextInt(radius * 2) - radius);
            BlockPos spawnPos = world.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, potentialPos);
            if (!LichCrownAbilities.isSafe(spawnPos, world)) continue;
            return spawnPos;
        }
        return position;
    }

    public static boolean isSafe(BlockPos pos, ServerLevel world) {
        return world.getBlockState(pos).isAir() && world.getBlockState(pos.below()).isSolid() && world.getBlockState(pos.below()).getBlock() != Blocks.LAVA;
    }

    @EventBusSubscriber(value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void swingEvent(PlayerInteractEvent.LeftClickEmpty e) {
            Player player = e.getEntity();
            if (player.isSpectator()) {
                return;
            }
            double maxDistance = 64.0;
            EntityHitResult target = ClientEvents.getEntityLookingAt(player, maxDistance);
            if (target != null && target.getEntity() instanceof LivingEntity) {
                PacketDistributor.sendToServer((CustomPacketPayload)new LaunchTwilightBoltPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static EntityHitResult getEntityLookingAt(Player player, double maxDistance) {
            Vec3 eyePosition = player.getEyePosition(1.0f);
            Vec3 lookVector = player.getViewVector(1.0f);
            Vec3 reachEnd = eyePosition.add(lookVector.scale(maxDistance));
            return ProjectileUtil.getEntityHitResult((Entity)player, (Vec3)eyePosition, (Vec3)reachEnd, (AABB)player.getBoundingBox().expandTowards(lookVector.scale(maxDistance)).inflate(1.0), entity -> entity instanceof LivingEntity && entity.isAlive() && player.hasLineOfSight(entity) && entity != player && !EntityUtils.isAlliedTo((Entity)player, (Entity)entity), (double)(maxDistance * maxDistance));
        }
    }

    @EventBusSubscriber
    public static class CommonEvents {
        @SubscribeEvent
        public static void applyFrostbite(LivingDamageEvent.Post e) {
            LichCrownItem relic;
            Player player;
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)e.getSource().getEntity(), (Item)((Item)ItemRegistry.LICH_CROWN.get()));
            Entity entity = e.getSource().getEntity();
            if (!(entity instanceof Player) || (player = (Player)entity) == e.getEntity() || player.level().isClientSide || !((entity = stack.getItem()) instanceof LichCrownItem) || !(relic = (LichCrownItem)entity).isAbilityUnlocked(stack, "frostbite")) {
                return;
            }
            e.getEntity().setTicksFrozen(e.getEntity().getTicksFrozen() + (int)Math.round(relic.getStatValue(stack, "frostbite", "duration")));
            relic.spreadRelicExperience((LivingEntity)player, stack, 1);
        }

        @SubscribeEvent
        public static void onTwilightBoltHit(LivingDamageEvent.Post e) {
            LichCrownItem relic;
            Player player;
            ItemStack stack;
            block3: {
                block2: {
                    stack = EntityUtils.findEquippedCurio((Entity)e.getSource().getEntity(), (Item)((Item)ItemRegistry.LICH_CROWN.get()));
                    Entity entity = e.getSource().getDirectEntity();
                    if (!(entity instanceof TwilightWandBolt)) break block2;
                    TwilightWandBolt bolt = (TwilightWandBolt)entity;
                    entity = e.getSource().getEntity();
                    if (!(entity instanceof Player)) break block2;
                    player = (Player)entity;
                    entity = stack.getItem();
                    if (!(entity instanceof LichCrownItem)) break block2;
                    relic = (LichCrownItem)entity;
                    if (bolt.getPersistentData().contains("reliquified_twilight_forest:isCustom")) break block3;
                }
                return;
            }
            relic.spreadRelicExperience((LivingEntity)player, stack, 1);
        }
    }
}

