/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_twilight_forest.entity.projectile;

import it.hurts.octostudios.octolib.modules.particles.OctoRenderManager;
import it.hurts.octostudios.octolib.modules.particles.RenderProvider;
import it.hurts.octostudios.octolib.modules.particles.trail.TrailProvider;
import it.hurts.octostudios.reliquified_twilight_forest.entity.HydraFirePuddleEntity;
import it.hurts.octostudios.reliquified_twilight_forest.init.EntityRegistry;
import it.hurts.octostudios.reliquified_twilight_forest.item.relic.HydraHeartItem;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class HydraFireEntity
extends ThrowableProjectile
implements TrailProvider {
    private static final EntityDataAccessor<ItemStack> RELIC_STACK = SynchedEntityData.defineId(HydraFireEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private int age = 200;

    public void setRelicStack(ItemStack stack) {
        this.getEntityData().set(RELIC_STACK, (Object)stack);
    }

    public ItemStack getRelicStack() {
        return (ItemStack)this.getEntityData().get(RELIC_STACK);
    }

    public HydraFireEntity(EntityType<? extends ThrowableProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public void tick() {
        super.tick();
        Level level = this.getCommandSenderWorld();
        Vec3 particleCenter = this.position().add(this.getDeltaMovement().scale(-1.0));
        if (level.isClientSide) {
            for (int i = 0; i < 3; ++i) {
                level.addParticle(ParticleUtils.constructSimpleSpark((Color)new Color(155 + this.random.nextInt(100), 50 + this.random.nextInt(100), 0), (float)(0.01f + this.random.nextFloat() * Math.min((float)this.tickCount * 0.01f, 0.1f)), (int)(5 + this.random.nextInt(3)), (float)0.9f), particleCenter.x() + (double)(MathUtils.randomFloat((RandomSource)this.random) * 0.05f), particleCenter.y() + (double)(MathUtils.randomFloat((RandomSource)this.random) * 0.05f), particleCenter.z() + (double)(MathUtils.randomFloat((RandomSource)this.random) * 0.05f), 0.0, 0.0, 0.0);
            }
            return;
        }
        if (this.getAge() <= 0) {
            this.discard();
        }
        if (this.isAlive()) {
            int i = this.getAge();
            if (i < 0) {
                this.setAge(++i);
            } else if (i > 0) {
                this.setAge(--i);
            }
        }
    }

    protected double getDefaultGravity() {
        return 0.05;
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        OctoRenderManager.registerProvider((RenderProvider)this);
    }

    public void onRemovedFromLevel() {
        super.onRemovedFromLevel();
        Level level = this.getCommandSenderWorld();
        Vec3 vec = this.position();
        level.playSound(null, this.blockPosition(), SoundEvents.PUFFER_FISH_BLOW_UP, SoundSource.MASTER, 0.5f, 1.5f + this.random.nextFloat() * 0.5f);
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (this.level().isClientSide) {
            return;
        }
        if (result instanceof BlockHitResult) {
            BlockHitResult block = (BlockHitResult)result;
            this.discard();
            ItemStack stack = this.getRelicStack();
            int lifetime = 100;
            float damage = 1.0f;
            Item item = stack.getItem();
            if (item instanceof HydraHeartItem) {
                HydraHeartItem relic = (HydraHeartItem)item;
                item = this.getOwner();
                if (item instanceof Player) {
                    Player player = (Player)item;
                    lifetime = (int)Math.round(relic.getStatValue(stack, "hydra_fire", "lifetime"));
                    damage = (float)relic.getStatValue(stack, "hydra_fire", "damage");
                    relic.spreadRelicExperience((LivingEntity)player, stack, 1);
                }
            }
            HydraFirePuddleEntity puddle = new HydraFirePuddleEntity((EntityType<? extends Entity>)((EntityType)EntityRegistry.HYDRA_FIRE_PUDDLE.get()), this.level());
            puddle.setPos(block.getLocation());
            puddle.setLifetime(lifetime);
            puddle.setDamage(damage);
            puddle.setOwner(this.getOwner());
            this.level().addFreshEntity((Entity)puddle);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(RELIC_STACK, (Object)ItemStack.EMPTY);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.put("relic_stack", this.getRelicStack().save((HolderLookup.Provider)this.registryAccess()));
        tag.putInt("Age", this.getAge());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setRelicStack(ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)tag.getCompound("relic_stack")));
        this.setAge(tag.getInt("Age"));
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public Vec3 getTrailPosition(float partialTicks) {
        return this.getPosition(partialTicks);
    }

    public int getTrailUpdateFrequency() {
        return 1;
    }

    public boolean isTrailAlive() {
        return this.isAlive();
    }

    public boolean isTrailGrowing() {
        return this.tickCount > 1;
    }

    public int getTrailMaxLength() {
        return 3;
    }

    public int getTrailFadeInColor() {
        return -35072;
    }

    public int getTrailFadeOutColor() {
        return 0xFF0000;
    }

    public double getTrailScale() {
        return 0.075f;
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }
}

