/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.multipiston.network;

import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.ldtteam.multipiston.TileEntityMultiPiston;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MultiPistonChangeMessage
extends AbstractServerPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"multipiston", (String)"change_msg", MultiPistonChangeMessage::new);
    private Direction input;
    private Direction output;
    private int range;
    private int speed;
    private BlockPos pos;

    public MultiPistonChangeMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.pos = buf.readBlockPos();
        this.input = Direction.values()[buf.readInt()];
        this.output = Direction.values()[buf.readInt()];
        this.range = buf.readInt();
        this.speed = buf.readInt();
    }

    public MultiPistonChangeMessage(BlockPos pos, Direction input, Direction output, int range, int speed) {
        super(TYPE);
        this.pos = pos;
        this.input = input;
        this.range = range;
        this.output = output;
        this.speed = speed;
    }

    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeInt(this.input.ordinal());
        buf.writeInt(this.output.ordinal());
        buf.writeInt(this.range);
        buf.writeInt(this.speed);
    }

    protected void onExecute(IPayloadContext context, ServerPlayer playerEntity) {
        Level world = playerEntity.level();
        BlockEntity entity = world.getBlockEntity(this.pos);
        if (entity instanceof TileEntityMultiPiston) {
            ((TileEntityMultiPiston)entity).setInput(this.input);
            ((TileEntityMultiPiston)entity).setOutput(this.output);
            ((TileEntityMultiPiston)entity).setRange(this.range);
            ((TileEntityMultiPiston)entity).setSpeed(this.speed);
            BlockState state = world.getBlockState(this.pos);
            world.sendBlockUpdated(this.pos, state, state, 3);
        }
    }
}

