/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.processor.util;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Objects;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;

public class AnnotationHelper {
    public static boolean isDefaultValue(AnnotationMirror mirror, String attributeName) {
        if (mirror == null) {
            return true;
        }
        ExecutableElement attributeElement = null;
        for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
            if (!executableElement.getSimpleName().contentEquals(attributeName)) continue;
            attributeElement = executableElement;
            break;
        }
        if (attributeElement == null) {
            return true;
        }
        AnnotationValue defaultValue = attributeElement.getDefaultValue();
        AnnotationValue annotationValue = mirror.getElementValues().get(attributeElement);
        return Objects.equals(annotationValue, defaultValue);
    }

    public static AnnotationMirror getAnnotationMirror(Element element, Class<? extends Annotation> annotationClass) {
        if (element == null || annotationClass == null) {
            return null;
        }
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(annotationClass.getCanonicalName())) continue;
            return annotationMirror;
        }
        return null;
    }

    public static AnnotationMirror getNestedAnnotationMirror(AnnotationMirror mirror, Class<? extends Annotation> annotationClass) {
        if (mirror == null || mirror.getAnnotationType() == null) {
            return null;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = mirror.getElementValues();
        for (ExecutableElement executableElement : elementValues.keySet()) {
            AnnotationMirror nestedAnnotation;
            AnnotationValue value = elementValues.get(executableElement);
            Object object = value.getValue();
            if (!(object instanceof AnnotationMirror) || !(nestedAnnotation = (AnnotationMirror)object).getAnnotationType().toString().equals(annotationClass.getCanonicalName())) continue;
            return nestedAnnotation;
        }
        return null;
    }

    public static AnnotationValue getAnnotationValue(AnnotationMirror mirror, String attributeName) {
        if (mirror == null || attributeName == null) {
            return null;
        }
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : mirror.getElementValues().entrySet()) {
            if (!entry.getKey().getSimpleName().contentEquals(attributeName)) continue;
            return entry.getValue();
        }
        return null;
    }
}

