/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.processor.generator;

import com.bawnorton.configurable.io.FileType;
import com.bawnorton.configurable.io.SaveLoader;
import com.bawnorton.configurable.processor.ConfigurableSettings;
import com.bawnorton.configurable.processor.entry.ConfigurableEntry;
import com.bawnorton.configurable.processor.entry.ConfigurableValidator;
import com.bawnorton.configurable.processor.util.MethodReference;
import com.bawnorton.configurable.reference.FieldReference;
import com.bawnorton.configurable.reference.validator.ValidatorReference;
import com.bawnorton.configurable.service.ConfigLoader;
import com.bawnorton.configurable.util.GenericType;
import com.google.auto.service.AutoService;
import com.palantir.javapoet.AnnotationSpec;
import com.palantir.javapoet.ClassName;
import com.palantir.javapoet.CodeBlock;
import com.palantir.javapoet.FieldSpec;
import com.palantir.javapoet.JavaFile;
import com.palantir.javapoet.MethodSpec;
import com.palantir.javapoet.ParameterizedTypeName;
import com.palantir.javapoet.TypeName;
import com.palantir.javapoet.TypeSpec;
import com.palantir.javapoet.WildcardTypeName;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.processing.Generated;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class ConfigLoaderGenerator {
    private final ProcessingEnvironment processingEnv;
    private final TypeSpec.Builder typeSpecBuilder;
    private final String configName;
    private final String packageName;
    private final FileType fileType;
    private final List<FieldSpec> fields = new ArrayList<FieldSpec>();

    public ConfigLoaderGenerator(ProcessingEnvironment processingEnv, ConfigurableSettings settings) {
        this.processingEnv = processingEnv;
        this.configName = settings.name();
        this.fileType = settings.fileType();
        this.packageName = "com.bawnorton.configurable.generated.%s".formatted(ConfigLoaderGenerator.formatForPackage(settings.name()));
        this.typeSpecBuilder = TypeSpec.classBuilder((String)"GeneratedConfigLoader").addSuperinterface(ConfigLoader.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{ConfigLoaderGenerator.class.getCanonicalName()}).build()).addAnnotation(AnnotationSpec.builder(AutoService.class).addMember("value", "$T.class", new Object[]{ConfigLoader.class}).build()).addJavadoc("Generated config loader for $S.", new Object[]{settings.name()});
    }

    private static String formatForPackage(String name) {
        return name.toLowerCase().replaceAll("[^a-z0-9]", "_");
    }

    public void addEntry(ConfigurableEntry entry) {
        TypeMirror fieldType = entry.getTypeMirror(this.processingEnv);
        TypeName fieldReferenceType = TypeName.get((TypeMirror)this.processingEnv.getTypeUtils().getDeclaredType(this.processingEnv.getElementUtils().getTypeElement(FieldReference.class.getCanonicalName()), fieldType));
        FieldSpec.Builder fieldBuilder = FieldSpec.builder((TypeName)fieldReferenceType, (String)entry.getReferenceName(), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        CodeBlock.Builder initalizerBuilder = CodeBlock.builder();
        TypeName enclosingClass = TypeName.get((TypeMirror)entry.getEnclosingClassTypeMirror());
        CodeBlock.Builder genericHolderBuilder = CodeBlock.builder();
        this.writeGenericHolder(fieldType, genericHolderBuilder);
        initalizerBuilder.add("$1T.builder(value -> $2T.$3L = value, () -> $2T.$3L, $4L, $5S)", new Object[]{FieldReference.class, enclosingClass, entry.getFieldName(), genericHolderBuilder.build(), entry.getName()});
        if (entry.doesSync()) {
            initalizerBuilder.add(".doesSync(true)", new Object[0]);
        }
        if (entry.hasComment()) {
            initalizerBuilder.add(".comment($S)", new Object[]{entry.getComment()});
        }
        if (entry.hasGroup()) {
            initalizerBuilder.add(".group($S)", new Object[]{entry.getGroup()});
        }
        if (entry.hasOnSetMethod()) {
            MethodReference onSetMethod = entry.getOnSetMethod();
            initalizerBuilder.add(".onSet($T::$L)", new Object[]{onSetMethod.enclosingClass(), onSetMethod.getName()});
        }
        ConfigurableValidator validator = entry.getValidator();
        CodeBlock.Builder validatorBuilder = CodeBlock.builder();
        validatorBuilder.add("$T.<$T>builder()", new Object[]{ValidatorReference.class, fieldType});
        if (validator.hasValidatorMethod()) {
            MethodReference validatorMethod = validator.getValidatorMethod();
            validatorBuilder.add(".fieldValidator($T::$L)", new Object[]{validatorMethod.enclosingClass(), validatorMethod.getName()});
        } else if (validator.hasMax() && validator.hasMin()) {
            validatorBuilder.add(".fieldValidator(value -> value <= $L && value >= $L)", new Object[]{validator.getMax(), validator.getMin()});
        } else if (validator.hasMax()) {
            validatorBuilder.add(".fieldValidator(value -> value <= $L)", new Object[]{validator.getMax()});
        } else if (validator.hasMin()) {
            validatorBuilder.add(".fieldValidator(value -> value >= $L)", new Object[]{validator.getMin()});
        }
        if (validator.hasMessageMethod()) {
            MethodReference messageMethod = validator.getMessageMethod();
            validatorBuilder.add(".messageProvider($T::$L)", new Object[]{messageMethod.enclosingClass(), messageMethod.getName()});
        } else {
            validatorBuilder.add(".messageProvider(ignored -> $S)", new Object[]{validator.getMessageLiteral()});
        }
        if (validator.doesFallback()) {
            validatorBuilder.add(".fallback(true)", new Object[0]);
            validatorBuilder.add(".defaultSupplier(() -> $L)", new Object[]{validator.getDefaultValue()});
        }
        validatorBuilder.add(".build()", new Object[0]);
        initalizerBuilder.add(".validator($L)", new Object[]{validatorBuilder.build()});
        initalizerBuilder.add(".build()", new Object[0]);
        fieldBuilder.initializer(initalizerBuilder.build());
        FieldSpec field = fieldBuilder.build();
        this.fields.add(field);
    }

    private void writeGenericHolder(TypeMirror type, CodeBlock.Builder builder) {
        builder.add("new $T(", new Object[]{GenericType.class});
        if (type instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)type;
            builder.add("$T.class", new Object[]{this.processingEnv.getTypeUtils().erasure(declaredType)});
            List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
            if (!typeArguments.isEmpty()) {
                for (TypeMirror typeMirror : typeArguments) {
                    builder.add(", ", new Object[0]);
                    this.writeGenericHolder(typeMirror, builder);
                }
            }
            builder.add(")", new Object[0]);
        } else {
            builder.add("$T.class)", new Object[]{type});
        }
    }

    public JavaFile generate() {
        this.typeSpecBuilder.addMethod(MethodSpec.methodBuilder((String)"getName").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addAnnotation(Override.class).addStatement("return $S", new Object[]{this.configName}).build());
        this.typeSpecBuilder.addMethod(MethodSpec.methodBuilder((String)"getFileType").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(FileType.class).addAnnotation(Override.class).addStatement("return $T.$L", new Object[]{FileType.class, this.fileType.name()}).build());
        this.typeSpecBuilder.addMethod(MethodSpec.methodBuilder((String)"load").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(SaveLoader.class, "saveLoader", new Modifier[0]).returns(Void.TYPE).addAnnotation(Override.class).addStatement("saveLoader.load(getFields())", new Object[0]).build());
        this.typeSpecBuilder.addMethod(MethodSpec.methodBuilder((String)"save").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(SaveLoader.class, "saveLoader", new Modifier[0]).returns(Void.TYPE).addAnnotation(Override.class).addStatement("saveLoader.save(getFields())", new Object[0]).build());
        MethodSpec.Builder getFieldsBuilder = MethodSpec.methodBuilder((String)"getFields").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)ClassName.get(FieldReference.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)})})).addAnnotation(Override.class);
        getFieldsBuilder.addStatement("$T<$T<$T>> fields = new $T<>()", new Object[]{List.class, FieldReference.class, WildcardTypeName.subtypeOf(Object.class), ArrayList.class});
        this.fields.sort(Comparator.comparing(FieldSpec::name));
        for (FieldSpec field : this.fields) {
            this.typeSpecBuilder.addField(field);
            getFieldsBuilder.addStatement("fields.add($L)", new Object[]{field.name()});
        }
        getFieldsBuilder.addStatement("fields.sort($T.comparing(ref -> $S.formatted(ref.group(), ref.name())))", new Object[]{Comparator.class, "%s.%s"});
        getFieldsBuilder.addStatement("return fields", new Object[0]);
        this.typeSpecBuilder.addMethod(getFieldsBuilder.build());
        TypeSpec typeSpec = this.typeSpecBuilder.build();
        return JavaFile.builder((String)this.packageName, (TypeSpec)typeSpec).skipJavaLangImports(true).build();
    }

    public boolean isEmpty() {
        return this.fields.isEmpty();
    }
}

