/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.util.TextUtil;

public class PetSummonerItem
extends Item {
    private final Function<Level, ? extends TamableAnimal> petFactory;

    public PetSummonerItem(Function<Level, ? extends TamableAnimal> petFactory, Item.Properties properties) {
        super(properties);
        this.petFactory = petFactory;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)TextUtil.itemSub((ItemLike)this, "desc", new Object[0]));
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        Level world = context.getLevel();
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        Direction facing = context.getClickedFace();
        if (world.isClientSide || player == null) {
            return InteractionResult.SUCCESS;
        }
        if (!player.mayUseItemAt(pos.relative(facing), facing, stack)) {
            return InteractionResult.PASS;
        }
        pos = pos.relative(facing);
        TamableAnimal pet = this.petFactory.apply(world);
        pet.moveTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), Mth.wrapDegrees((float)(world.random.nextFloat() * 360.0f)), 0.0f);
        pet.yHeadRot = pet.getYRot();
        pet.yBodyRot = pet.getYRot();
        world.addFreshEntity((Entity)pet);
        pet.playAmbientSound();
        if (stack.has(DataComponents.CUSTOM_NAME)) {
            pet.setCustomName(stack.getHoverName());
        }
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        pet.setTame(true, true);
        pet.setOwnerUUID(player.getUUID());
        world.broadcastEntityEvent((Entity)pet, (byte)7);
        pet.setHealth(pet.getMaxHealth());
        return InteractionResult.SUCCESS;
    }

    public static Cat getCat(Level world) {
        Cat cat = new Cat(EntityType.CAT, world);
        BuiltInRegistries.CAT_VARIANT.getRandom(SilentGems.RANDOM_SOURCE).ifPresent(arg_0 -> ((Cat)cat).setVariant(arg_0));
        return cat;
    }

    public static Wolf getDog(Level world) {
        return new Wolf(EntityType.WOLF, world);
    }
}

