/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.data;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.HeightmapPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.block.OreBlockSG;
import net.silentchaos512.gems.setup.GemsBlocks;
import net.silentchaos512.gems.util.Gems;
import net.silentchaos512.gems.world.OreConfigDefaults;
import org.jetbrains.annotations.NotNull;

public class WorldGenGenerator
extends DatapackBuiltinEntriesProvider {
    private static final RuleTest replaceStone = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
    private static final RuleTest replaceDeepslate = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
    private static final RuleTest replaceNetherrack = new TagMatchTest(Tags.Blocks.NETHERRACKS);
    private static final RuleTest replaceEndStone = new TagMatchTest(Tags.Blocks.END_STONES);
    private static final ConfiguredFeature<?, ?> silverOre = new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration((List)ImmutableList.of((Object)OreConfiguration.target((RuleTest)replaceStone, (BlockState)((OreBlockSG)((Object)GemsBlocks.SILVER_ORE.get())).defaultBlockState()), (Object)OreConfiguration.target((RuleTest)replaceDeepslate, (BlockState)((OreBlockSG)((Object)GemsBlocks.DEEPSLATE_SILVER_ORE.get())).defaultBlockState())), 8, 0.2f));
    private static final ConfiguredFeature<?, ?> chaosOre = new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration(List.of(OreConfiguration.target((RuleTest)replaceStone, (BlockState)((OreBlockSG)((Object)GemsBlocks.CHAOS_ORE.get())).defaultBlockState()), OreConfiguration.target((RuleTest)replaceDeepslate, (BlockState)((OreBlockSG)((Object)GemsBlocks.DEEPSLATE_CHAOS_ORE.get())).defaultBlockState())), 12, 0.5f));
    private static final Map<Gems, ConfiguredFeature<?, ?>> overworldOreFeatures = WorldGenGenerator.makeMap(g -> {
        OreConfigDefaults config = g.getOreConfigDefaults((ResourceKey<Level>)Level.OVERWORLD);
        return new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration((List)ImmutableList.of((Object)OreConfiguration.target((RuleTest)replaceStone, (BlockState)g.getOre().defaultBlockState()), (Object)OreConfiguration.target((RuleTest)replaceDeepslate, (BlockState)g.getDeepslateOre().defaultBlockState())), config.size(), config.discardChanceOnAirExposure()));
    });
    private static final Map<Gems, ConfiguredFeature<?, ?>> netherOreFeatures = WorldGenGenerator.makeMap(g -> {
        OreConfigDefaults config = g.getOreConfigDefaults((ResourceKey<Level>)Level.NETHER);
        return new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration(replaceNetherrack, g.getNetherOre().defaultBlockState(), config.size(), config.discardChanceOnAirExposure()));
    });
    private static final Map<Gems, ConfiguredFeature<?, ?>> endOreFeatures = WorldGenGenerator.makeMap(g -> {
        OreConfigDefaults config = g.getOreConfigDefaults((ResourceKey<Level>)Level.END);
        return new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration(replaceEndStone, g.getEndOre().defaultBlockState(), config.size(), config.discardChanceOnAirExposure()));
    });
    private static final Map<Gems, ConfiguredFeature<?, ?>> overworldFlowerFeatures = WorldGenGenerator.makeMap(WorldGenGenerator::glowroses);
    private static final Map<Gems, ConfiguredFeature<?, ?>> netherFlowerFeatures = WorldGenGenerator.makeMap(WorldGenGenerator::glowroses);
    private static final Map<Gems, ConfiguredFeature<?, ?>> endFlowerFeatures = WorldGenGenerator.makeMap(WorldGenGenerator::glowroses);
    private static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().add(Registries.CONFIGURED_FEATURE, ctx -> {
        ctx.register(WorldGenGenerator.configuredFeature(SilentGems.getId("overworld/silver_ore")), silverOre);
        ctx.register(WorldGenGenerator.configuredFeature(SilentGems.getId("overworld/chaos_ore")), chaosOre);
        overworldOreFeatures.forEach((gem, feature) -> ctx.register(WorldGenGenerator.getOreFeatureKey(gem, (ResourceKey<Level>)Level.OVERWORLD), feature));
        netherOreFeatures.forEach((gem, feature) -> ctx.register(WorldGenGenerator.getOreFeatureKey(gem, (ResourceKey<Level>)Level.NETHER), feature));
        endOreFeatures.forEach((gem, feature) -> ctx.register(WorldGenGenerator.getOreFeatureKey(gem, (ResourceKey<Level>)Level.END), feature));
        overworldFlowerFeatures.forEach((gem, feature) -> ctx.register(WorldGenGenerator.getGlowroseFeatureKey(gem, (ResourceKey<Level>)Level.OVERWORLD), feature));
        netherFlowerFeatures.forEach((gem, feature) -> ctx.register(WorldGenGenerator.getGlowroseFeatureKey(gem, (ResourceKey<Level>)Level.NETHER), feature));
        endFlowerFeatures.forEach((gem, feature) -> ctx.register(WorldGenGenerator.getGlowroseFeatureKey(gem, (ResourceKey<Level>)Level.END), feature));
    }).add(Registries.PLACED_FEATURE, ctx -> {
        ResourceKey<ConfiguredFeature<?, ?>> silverOreKey = WorldGenGenerator.configuredFeature(SilentGems.getId("overworld/silver_ore"));
        ctx.register(WorldGenGenerator.placedFeature(silverOreKey.location()), (Object)WorldGenGenerator.placed(WorldGenGenerator.holderFeature((BootstrapContext<PlacedFeature>)ctx, silverOreKey), -60, 40, 16));
        ResourceKey<ConfiguredFeature<?, ?>> chaosOreKey = WorldGenGenerator.configuredFeature(SilentGems.getId("overworld/chaos_ore"));
        ctx.register(WorldGenGenerator.placedFeature(chaosOreKey.location()), (Object)WorldGenGenerator.placed(WorldGenGenerator.holderFeature((BootstrapContext<PlacedFeature>)ctx, chaosOreKey), -60, 20, 6));
        overworldOreFeatures.forEach((gem, feature) -> WorldGenGenerator.makePlacedFeature((BootstrapContext<PlacedFeature>)ctx, gem, (ResourceKey<Level>)Level.OVERWORLD));
        netherOreFeatures.forEach((gem, feature) -> WorldGenGenerator.makePlacedFeature((BootstrapContext<PlacedFeature>)ctx, gem, (ResourceKey<Level>)Level.NETHER));
        endOreFeatures.forEach((gem, feature) -> WorldGenGenerator.makePlacedFeature((BootstrapContext<PlacedFeature>)ctx, gem, (ResourceKey<Level>)Level.END));
        overworldFlowerFeatures.forEach((gem, feature) -> WorldGenGenerator.makePlacedGlowroseFeature((BootstrapContext<PlacedFeature>)ctx, gem, (ResourceKey<Level>)Level.OVERWORLD));
        netherFlowerFeatures.forEach((gem, feature) -> WorldGenGenerator.makePlacedGlowroseFeature((BootstrapContext<PlacedFeature>)ctx, gem, (ResourceKey<Level>)Level.NETHER));
        endFlowerFeatures.forEach((gem, feature) -> WorldGenGenerator.makePlacedGlowroseFeature((BootstrapContext<PlacedFeature>)ctx, gem, (ResourceKey<Level>)Level.END));
    }).add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, ctx -> {
        ArrayList overworldOthers = new ArrayList();
        overworldOthers.add(WorldGenGenerator.configuredFeature(SilentGems.getId("overworld/silver_ore")));
        overworldOthers.add(WorldGenGenerator.configuredFeature(SilentGems.getId("overworld/chaos_ore")));
        overworldFlowerFeatures.forEach((gem, feature) -> overworldOthers.add(WorldGenGenerator.getGlowroseFeatureKey(gem, (ResourceKey<Level>)Level.OVERWORLD)));
        WorldGenGenerator.registerOreBiomeModifiers((BootstrapContext<BiomeModifier>)ctx, (ResourceKey<Level>)Level.OVERWORLD, (TagKey<Biome>)BiomeTags.IS_OVERWORLD, overworldOreFeatures, "overworld_features", overworldOthers);
        ArrayList netherOthers = new ArrayList();
        netherFlowerFeatures.forEach((gem, feature) -> netherOthers.add(WorldGenGenerator.getGlowroseFeatureKey(gem, (ResourceKey<Level>)Level.NETHER)));
        WorldGenGenerator.registerOreBiomeModifiers((BootstrapContext<BiomeModifier>)ctx, (ResourceKey<Level>)Level.NETHER, (TagKey<Biome>)BiomeTags.IS_NETHER, netherOreFeatures, "nether_features", netherOthers);
        ArrayList endOthers = new ArrayList();
        endFlowerFeatures.forEach((gem, feature) -> endOthers.add(WorldGenGenerator.getGlowroseFeatureKey(gem, (ResourceKey<Level>)Level.END)));
        WorldGenGenerator.registerOreBiomeModifiers((BootstrapContext<BiomeModifier>)ctx, (ResourceKey<Level>)Level.END, (TagKey<Biome>)BiomeTags.IS_END, endOreFeatures, "end_features", endOthers);
    });

    public WorldGenGenerator(GatherDataEvent event) {
        super(event.getGenerator().getPackOutput(), event.getLookupProvider(), BUILDER, Collections.singleton("silentgems"));
    }

    public static <T> Map<Gems, T> makeMap(Function<Gems, T> getter) {
        LinkedHashMap<Gems, T> map = new LinkedHashMap<Gems, T>();
        for (Gems gem : Gems.values()) {
            map.put(gem, getter.apply(gem));
        }
        return map;
    }

    private static ResourceKey<ConfiguredFeature<?, ?>> getOreFeatureKey(Gems gem, ResourceKey<Level> level) {
        return WorldGenGenerator.configuredFeature(SilentGems.getId(level.location().getPath() + "/" + gem.getName() + "_ore"));
    }

    private static ResourceKey<ConfiguredFeature<?, ?>> getGlowroseFeatureKey(Gems gem, ResourceKey<Level> level) {
        return WorldGenGenerator.configuredFeature(SilentGems.getId(level.location().getPath() + "/" + gem.getName() + "_glowrose"));
    }

    private static void makePlacedFeature(BootstrapContext<PlacedFeature> ctx, Gems gem, ResourceKey<Level> level) {
        ResourceKey<ConfiguredFeature<?, ?>> key = WorldGenGenerator.getOreFeatureKey(gem, level);
        OreConfigDefaults config = gem.getOreConfigDefaults(level);
        PlacedFeature placed = WorldGenGenerator.placed(WorldGenGenerator.holderFeature(ctx, key), config.minHeight(), config.maxHeight(), config.count());
        ctx.register(WorldGenGenerator.placedFeature(key.location()), (Object)placed);
    }

    private static void makePlacedGlowroseFeature(BootstrapContext<PlacedFeature> ctx, Gems gem, ResourceKey<Level> level) {
        ResourceKey<ConfiguredFeature<?, ?>> key = WorldGenGenerator.getGlowroseFeatureKey(gem, level);
        PlacedFeature placed = new PlacedFeature((Holder)ctx.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(key), (List)ImmutableList.of((Object)RarityFilter.onAverageOnceEvery((int)256), (Object)InSquarePlacement.spread(), (Object)HeightmapPlacement.onHeightmap((Heightmap.Types)Heightmap.Types.MOTION_BLOCKING), (Object)BiomeFilter.biome()));
        ctx.register(WorldGenGenerator.placedFeature(key.location()), (Object)placed);
    }

    private static void registerOreBiomeModifiers(BootstrapContext<BiomeModifier> ctx, ResourceKey<Level> level, TagKey<Biome> biomes, Map<Gems, ConfiguredFeature<?, ?>> ores, String modifierName, Collection<ResourceKey<ConfiguredFeature<?, ?>>> others) {
        HolderSet.Named biomeTagSet = ctx.lookup(Registries.BIOME).getOrThrow(biomes);
        ArrayList list = new ArrayList();
        ores.forEach((gem, feature) -> {
            ResourceKey<ConfiguredFeature<?, ?>> key = WorldGenGenerator.getOreFeatureKey(gem, level);
            list.add(WorldGenGenerator.holderPlaced(ctx, key.location()));
        });
        others.forEach(o -> list.add(WorldGenGenerator.holderPlaced(ctx, o.location())));
        BiomeModifiers.AddFeaturesBiomeModifier oresMod = new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomeTagSet, (HolderSet)HolderSet.direct(list), GenerationStep.Decoration.UNDERGROUND_ORES);
        ctx.register(WorldGenGenerator.biomeModifier(SilentGems.getId(modifierName)), (Object)oresMod);
    }

    @NotNull
    private static ConfiguredFeature<RandomPatchConfiguration, Feature<RandomPatchConfiguration>> glowroses(Gems g) {
        return new ConfiguredFeature(Feature.FLOWER, (FeatureConfiguration)new RandomPatchConfiguration(32, 7, 3, Holder.direct((Object)new PlacedFeature(Holder.direct((Object)new ConfiguredFeature(Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)g.getGlowrose())))), (List)ImmutableList.of((Object)BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE))))));
    }

    public static ConfiguredFeature<?, ?> ore(Block block, RuleTest replacing, int size) {
        return new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration(replacing, block.defaultBlockState(), size));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> configuredFeature(ResourceLocation name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)name);
    }

    protected static ResourceKey<PlacedFeature> placedFeature(ResourceLocation name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)name);
    }

    protected static ResourceKey<BiomeModifier> biomeModifier(ResourceLocation name) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)name);
    }

    public static PlacedFeature placed(Holder<ConfiguredFeature<?, ?>> feature, int minHeight, int maxHeight, int count) {
        return new PlacedFeature(feature, WorldGenGenerator.placements(minHeight, maxHeight, count));
    }

    public static List<PlacementModifier> placements(int minHeight, int maxHeight, int count) {
        return ImmutableList.of((Object)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)minHeight), (VerticalAnchor)VerticalAnchor.absolute((int)maxHeight)), (Object)InSquarePlacement.spread(), (Object)CountPlacement.of((int)count), (Object)BiomeFilter.biome());
    }

    public static Holder<ConfiguredFeature<?, ?>> holderFeature(BootstrapContext<PlacedFeature> ctx, ResourceKey<ConfiguredFeature<?, ?>> location) {
        return ctx.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(location);
    }

    public static Holder<PlacedFeature> holderPlaced(BootstrapContext<BiomeModifier> ctx, ResourceLocation location) {
        return ctx.lookup(Registries.PLACED_FEATURE).getOrThrow(WorldGenGenerator.placedFeature(location));
    }
}

