/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.world.gen.feature;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.werewolves.core.ModWorld;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import org.jetbrains.annotations.NotNull;

public class MagicFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<MagicFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(p_68427_ -> MagicFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)p_68427_).apply((Applicative)p_68427_, MagicFoliagePlacer::new));

    public MagicFoliagePlacer(IntProvider pRadius, IntProvider pOffset) {
        super(pRadius, pOffset);
    }

    @NotNull
    protected FoliagePlacerType<?> type() {
        return (FoliagePlacerType)ModWorld.MAGIC_FOLIAGE.get();
    }

    protected void createFoliage(@NotNull LevelSimulatedReader pLevel, @NotNull FoliagePlacer.FoliageSetter pBlockSetter, @NotNull RandomSource pRandom, @NotNull TreeConfiguration pConfig, int pMaxFreeTreeHeight, @NotNull FoliagePlacer.FoliageAttachment pAttachment, int pFoliageHeight, int pFoliageRadius, int pOffset) {
        BlockPos pos = pAttachment.pos().above(pOffset);
        pos = pos.above();
        this.placeLeavesRow(pLevel, pBlockSetter, pRandom, pConfig, pos, pFoliageRadius - 1, pOffset, false);
        pos = pos.below();
        MagicFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos.north());
        MagicFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos.south());
        MagicFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos.east());
        MagicFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos.west());
        pos = pos.below();
        this.placeLeavesRow(pLevel, pBlockSetter, pRandom, pConfig, pos, 1, pOffset, false);
        pos = pos.below();
        this.placeLeavesRow(pLevel, pBlockSetter, pRandom, pConfig, pos, 1, pOffset, false);
        MagicFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos.north(2));
        MagicFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos.south(2));
        MagicFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos.east(2));
        MagicFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos.west(2));
        pos = pos.below();
        this.placeLeavesRow(pLevel, pBlockSetter, pRandom, pConfig, pos, 1, pOffset, false);
        MagicFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos.north(2));
        MagicFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos.north(2).east());
        MagicFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos.north(2).west());
        MagicFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos.south(2));
        MagicFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos.south(2).east());
        MagicFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos.south(2).west());
        MagicFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos.east(2));
        MagicFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos.east(2).north());
        MagicFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos.east(2).south());
        MagicFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos.west(2));
        MagicFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos.west(2).north());
        MagicFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos.west(2).south());
        pos = pos.below();
        this.placeLeavesRow(pLevel, pBlockSetter, pRandom, pConfig, pos, 1, pOffset, false);
    }

    public int foliageHeight(@NotNull RandomSource pRandom, int pHeight, @NotNull TreeConfiguration pConfig) {
        return pHeight - pRandom.nextInt((int)((double)pHeight * 0.2));
    }

    protected boolean shouldSkipLocation(@NotNull RandomSource pRandom, int pLocalX, int pLocalY, int pLocalZ, int pRange, boolean pLarge) {
        return false;
    }
}

