/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.items;

import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.werewolves.api.WReference;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class WerewolfMinionUpgradeItem
extends Item {
    private final int minLevel;
    private final int maxLevel;

    public WerewolfMinionUpgradeItem(Item.Properties properties, int minLevel, int maxLevel) {
        super(properties);
        this.maxLevel = maxLevel;
        this.minLevel = minLevel;
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nullable Item.TooltipContext context, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"item.werewolves.moon_charm.desc").withStyle(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)Component.empty());
        tooltip.add((Component)Component.translatable((String)"item.vampirism.minion_upgrade_item.desc").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"text.vampirism.for_to_levels", (Object[])new Object[]{this.minLevel + 1, this.maxLevel + 1}).withStyle(ChatFormatting.GRAY));
    }

    public IFaction<?> getFaction() {
        return WReference.WEREWOLF_FACTION;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public int getMinLevel() {
        return this.minLevel;
    }
}

