/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.util.TotemHelper;
import de.teamlapen.werewolves.api.WReference;
import de.teamlapen.werewolves.api.entities.werewolf.IVillagerTransformable;
import de.teamlapen.werewolves.api.entities.werewolf.TransformType;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfTransformable;
import de.teamlapen.werewolves.api.items.ISilverItem;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModDamageTypes;
import de.teamlapen.werewolves.core.ModSkills;
import de.teamlapen.werewolves.core.ModTags;
import de.teamlapen.werewolves.effects.SilverEffect;
import de.teamlapen.werewolves.effects.WerewolfWeakeningEffect;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.mixin.GoalSelectorAccessor;
import de.teamlapen.werewolves.mixin.NearestAttackabletargetGoalAccessor;
import de.teamlapen.werewolves.mixin.TargetingConditionsAccessor;
import de.teamlapen.werewolves.network.ClientboundAttackTargetEventPacket;
import de.teamlapen.werewolves.util.FormHelper;
import de.teamlapen.werewolves.util.Helper;
import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModEntityEventHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Predicate<LivingEntity> nonWerewolfCheck = entity -> !Helper.isWerewolf((Entity)entity);
    private static final Object2BooleanMap<String> entityAIReplacementWarnMap = new Object2BooleanArrayMap();
    private static final UUID ARMOR_REDUCTION = UUID.fromString("5b7612e9-1847-435c-b4eb-a455af4ce8c7");

    @SubscribeEvent
    public void onEntityAttacked(AttackEntityEvent event) {
        LivingEntity target;
        int sum;
        Entity entity;
        if (event.getTarget() instanceof LivingEntity && Helper.isWerewolf(event.getTarget()) && event.getEntity().getMainHandItem().is(ModTags.Items.SILVER_TOOL)) {
            ((LivingEntity)event.getTarget()).addEffect(SilverEffect.createSilverEffect((LivingEntity)event.getTarget(), (Integer)WerewolvesConfig.BALANCE.UTIL.silverItemEffectDuration.get(), 1));
        }
        if (event.getTarget() instanceof WerewolfTransformable && ((WerewolfTransformable)event.getTarget()).canTransform()) {
            ((WerewolfTransformable)event.getTarget()).transformToWerewolf(TransformType.TIME_LIMITED);
        }
        if (Helper.isWerewolf(event.getEntity()) && (entity = event.getTarget()) instanceof LivingEntity && (sum = StreamSupport.stream((target = (LivingEntity)entity).getArmorSlots().spliterator(), false).mapToInt(stack -> stack.getItem() instanceof ISilverItem ? 1 : 0).sum()) > 0) {
            event.getEntity().addEffect(SilverEffect.createSilverEffect((LivingEntity)event.getEntity(), (Integer)WerewolvesConfig.BALANCE.UTIL.silverArmorAttackEffectDuration.get() * sum, 0));
        }
    }

    @SubscribeEvent
    public void onTargetChange(LivingChangeTargetEvent event) {
        ServerPlayer player;
        LivingEntity livingEntity = event.getNewAboutToBeSetTarget();
        if (livingEntity instanceof ServerPlayer && Helper.isWerewolf((Player)(player = (ServerPlayer)livingEntity)) && WerewolfPlayer.get((Player)player).getSkillHandler().isSkillEnabled((ISkill)ModSkills.SIXTH_SENSE.get())) {
            player.connection.send((CustomPacketPayload)new ClientboundAttackTargetEventPacket(event.getEntity().getId()));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onEntityJoinWorld(EntityJoinLevelEvent event) {
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        if (event.getEntity() instanceof Villager) {
            TotemHelper.getTotemNearPos((ServerLevel)((ServerLevel)event.getLevel()), (BlockPos)event.getEntity().blockPosition(), (boolean)true).ifPresent(totem -> {
                if (WReference.WEREWOLF_FACTION.equals((Object)totem.getControllingFaction()) && ((Villager)event.getEntity()).getRandom().nextInt(6) == 0) {
                    ((IVillagerTransformable)event.getEntity()).setWerewolfFaction(true);
                }
            });
        }
        if (((Boolean)WerewolvesConfig.BALANCE.UTIL.skeletonIgnoreWerewolves.get()).booleanValue() && (event.getEntity() instanceof Skeleton || event.getEntity() instanceof Stray)) {
            ModEntityEventHandler.makeWerewolfFriendly("skeleton", (AbstractSkeleton)event.getEntity(), NearestAttackableTargetGoal.class, Player.class, 2, (entity, predicate) -> new NearestAttackableTargetGoal((Mob)entity, Player.class, 10, true, false, predicate), type -> type == EntityType.SKELETON || type == EntityType.STRAY);
        }
    }

    public static <T extends Mob, S extends LivingEntity, Q extends NearestAttackableTargetGoal<S>> void makeWerewolfFriendly(String name, T entity, Class<Q> targetClass, Class<S> targetEntityClass, int attackPriority, BiFunction<T, Predicate<LivingEntity>, Q> replacement, Predicate<EntityType<? extends T>> typeCheck) {
        try {
            Goal target = null;
            for (WrappedGoal t : ((GoalSelectorAccessor)entity.targetSelector).getAvailableGoals()) {
                Goal g = t.getGoal();
                if (!targetClass.equals(g.getClass()) || t.getPriority() != attackPriority || !targetEntityClass.equals(((NearestAttackabletargetGoalAccessor)g).getTargetType())) continue;
                target = g;
                break;
            }
            if (target != null) {
                entity.targetSelector.removeGoal(target);
                EntityType type = entity.getType();
                if (typeCheck.test(type)) {
                    Predicate<LivingEntity> newPredicate = nonWerewolfCheck;
                    if (((TargetingConditionsAccessor)((NearestAttackabletargetGoalAccessor)target).getTargetConditions()).getSelector() != null) {
                        newPredicate = newPredicate.and(((TargetingConditionsAccessor)((NearestAttackabletargetGoalAccessor)target).getTargetConditions()).getSelector());
                    }
                    entity.targetSelector.addGoal(attackPriority, (Goal)replacement.apply(entity, newPredicate));
                }
            } else if (entityAIReplacementWarnMap.getOrDefault((Object)name, true)) {
                LOGGER.warn("Could not replace {} attack target task for {}", (Object)name, (Object)entity.getType().getDescription());
                entityAIReplacementWarnMap.put((Object)name, false);
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not replace {} attack target task for {}", (Object)name, (Object)entity.getType().getDescription(), (Object)e);
        }
    }

    @SubscribeEvent
    public void onWerewolfAttackPre(LivingDamageEvent.Pre event) {
        WerewolfPlayer werewolf;
        Player player;
        Entity entity;
        if (event.getSource().is(DamageTypeTags.IS_PLAYER_ATTACK) && (entity = event.getSource().getEntity()) instanceof Player && this.checkThroatSeeker(event, player = (Player)entity, werewolf = WerewolfPlayer.get(player))) {
            return;
        }
    }

    @SubscribeEvent
    public void onWerewolfAttackedPre(LivingDamageEvent.Pre event) {
        if (this.checkWerewolfResistance(event)) {
            return;
        }
    }

    @SubscribeEvent
    public void onWerewolfAttackIncoming(LivingIncomingDamageEvent event) {
        Entity entity;
        if (event.getSource().is(ModTags.DamageTypes.WEREWOLF_ARMOR_REDUCTION) && (entity = event.getSource().getEntity()) instanceof Player) {
            Player player = (Player)entity;
            WerewolfPlayer werewolf = WerewolfPlayer.get(player);
            this.checkBite(event, player, werewolf);
        }
    }

    @SubscribeEvent
    public void onWerewolfWeakeningEffectApplied(MobEffectEvent.Applicable event) {
        if (event.getEffectInstance().getEffect() instanceof WerewolfWeakeningEffect && !Helper.isWerewolf((Entity)event.getEntity())) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
    }

    private boolean checkWerewolfResistance(LivingDamageEvent.Pre event) {
        if (!event.getSource().is(DamageTypeTags.WITCH_RESISTANT_TO) && Helper.isWerewolf((Entity)event.getEntity())) {
            Player player;
            WerewolfPlayer werewolfPlayer;
            float damage = event.getNewDamage();
            float damageReduction = FormHelper.getForm(event.getEntity()).getDamageReduction();
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player && !(werewolfPlayer = WerewolfPlayer.get(player = (Player)livingEntity)).getForm().isTransformed() && werewolfPlayer.getSkillHandler().isSkillEnabled((ISkill)ModSkills.THICK_FUR.get())) {
                damageReduction *= ((Double)WerewolvesConfig.BALANCE.SKILLS.thick_fur_multiplier.get()).floatValue();
            }
            if (event.getSource().getEntity() != null && Helper.isVampire((Entity)event.getSource().getEntity())) {
                damageReduction *= 0.3f;
            }
            event.setNewDamage(damage * (1.0f - damageReduction));
        }
        return false;
    }

    private boolean checkThroatSeeker(LivingDamageEvent.Pre event, Player player, WerewolfPlayer werewolf) {
        if (werewolf.getForm() == WerewolfForm.BEAST && werewolf.getSkillHandler().isSkillEnabled(ModSkills.THROAT_SEEKER) && !UtilLib.canReallySee((LivingEntity)event.getEntity(), (LivingEntity)player, (boolean)true) && player.getRandom().nextInt(4) < 1) {
            event.setNewDamage(10000.0f);
            return true;
        }
        return false;
    }

    private void checkBite(LivingIncomingDamageEvent event, Player player, WerewolfPlayer werewolf) {
        float reductionModifier = (float)werewolf.getLevel() / (float)werewolf.getMaxLevel();
        reductionModifier = event.getSource().is(ModDamageTypes.BITE) ? (reductionModifier *= 0.8f) : (reductionModifier *= 0.3f);
        float finalReductionModifier = reductionModifier;
        event.addReductionModifier(DamageContainer.Reduction.ARMOR, (type, reductionIn) -> reductionIn * (1.0f - finalReductionModifier));
    }
}

