/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.core;

import de.teamlapen.werewolves.api.WResourceLocation;
import de.teamlapen.werewolves.core.ModItems;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModArmorMaterials {
    public static final DeferredRegister<ArmorMaterial> ARMOR_MATERIALS = DeferredRegister.create((ResourceKey)Registries.ARMOR_MATERIAL, (String)"werewolves");
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> SILVER = ModArmorMaterials.register("silver", ModArmorMaterials.createReduction(2, 6, 5, 2), 9, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.SILVER_INGOT.get()}), 0.0f, 0.0f);
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> PELT = ModArmorMaterials.register("pelt", ModArmorMaterials.createReduction(1, 1, 1, 1), 9, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.PELT.get()}), 0.0f, 0.0f);
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> DARK_PELT = ModArmorMaterials.register("dark_pelt", ModArmorMaterials.createReduction(1, 2, 2, 1), 15, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.DARK_PELT.get()}), 0.0f, 0.0f);
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> WHITE_PELT = ModArmorMaterials.register("white_pelt", ModArmorMaterials.createReduction(2, 3, 3, 2), 20, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.WHITE_PELT.get()}), 2.0f, 0.0f);

    static void register(IEventBus bus) {
        ARMOR_MATERIALS.register(bus);
    }

    private static EnumMap<ArmorItem.Type, Integer> createReduction(int helmet, int chestplate, int leggings, int boots) {
        return (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
            map.put(ArmorItem.Type.BOOTS, boots);
            map.put(ArmorItem.Type.LEGGINGS, leggings);
            map.put(ArmorItem.Type.CHESTPLATE, chestplate);
            map.put(ArmorItem.Type.HELMET, helmet);
        });
    }

    private static DeferredHolder<ArmorMaterial, ArmorMaterial> register(String name, Map<ArmorItem.Type, Integer> defense, int enchantmentValue, Holder<SoundEvent> equipSound, Supplier<Ingredient> repairIngredient, float toughness, float knockbackResistance) {
        return ARMOR_MATERIALS.register(name, () -> {
            List<ArmorMaterial.Layer> list = List.of(new ArmorMaterial.Layer(WResourceLocation.mod(name)));
            return new ArmorMaterial(defense, enchantmentValue, equipSound, repairIngredient, list, toughness, knockbackResistance);
        });
    }
}

