/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.command.arguments;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;

public class WerewolfFormArgument
implements ArgumentType<WerewolfForm> {
    private static final DynamicCommandExceptionType FORM_NOT_FOUND = new DynamicCommandExceptionType(id -> Component.translatable((String)"command.werewolves.argument.form.notfound", (Object[])new Object[]{id}));
    private static final DynamicCommandExceptionType FORM_NOT_SUPPORTED = new DynamicCommandExceptionType(id -> Component.translatable((String)"command.werewolves.argument.form.not_supported", (Object[])new Object[]{id}));
    @Nonnull
    private final Collection<WerewolfForm> allowedForms;

    public static WerewolfForm getForm(CommandContext<CommandSourceStack> context, String id) {
        return (WerewolfForm)context.getArgument(id, WerewolfForm.class);
    }

    public static WerewolfFormArgument allForms() {
        return new WerewolfFormArgument(WerewolfForm.getAllForms());
    }

    public static WerewolfFormArgument transformedForms() {
        return new WerewolfFormArgument(WerewolfForm.getAllForms().stream().filter(WerewolfForm::isTransformed).collect(Collectors.toList()));
    }

    public static WerewolfFormArgument nonHumanForms() {
        return new WerewolfFormArgument(WerewolfForm.getAllForms().stream().filter(w -> !w.isHumanLike()).collect(Collectors.toList()));
    }

    public static WerewolfFormArgument formArgument(WerewolfForm ... allowedForms) {
        return new WerewolfFormArgument(Arrays.asList(allowedForms));
    }

    public WerewolfFormArgument(@Nonnull Collection<WerewolfForm> allowedForms) {
        this.allowedForms = allowedForms;
    }

    @Nonnull
    public Collection<WerewolfForm> getAllowedForms() {
        return this.allowedForms;
    }

    public WerewolfForm parse(StringReader reader) throws CommandSyntaxException {
        String id = reader.readString();
        WerewolfForm form = WerewolfForm.getForm(id);
        if (form == null) {
            throw FORM_NOT_FOUND.create((Object)id);
        }
        if (!this.allowedForms.contains(form)) {
            throw FORM_NOT_SUPPORTED.create((Object)id);
        }
        return form;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        Collection<WerewolfForm> forms = WerewolfForm.getAllForms();
        forms.remove(WerewolfForm.NONE);
        return SharedSuggestionProvider.suggest(this.allowedForms.stream().map(WerewolfForm::getName), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        Collection<WerewolfForm> forms = WerewolfForm.getAllForms();
        forms.remove(WerewolfForm.NONE);
        return this.allowedForms.stream().map(WerewolfForm::getName).collect(Collectors.toList());
    }

    public static class Info
    implements ArgumentTypeInfo<WerewolfFormArgument, Template> {
        public void serializeToNetwork(@Nonnull Template template, @Nonnull FriendlyByteBuf buffer) {
            Collection<WerewolfForm> forms = template.allowedForms;
            buffer.writeVarInt(forms.size());
            forms.forEach(form -> buffer.writeUtf(form.getName()));
        }

        @Nonnull
        public Template deserializeFromNetwork(@Nonnull FriendlyByteBuf buffer) {
            ArrayList<WerewolfForm> forms = new ArrayList<WerewolfForm>();
            int amount = buffer.readVarInt();
            for (int i = 0; i < amount; ++i) {
                forms.add(WerewolfForm.getForm(buffer.readUtf(Short.MAX_VALUE)));
            }
            return new Template(forms);
        }

        public void serializeToJson(@Nonnull Template template, @Nonnull JsonObject json) {
            JsonArray forms = new JsonArray();
            template.allowedForms.forEach(form -> forms.add(form.getName()));
            json.add("allowed_forms", (JsonElement)forms);
        }

        @Nonnull
        public Template unpack(@Nonnull WerewolfFormArgument argument) {
            return new Template(argument.getAllowedForms());
        }

        public class Template
        implements ArgumentTypeInfo.Template<WerewolfFormArgument> {
            final Collection<WerewolfForm> allowedForms;

            public Template(Collection<WerewolfForm> allowedForms) {
                this.allowedForms = allowedForms;
            }

            @Nonnull
            public WerewolfFormArgument instantiate(@Nonnull CommandBuildContext context) {
                return new WerewolfFormArgument(this.allowedForms);
            }

            @Nonnull
            public ArgumentTypeInfo<WerewolfFormArgument, ?> type() {
                return Info.this;
            }
        }
    }
}

