/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.gui;

import de.teamlapen.lib.lib.client.gui.components.HoverList;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.client.gui.screens.AppearanceScreen;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.core.ModSkills;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.network.ServerboundWerewolfAppearancePacket;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import org.jetbrains.annotations.NotNull;

public class WerewolfPlayerAppearanceScreen
extends AppearanceScreen<Player> {
    private static final Component NAME = Component.translatable((String)"gui.vampirism.appearance");
    private final WerewolfPlayer werewolf;
    private WerewolfForm activeForm;
    private int skinType;
    private int eyeType;
    private boolean glowingEyes;
    private boolean renderForm;
    private Button human;
    private Button beast;
    private Button survival;
    private HoverList<?> eyeList;
    private HoverList<?> skinList;
    private ExtendedButton eyeButton;
    private ExtendedButton skinButton;
    private Checkbox glowingEyesButton;

    public WerewolfPlayerAppearanceScreen(@Nullable Screen backScreen) {
        super(NAME, (LivingEntity)Minecraft.getInstance().player, backScreen);
        this.werewolf = WerewolfPlayer.get((Player)Minecraft.getInstance().player);
    }

    public void removed() {
        this.updateServer();
        super.removed();
    }

    public void resize(@Nonnull Minecraft minecraft, int width, int height) {
        this.updateServer();
        WerewolfForm form = this.activeForm;
        super.resize(minecraft, width, height);
        this.switchToForm(form);
    }

    private void updateServer() {
        Minecraft.getInstance().getConnection().send((CustomPacketPayload)new ServerboundWerewolfAppearancePacket(((Player)this.entity).getId(), "", this.activeForm, this.eyeType, this.skinType, this.glowingEyes ? 1 : 0));
    }

    protected void init() {
        super.init();
        Tooltip notUnlocked = Tooltip.create((Component)Component.translatable((String)"text.werewolves.not_unlocked"));
        this.human = (Button)this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.guiLeft + 5, this.guiTop + 20, 67, 20, WerewolfForm.HUMAN.getTextComponent(), button1 -> this.switchToForm(WerewolfForm.HUMAN)));
        this.beast = (Button)this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.guiLeft + 71, this.guiTop + 20, 40, 20, WerewolfForm.BEAST.getTextComponent(), button1 -> this.switchToForm(WerewolfForm.BEAST)));
        this.survival = (Button)this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.guiLeft + 111, this.guiTop + 20, 55, 20, WerewolfForm.SURVIVALIST.getTextComponent(), button1 -> this.switchToForm(WerewolfForm.SURVIVALIST)));
        this.switchToForm(WerewolfForm.HUMAN);
        if (!this.werewolf.getSkillHandler().isSkillEnabled((ISkill)ModSkills.SURVIVAL_FORM.get())) {
            this.survival.setTooltip(notUnlocked);
        }
        if (!this.werewolf.getSkillHandler().isSkillEnabled((ISkill)ModSkills.BEAST_FORM.get())) {
            this.beast.setTooltip(notUnlocked);
        }
    }

    private void sync() {
        boolean beastUnlocked = this.werewolf.getSkillHandler().isSkillEnabled((ISkill)ModSkills.BEAST_FORM.get());
        boolean survivalUnlocked = this.werewolf.getSkillHandler().isSkillEnabled((ISkill)ModSkills.SURVIVAL_FORM.get());
        if (this.activeForm == WerewolfForm.BEAST) {
            this.beast.active = false;
            this.human.active = true;
            this.survival.active = survivalUnlocked;
            this.glowingEyesButton.active = true;
            this.glowingEyesButton.visible = true;
            this.eyeButton.visible = true;
        } else if (this.activeForm == WerewolfForm.SURVIVALIST) {
            this.beast.active = beastUnlocked;
            this.human.active = true;
            this.survival.active = false;
            this.glowingEyesButton.active = true;
            this.glowingEyesButton.visible = true;
            this.eyeButton.visible = true;
        } else {
            this.beast.active = beastUnlocked;
            this.human.active = false;
            this.survival.active = survivalUnlocked;
            this.glowingEyesButton.active = false;
            this.glowingEyesButton.visible = false;
            this.eyeButton.visible = false;
        }
    }

    private void switchToForm(WerewolfForm form) {
        if (this.eyeButton != null) {
            this.removeWidget((GuiEventListener)this.eyeButton);
            this.removeWidget((GuiEventListener)this.skinButton);
            this.removeWidget((GuiEventListener)this.eyeList);
            this.removeWidget((GuiEventListener)this.skinList);
            this.removeWidget((GuiEventListener)this.glowingEyesButton);
        }
        if (this.activeForm != null) {
            this.updateServer();
        }
        this.activeForm = form;
        this.skinType = this.werewolf.getSkinType(form);
        this.eyeType = this.werewolf.getEyeType(form);
        this.glowingEyes = this.werewolf.hasGlowingEyes(form);
        this.glowingEyesButton = (Checkbox)this.addRenderableWidget((GuiEventListener)Checkbox.builder((Component)Component.translatable((String)"gui.vampirism.appearance.glowing_eye"), (Font)this.font).pos(this.guiLeft + 20, this.guiTop + 90).selected(this.glowingEyes).onValueChange((button, selected) -> {
            this.glowingEyes = selected;
            this.werewolf.setGlowingEyes(form, this.glowingEyes);
        }).build());
        this.eyeList = (HoverList)this.addRenderableWidget((GuiEventListener)HoverList.builder((int)(this.guiLeft + 20), (int)(this.guiTop + 30 + 19 + 20), (int)99, (int)100).componentsWithClickAndHover(IntStream.range(0, 9).mapToObj(type -> Component.translatable((String)"text.werewolves.appearance.eye").append(" " + (type + 1))).toList(), this::eye, this::hoverEye).build());
        this.eyeButton = (ExtendedButton)this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.eyeList.getX(), this.eyeList.getY() - 20, this.eyeList.getWidth(), 20, (Component)Component.empty(), b -> this.setEyeListVisibility(!this.eyeList.visible)));
        this.skinList = (HoverList)this.addRenderableWidget((GuiEventListener)HoverList.builder((int)(this.guiLeft + 20), (int)(this.guiTop + 50 + 19 + 20), (int)99, (int)80).componentsWithClickAndHover(IntStream.range(0, form.getSkinTypes()).mapToObj(type -> Component.translatable((String)"text.werewolves.appearance.skin").append(" " + (type + 1))).toList(), this::skin, this::hoverSkin).build());
        this.skinButton = (ExtendedButton)this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.skinList.getX(), this.skinList.getY() - 20, this.skinList.getWidth(), 20, (Component)Component.empty(), b -> this.setSkinListVisibility(!this.skinList.visible)));
        this.setEyeListVisibility(false);
        this.setSkinListVisibility(false);
        this.sync();
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        List copyOf = List.copyOf(this.children());
        for (int i = copyOf.size() - 1; i >= 0; --i) {
            GuiEventListener listener = (GuiEventListener)copyOf.get(i);
            if (!listener.mouseClicked(pMouseX, pMouseY, pButton)) continue;
            this.setFocused(listener);
            if (pButton == 0) {
                this.setDragging(true);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public Optional<GuiEventListener> getChildAt(double pMouseX, double pMouseY) {
        List children = this.children();
        for (int i = children.size() - 1; i >= 0; --i) {
            GuiEventListener guieventlistener = (GuiEventListener)children.get(i);
            if (!guieventlistener.isMouseOver(pMouseX, pMouseY)) continue;
            return Optional.of(guieventlistener);
        }
        return Optional.empty();
    }

    public void render(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderForm = true;
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.eyeList.render(graphics, mouseX, mouseY, partialTicks);
        this.skinList.render(graphics, mouseX, mouseY, partialTicks);
        this.renderForm = false;
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (!this.eyeList.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY) && !this.skinList.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY)) {
            return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
        }
        return true;
    }

    public boolean isRenderForm() {
        return this.renderForm;
    }

    public WerewolfForm getActiveForm() {
        return this.activeForm;
    }

    private void setEyeListVisibility(boolean show) {
        this.eyeButton.setMessage((Component)Component.translatable((String)"text.werewolves.appearance.eye").append(" " + (this.eyeType + 1)));
        this.eyeList.visible = show;
        this.skinButton.visible = !show;
        boolean bl = this.glowingEyesButton.visible = !show;
        if (show) {
            this.skinList.visible = false;
        }
    }

    private void setSkinListVisibility(boolean show) {
        this.skinButton.setMessage((Component)Component.translatable((String)"text.werewolves.appearance.skin").append(" " + (this.skinType + 1)));
        this.skinList.visible = show;
        boolean bl = this.glowingEyesButton.visible = !show;
        if (show) {
            this.eyeList.visible = false;
        }
    }

    private void eye(int eyeType) {
        this.eyeType = eyeType;
        this.werewolf.setEyeType(this.activeForm, eyeType);
        this.setEyeListVisibility(false);
    }

    private void skin(int skinType) {
        this.skinType = skinType;
        this.werewolf.setSkinType(this.activeForm, skinType);
        this.setSkinListVisibility(false);
    }

    private void hoverEye(int eyeType, boolean hovered) {
        if (hovered) {
            this.werewolf.setEyeType(this.activeForm, eyeType);
        } else if (this.werewolf.getEyeType() == eyeType) {
            this.werewolf.setEyeType(this.activeForm, this.eyeType);
        }
    }

    private void hoverSkin(int skintype, boolean hovered) {
        if (hovered) {
            this.werewolf.setSkinType(this.activeForm, skintype);
        } else if (this.werewolf.getSkinType() == skintype) {
            this.werewolf.setSkinType(this.activeForm, this.skinType);
        }
    }
}

