/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.core;

import com.mojang.blaze3d.pipeline.RenderTarget;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.werewolves.api.WResourceLocation;
import de.teamlapen.werewolves.core.ModActions;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class RenderHandler
implements ResourceManagerReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int ENTITY_NEAR_SQ_DISTANCE = 100;
    @Nonnull
    private final Minecraft mc;
    private final int VISION_FADE_TICKS = 30;
    private OutlineBufferSource visionBuffer;
    private int ticks;
    private int lastTicks;
    @Nullable
    private PostChain blurShader;
    private int displayHeight;
    private int displayWidth;
    private boolean isInsideVisionRendering = false;
    private PostPass blit;
    private PostPass blur1;
    private PostPass blur2;

    public RenderHandler(@Nonnull Minecraft mc) {
        this.mc = mc;
    }

    @SubscribeEvent
    public void onCameraSetup(@NotNull ViewportEvent.ComputeCameraAngles event) {
        if (this.shouldRenderVision()) {
            this.updateDisplaySize();
            this.adjustVisionShaders(this.getVisionProgress((float)event.getPartialTick()));
        }
    }

    @SubscribeEvent
    public void onClientTick(ClientTickEvent.Pre event) {
        if (this.mc.level == null || this.mc.player == null || !this.mc.player.isAlive()) {
            return;
        }
        this.lastTicks = this.ticks;
        WerewolfPlayer werewolf = WerewolfPlayer.get((Player)this.mc.player);
        if (werewolf.getActionHandler().isActionActive((ILastingAction)ModActions.SENSE.get())) {
            if (this.ticks < 30) {
                ++this.ticks;
            }
        } else if (this.ticks > 0) {
            this.ticks -= 2;
        }
    }

    @SubscribeEvent
    public void onRenderLivingPost(@NotNull RenderLivingEvent.Post<?, ?> event) {
        LivingEntity entity;
        double dist;
        if (!this.isInsideVisionRendering && this.shouldRenderVision() && !((dist = this.mc.player.distanceToSqr((Entity)(entity = event.getEntity()))) > (double)((Integer)VampirismConfig.BALANCE.vsBloodVisionDistanceSq.get()).intValue()) && !entity.isInWater()) {
            int color = 0xA0A0A0;
            if (entity instanceof IFactionEntity) {
                color = ((IFactionEntity)entity).getFaction().getColor();
            } else if (!entity.isInvertedHealAndHarm()) {
                color = 0xFF0000;
            }
            EntityRenderDispatcher renderManager = this.mc.getEntityRenderDispatcher();
            if (this.visionBuffer == null) {
                this.visionBuffer = new OutlineBufferSource(this.mc.renderBuffers().bufferSource());
            }
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            int alpha = (int)((dist > 100.0 ? 50.0 : dist / 100.0 * 50.0) * (double)this.getVisionProgress(event.getPartialTick()));
            this.visionBuffer.setColor(r, g, b, alpha);
            float f = Mth.lerp((float)event.getPartialTick(), (float)entity.yRotO, (float)entity.getYRot());
            this.isInsideVisionRendering = true;
            EntityRenderer entityRenderer = renderManager.getRenderer((Entity)entity);
            entityRenderer.render((Entity)entity, f, event.getPartialTick(), event.getPoseStack(), (MultiBufferSource)this.visionBuffer, renderManager.getPackedLightCoords((Entity)entity, event.getPartialTick()));
            this.mc.getMainRenderTarget().bindWrite(false);
            this.isInsideVisionRendering = false;
        }
    }

    @SubscribeEvent
    public void onWorldLoad(LevelEvent.Load event) {
        this.ticks = 0;
    }

    private float getVisionProgress(float partialTicks) {
        return ((float)this.ticks + (float)(this.ticks - this.lastTicks) * partialTicks) / 30.0f;
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER) {
            if (this.mc.level == null) {
                return;
            }
            if (this.shouldRenderVision()) {
                this.blurShader.process(event.getPartialTick().getGameTimeDeltaTicks());
                this.mc.getMainRenderTarget().bindWrite(false);
            }
        }
    }

    public void endVisionBatch() {
        if (this.shouldRenderVision() && this.visionBuffer != null) {
            this.visionBuffer.endOutlineBatch();
        }
    }

    private void updateDisplaySize() {
        if (this.displayHeight != this.mc.getWindow().getHeight() || this.displayWidth != this.mc.getWindow().getWidth()) {
            this.displayHeight = this.mc.getWindow().getHeight();
            this.displayWidth = this.mc.getWindow().getWidth();
            this.updateFramebufferSize(this.displayWidth, this.displayHeight);
        }
    }

    private void adjustVisionShaders(float progress) {
        if (this.blit == null || this.blur1 == null) {
            return;
        }
        progress = Mth.clamp((float)progress, (float)0.0f, (float)1.0f);
        this.blit.getEffect().safeGetUniform("ColorModulate").set(1.0f - 0.4f * progress, 1.0f - 0.5f * progress, 1.0f - 0.3f * progress, 1.0f);
        this.blur1.getEffect().safeGetUniform("Radius").set((float)Math.round(5.0f * progress));
        this.blur2.getEffect().safeGetUniform("Radius").set((float)Math.round(5.0f * progress));
    }

    private void updateFramebufferSize(int width, int height) {
        if (this.blurShader != null) {
            this.blurShader.resize(width, height);
        }
    }

    private boolean shouldRenderVision() {
        return this.ticks > 0 && this.blurShader != null && this.mc.player != null;
    }

    public void onResourceManagerReload(@Nonnull ResourceManager p_10758_) {
        this.reMakeShader();
    }

    private void reMakeShader() {
        if (this.blurShader != null) {
            this.blurShader.close();
        }
        ResourceLocation resourcelocationBlur = WResourceLocation.v("shaders/blank.json");
        try {
            this.blurShader = new PostChain(this.mc.getTextureManager(), (ResourceProvider)this.mc.getResourceManager(), this.mc.getMainRenderTarget(), resourcelocationBlur);
            RenderTarget swap = this.blurShader.getTempTarget("swap");
            this.blit = this.blurShader.addPass("blit", swap, this.mc.getMainRenderTarget(), false);
            this.blur1 = this.blurShader.addPass("blur", this.mc.getMainRenderTarget(), swap, false);
            this.blur1.getEffect().safeGetUniform("BlurDir").set(1.0f, 0.0f);
            this.blur2 = this.blurShader.addPass("blur", swap, this.mc.getMainRenderTarget(), false);
            this.blur2.getEffect().safeGetUniform("BlurDir").set(0.0f, 1.0f);
            this.blurShader.resize(this.mc.getWindow().getWidth(), this.mc.getWindow().getHeight());
        }
        catch (Exception e) {
            LOGGER.warn("Failed to load blood vision blur shader", (Throwable)e);
            this.blurShader = null;
        }
    }
}

