/*
 * Decompiled with CFR 0.152.
 */
package com.Pdiddy973.AllTheCompressed.data;

import com.Pdiddy973.AllTheCompressed.data.client.BlockStates;
import com.Pdiddy973.AllTheCompressed.data.client.Languages;
import com.Pdiddy973.AllTheCompressed.data.client.XycraftBlockStates;
import com.Pdiddy973.AllTheCompressed.data.server.BlockLoot;
import com.Pdiddy973.AllTheCompressed.data.server.BlockTags;
import com.Pdiddy973.AllTheCompressed.data.server.CraftingRecipes;
import com.Pdiddy973.AllTheCompressed.data.server.DataMaps;
import com.Pdiddy973.AllTheCompressed.data.server.ItemTags;
import java.util.Collections;
import java.util.List;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, modid="allthecompressed")
public final class DataGenerators {
    private DataGenerators() {
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        if (!event.getModContainer().getModId().equals("allthecompressed")) {
            return;
        }
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        if (event.includeServer()) {
            BlockTags blockTags = new BlockTags(generator, event.getLookupProvider(), fileHelper);
            generator.addProvider(true, (DataProvider)blockTags);
            generator.addProvider(true, (DataProvider)new ItemTags(generator, event.getLookupProvider(), blockTags.contentsGetter(), fileHelper));
            generator.addProvider(true, (DataProvider)new CraftingRecipes(packOutput, event.getLookupProvider()));
            generator.addProvider(true, (DataProvider)new DataMaps(packOutput, event.getLookupProvider()));
            generator.addProvider(true, (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(BlockLoot::new, LootContextParamSets.BLOCK)), event.getLookupProvider()));
        }
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new BlockStates(packOutput, fileHelper));
            generator.addProvider(true, (DataProvider)new XycraftBlockStates(packOutput, fileHelper));
            generator.addProvider(true, (DataProvider)new Languages.English(packOutput, fileHelper));
        }
    }
}

