/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamicsandfriends.compat;

import com.teamabnormals.clayworks.common.block.GlassDoorBlock;
import com.teamabnormals.clayworks.common.block.GlassTrapDoorBlock;
import com.teamabnormals.clayworks.core.registry.ClayworksBlocks;
import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import cy.jdkdigital.dyenamicsandfriends.registry.DyenamicRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.PotDecorations;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.event.BlockEntityTypeAddBlocksEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ClayworksCompat {
    public static final List<DeferredHolder<Block, ? extends Block>> BLOCKS = new ArrayList<DeferredHolder<Block, ? extends Block>>();
    public static final List<DeferredHolder<Block, ? extends Block>> STAIRS = new ArrayList<DeferredHolder<Block, ? extends Block>>();
    public static final List<DeferredHolder<Block, ? extends Block>> SLABS = new ArrayList<DeferredHolder<Block, ? extends Block>>();
    public static final List<DeferredHolder<Block, ? extends Block>> WALLS = new ArrayList<DeferredHolder<Block, ? extends Block>>();
    public static final List<DeferredHolder<Block, ? extends Block>> DOORS = new ArrayList<DeferredHolder<Block, ? extends Block>>();
    public static final List<DeferredHolder<Block, ? extends Block>> TRAPDOORS = new ArrayList<DeferredHolder<Block, ? extends Block>>();
    public static final List<DeferredHolder<Block, ? extends Block>> POTS = new ArrayList<DeferredHolder<Block, ? extends Block>>();

    public static void registerBlocks(DyenamicDyeColor color) {
        String prefix = "clayworks_" + color.getSerializedName();
        BlockBehaviour.Properties properties = ClayworksBlocks.ClayworksProperties.terracotta((MapColor)color.getMapColor()).lightLevel(state -> color.getLightValue());
        WALLS.add(DyenamicRegistry.registerBlock(prefix + "_terracotta_wall", () -> new WallBlock(properties), true));
        SLABS.add(DyenamicRegistry.registerBlock(prefix + "_terracotta_slab", () -> new SlabBlock(properties), true));
        STAIRS.add(DyenamicRegistry.registerBlock(prefix + "_terracotta_stairs", () -> new StairBlock(((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)("dyenamics:" + color.getSerializedName() + "_terracotta")))).defaultBlockState(), properties), true));
        BLOCKS.add(DyenamicRegistry.registerBlock(prefix + "_terracotta_bricks", () -> new Block(properties), true));
        WALLS.add(DyenamicRegistry.registerBlock(prefix + "_terracotta_brick_wall", () -> new WallBlock(properties), true));
        STAIRS.add(DyenamicRegistry.registerBlock(prefix + "_terracotta_brick_stairs", () -> new StairBlock(((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)("dyenamics:" + color.getSerializedName() + "_terracotta")))).defaultBlockState(), properties), true));
        SLABS.add(DyenamicRegistry.registerBlock(prefix + "_terracotta_brick_slab", () -> new SlabBlock(properties), true));
        BLOCKS.add(DyenamicRegistry.registerBlock(prefix + "_terracotta_chiseled_bricks", () -> new Block(properties), true));
        DOORS.add(DyenamicRegistry.registerBlock(prefix + "_stained_glass_door", () -> new GlassDoorBlock(color.getAnalogue()), true));
        TRAPDOORS.add(DyenamicRegistry.registerBlock(prefix + "_stained_glass_trapdoor", () -> new GlassTrapDoorBlock(color.getAnalogue()), true));
    }

    public static void buildTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey().equals(CreativeModeTabs.COLORED_BLOCKS)) {
            BLOCKS.forEach(holder -> event.accept((ItemLike)holder.get()));
            WALLS.forEach(holder -> event.accept((ItemLike)holder.get()));
            SLABS.forEach(holder -> event.accept((ItemLike)holder.get()));
            STAIRS.forEach(holder -> event.accept((ItemLike)holder.get()));
            DOORS.forEach(holder -> event.accept((ItemLike)holder.get()));
            TRAPDOORS.forEach(holder -> event.accept((ItemLike)holder.get()));
        }
        if (event.getTabKey().equals(CreativeModeTabs.REDSTONE_BLOCKS)) {
            DOORS.forEach(holder -> event.accept((ItemLike)holder.get()));
            TRAPDOORS.forEach(holder -> event.accept((ItemLike)holder.get()));
        }
    }

    public static void addBlocks(BlockEntityTypeAddBlocksEvent event) {
    }

    public static DyenamicDyeColor getDyeColorFromPot(Block block) {
        ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
        if (id.getNamespace().equals("dyenamicsandfriends") && id.getPath().startsWith("clayworks_") && id.getPath().endsWith("_decorated_pot")) {
            return DyenamicDyeColor.byTranslationKey((String)id.getPath().replace("claywworks_", "").replace("_decorated_pot", ""), (DyenamicDyeColor)DyenamicDyeColor.WHITE);
        }
        return null;
    }

    static DeferredHolder<Block, ? extends Block> createPot(String name, DyenamicDyeColor color) {
        DeferredHolder<Block, ? extends Block> block = DyenamicRegistry.registerBlock(name, () -> new DecoratedPotBlock(ClayworksBlocks.ClayworksProperties.decoratedPot((MapColor)color.getMapColor())), false);
        DyenamicRegistry.registerItem(name, () -> new BlockItem((Block)block.get(), new Item.Properties().component(DataComponents.POT_DECORATIONS, (Object)PotDecorations.EMPTY)));
        return block;
    }

    public static class Client {
        public static void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            DOORS.forEach(registryObject -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.translucent()));
            TRAPDOORS.forEach(registryObject -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.translucent()));
        }

        public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        }
    }
}

