/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.network.shared;

import com.cyanogen.cognition.block_entities.ExperienceObeliskEntity;
import com.cyanogen.cognition.block_entities.ExperienceReceivingEntity;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class UpdateRedstone
implements CustomPacketPayload {
    public final int posX;
    public final int posY;
    public final int posZ;
    public final boolean isControllable;
    public static final StreamCodec<ByteBuf, UpdateRedstone> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, UpdateRedstone::getPosX, (StreamCodec)ByteBufCodecs.VAR_INT, UpdateRedstone::getPosY, (StreamCodec)ByteBufCodecs.VAR_INT, UpdateRedstone::getPosZ, (StreamCodec)ByteBufCodecs.BOOL, UpdateRedstone::getControllable, UpdateRedstone::new);
    public static final CustomPacketPayload.Type<UpdateRedstone> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cognition", (String)"update_redstone"));

    public UpdateRedstone(@Nullable BlockPos pos, boolean isControllable) {
        if (pos == null) {
            this.posX = 0;
            this.posY = 0;
            this.posZ = 0;
        } else {
            this.posX = pos.getX();
            this.posY = pos.getY();
            this.posZ = pos.getZ();
        }
        this.isControllable = isControllable;
    }

    public UpdateRedstone(int posX, int posY, int posZ, boolean isControllable) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.isControllable = isControllable;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public int getPosZ() {
        return this.posZ;
    }

    public boolean getControllable() {
        return this.isControllable;
    }

    public static void handleServer(UpdateRedstone packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (!context.player().level().isClientSide) {
                ServerPlayer sender = (ServerPlayer)context.player();
                BlockEntity serverEntity = sender.level().getBlockEntity(new BlockPos(packet.posX, packet.posY, packet.posZ));
                if (serverEntity instanceof ExperienceObeliskEntity) {
                    ExperienceObeliskEntity obelisk = (ExperienceObeliskEntity)serverEntity;
                    obelisk.setRedstoneEnabled(packet.isControllable);
                } else if (serverEntity instanceof ExperienceReceivingEntity) {
                    ExperienceReceivingEntity receiver = (ExperienceReceivingEntity)serverEntity;
                    receiver.setRedstoneEnabled(packet.isControllable);
                }
            }
        });
    }
}

