/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.item;

import com.cyanogen.cognition.block_entities.bibliophage.agar.FluorescentAgarEntity;
import com.cyanogen.cognition.recipe.InfectingRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BibliophageItem
extends Item {
    public BibliophageItem(Item.Properties p) {
        super(p);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        BlockState newBlock = InfectingRecipe.getInfectedBlockState(level, level.getBlockState(pos));
        if (newBlock != null) {
            boolean success = BibliophageItem.infectBlock(level, pos, newBlock);
            if (success && player != null && !player.isCreative()) {
                player.getItemInHand(hand).shrink(1);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useOn(context);
    }

    public static boolean infectBlock(Level level, BlockPos pos, @NotNull BlockState newBlock) {
        boolean success;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FluorescentAgarEntity) {
            FluorescentAgarEntity fluorescentAgarEntity = (FluorescentAgarEntity)blockEntity;
            fluorescentAgarEntity.incrementInfectionProgress();
            return true;
        }
        if (!level.isClientSide && (success = level.setBlockAndUpdate(pos, newBlock))) {
            level.playSound(null, pos, SoundEvents.WART_BLOCK_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.levelEvent(null, 2001, pos, Block.getId((BlockState)newBlock));
            return true;
        }
        return false;
    }
}

