/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.gui;

import com.cyanogen.cognition.block_entities.MolecularMetamorpherEntity;
import com.cyanogen.cognition.gui.MolecularMetamorpherMenu;
import com.cyanogen.cognition.gui.MolecularMetamorpherOptionsScreen;
import com.cyanogen.cognition.utils.ExperienceUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class MolecularMetamorpherScreen
extends AbstractContainerScreen<MolecularMetamorpherMenu> {
    private final ResourceLocation texture = ResourceLocation.parse((String)"cognition:textures/gui/screens/molecular_metamorpher.png");
    private final Component title = Component.translatable((String)"title.cognition.molecular_metamorpher");
    private final Component inventoryTitle = Component.translatable((String)"title.cognition.precision_dispeller.inventory");
    private final Level clientLevel;
    public final Inventory inventory;
    public final Component component;
    private final int[] inputSlotsX = new int[]{19, 50, 70};
    private final int[] inputSlotsY = new int[]{35, 52, 18};
    private final List<Button> buttons = new ArrayList<Button>();

    public MolecularMetamorpherScreen(MolecularMetamorpherMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        this.clientLevel = inventory.player.level();
        this.inventory = inventory;
        this.component = component;
    }

    protected void renderBg(GuiGraphics gui, float f, int a, int b) {
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    protected void renderLabels(GuiGraphics gui, int mouseX, int mouseY) {
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void init() {
        this.setupWidgetElements();
        super.init();
    }

    protected void renderTitles(GuiGraphics gui, int titleX, int titleY, int inventoryX, int inventoryY) {
        gui.drawString(this.font, this.title, titleX, titleY, 0xFFFFFF);
        gui.drawString(this.font, this.inventoryTitle, inventoryX, inventoryY, 0xFFFFFF);
    }

    public void render(GuiGraphics gui, int mouseX, int mouseY, float partialTick) {
        BlockEntity blockEntity;
        BlockPos pos = ((MolecularMetamorpherMenu)this.menu).getBlockPos();
        this.renderTransparentBackground(gui);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        gui.blit(this.texture, x, y, 0, 0, 176, 166);
        if (pos != null && (blockEntity = this.clientLevel.getBlockEntity(pos)) instanceof MolecularMetamorpherEntity) {
            MolecularMetamorpherEntity metamorpher = (MolecularMetamorpherEntity)blockEntity;
            if (metamorpher.getBoundObelisk() != null) {
                int xpBarLength = 61;
                int levels = metamorpher.getBoundObelisk().getLevels();
                int points = metamorpher.getBoundObelisk().getExperiencePoints();
                double progress = ExperienceUtils.getProgressToNextLevel(points, levels);
                gui.blit(this.texture, this.width / 2 + 105 - 88, this.height / 2 + 70 - 83, 0, 179, 64, 11);
                gui.blit(this.texture, this.width / 2 + 107 - 88, this.height / 2 + 71 - 83, 0, 166, (int)((double)xpBarLength * progress), 9);
                gui.drawCenteredString(this.font, (Component)Component.literal((String)String.valueOf(levels)).withStyle(ChatFormatting.GREEN), this.width / 2 + 52, this.height / 2 - 11, 0xFFFFFF);
                int x1 = this.width / 2 + 19;
                int y1 = this.height / 2 - 12;
                int x2 = x1 + xpBarLength;
                int y2 = y1 + 9;
                ArrayList<MutableComponent> tooltipList = new ArrayList<MutableComponent>();
                tooltipList.add(Component.translatable((String)"tooltip.cognition.molecular_metamorpher.bound"));
                tooltipList.add(Component.translatable((String)"tooltip.cognition.molecular_metamorpher.xp", (Object[])new Object[]{Component.literal((String)String.valueOf(points)).withStyle(ChatFormatting.GREEN)}));
                if (mouseX >= x1 && mouseX <= x2 && mouseY >= y1 && mouseY <= y2) {
                    gui.renderTooltip(this.font, tooltipList, Optional.empty(), mouseX, mouseY);
                }
            }
            if (metamorpher.inputsAreLocked()) {
                for (int i = 0; i < 3; ++i) {
                    ItemStack stack = metamorpher.getSavedInputs().getStackInSlot(i);
                    gui.renderFakeItem(stack, x + this.inputSlotsX[i], y + this.inputSlotsY[i]);
                    gui.fill(x + this.inputSlotsX[i], y + this.inputSlotsY[i], x + this.inputSlotsX[i] + 16, y + this.inputSlotsY[i] + 16, 220, -1937011829);
                }
            }
            int arrowWidth = 26;
            double completion = 0.0;
            if (metamorpher.getProcessTime() != 0) {
                completion = (float)metamorpher.getProcessProgress() / (float)metamorpher.getProcessTime();
            }
            gui.blit(this.texture, this.width / 2 + 21, this.height / 2 - 35, 0, 175, (int)((double)arrowWidth * completion), 4);
        }
        super.render(gui, mouseX, mouseY, partialTick);
        this.clearWidgets();
        this.loadWidgetElements();
        for (Renderable widget : this.renderables) {
            widget.render(gui, mouseX, mouseY, partialTick);
        }
        this.renderTitles(gui, x + 8, y + 6, x + 8, y + 72);
        this.renderTooltip(gui, mouseX, mouseY);
    }

    private void loadWidgetElements() {
        if (!this.buttons.isEmpty()) {
            for (Button b : this.buttons) {
                b.setFocused(false);
                this.addRenderableWidget((GuiEventListener)b);
            }
        }
    }

    private void setupWidgetElements() {
        this.buttons.clear();
        Button settings = Button.builder((Component)Component.translatable((String)"button.cognition.experience_obelisk.settings"), onPress -> Minecraft.getInstance().setScreen((Screen)new MolecularMetamorpherOptionsScreen((MolecularMetamorpherMenu)this.menu, this.clientLevel))).size(20, 20).pos(this.width / 2 + 91, this.height / 2 - 78).tooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.cognition.experience_obelisk.settings"))).build();
        this.buttons.add(settings);
    }
}

