/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.block_entities.bibliophage;

import com.cyanogen.cognition.item.BibliophageItem;
import com.cyanogen.cognition.recipe.InfectingRecipe;
import com.cyanogen.cognition.registries.RegisterTags;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractInfectiveEntity
extends BlockEntity {
    public AbstractInfectiveEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void infectAdjacent(Level level, BlockPos pos) {
        HashMap<BlockPos, BlockState> adjacentMap = new HashMap<BlockPos, BlockState>();
        for (BlockPos adjacentPos : this.getAdjacents(pos)) {
            BlockState infectedState;
            BlockState adjacentState = level.getBlockState(adjacentPos);
            if (adjacentState.isAir() || adjacentState.is(RegisterTags.Blocks.INFECTIVE_BLOCKS) || (infectedState = InfectingRecipe.getInfectedBlockState(level, adjacentState)) == null) continue;
            adjacentMap.put(adjacentPos, infectedState);
        }
        if (!adjacentMap.isEmpty()) {
            int index = (int)Math.floor(Math.random() * (double)adjacentMap.size());
            BlockPos posToInfect = (BlockPos)adjacentMap.keySet().toArray()[index];
            BlockState newBlock = adjacentMap.getOrDefault(posToInfect, null);
            if (newBlock != null) {
                BibliophageItem.infectBlock(level, posToInfect, newBlock);
            }
        }
    }

    public List<BlockPos> getAdjacents(BlockPos pos) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        list.add(pos.above());
        list.add(pos.below());
        list.add(pos.north());
        list.add(pos.south());
        list.add(pos.east());
        list.add(pos.west());
        return list;
    }

    public List<BlockPos> getEdgeBlocks(BlockPos pos) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        BlockPos above = pos.above();
        BlockPos below = pos.below();
        list.add(above.north());
        list.add(above.south());
        list.add(above.east());
        list.add(above.west());
        list.add(below.north());
        list.add(below.south());
        list.add(below.east());
        list.add(below.west());
        list.add(pos.north().west());
        list.add(pos.north().east());
        list.add(pos.south().west());
        list.add(pos.south().east());
        return list;
    }

    public List<BlockPos> getVertexBlocks(BlockPos pos) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        BlockPos above = pos.above();
        BlockPos below = pos.below();
        list.add(above.north().west());
        list.add(above.north().east());
        list.add(above.south().west());
        list.add(above.south().east());
        list.add(below.north().west());
        list.add(below.north().east());
        list.add(below.south().west());
        list.add(below.south().east());
        return list;
    }
}

