/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.vampiricageing.oils;

import com.thedrofdoctoring.vampiricageing.capabilities.AgeingManager;
import com.thedrofdoctoring.vampiricageing.capabilities.CapabilityHelper;
import com.thedrofdoctoring.vampiricageing.config.HunterAgeingConfig;
import de.teamlapen.vampirism.api.items.oil.IWeaponOil;
import de.teamlapen.vampirism.items.oil.WeaponOil;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SeniorityOil
extends WeaponOil {
    public SeniorityOil(int color, int maxDuration) {
        super(color, maxDuration);
    }

    public float onDamage(ItemStack stack, float amount, IWeaponOil oil, LivingEntity target, LivingEntity source) {
        float bonusDamage = 0.0f;
        if (!Helper.isHunter((Entity)source)) {
            return bonusDamage;
        }
        int sourceAge = AgeingManager.getAge(source).map(AgeingManager::getAge).orElse(0);
        if (sourceAge < (Integer)HunterAgeingConfig.seniorityOilUseAge.get()) {
            return bonusDamage;
        }
        if (Helper.isVampire((Entity)target) || CapabilityHelper.isWerewolfCheckMod((Entity)target)) {
            int targetAge = AgeingManager.getAge(target).map(AgeingManager::getAge).orElse(0);
            bonusDamage = ((Double)((List)HunterAgeingConfig.seniorityOilDamageBonus.get()).get(targetAge)).floatValue();
            return amount * bonusDamage;
        }
        return bonusDamage;
    }

    public void getDescription(ItemStack stack, Item.TooltipContext context, List<Component> tooltips) {
        super.getDescription(stack, context, tooltips);
        tooltips.add((Component)Component.translatable((String)"text.vampiricageing.useable_by", (Object[])new Object[]{HunterAgeingConfig.seniorityOilUseAge.get()}).withStyle(ChatFormatting.DARK_RED));
        tooltips.add((Component)Component.translatable((String)"text.vampiricageing.seniority_oil.when_applied").withStyle(ChatFormatting.GRAY));
        tooltips.add((Component)Component.literal((String)"  ").append((Component)Component.translatable((String)"text.vampiricageing.oil.seniority_oil.more_damage").withStyle(ChatFormatting.DARK_GREEN)));
    }
}

