/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.vampiricageing.mixin;

import com.thedrofdoctoring.vampiricageing.capabilities.AgeingManager;
import com.thedrofdoctoring.vampiricageing.capabilities.CapabilityHelper;
import com.thedrofdoctoring.vampiricageing.config.CommonConfig;
import com.thedrofdoctoring.vampiricageing.config.HunterAgeingConfig;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Villager.class})
public abstract class VillagerMixin
extends AbstractVillager {
    @Shadow
    public abstract VillagerData getVillagerData();

    public VillagerMixin(EntityType<? extends AbstractVillager> p_35267_, Level p_35268_) {
        super(p_35267_, p_35268_);
    }

    @Inject(method={"updateSpecialPrices"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/npc/Villager;getPlayerReputation(Lnet/minecraft/world/entity/player/Player;)I", shift=At.Shift.BEFORE)})
    private void updateSpecialPrices(Player player, CallbackInfo ci) {
        VillagerProfession profession;
        if (((Boolean)CommonConfig.doesAgeAffectPrices.get()).booleanValue() && !BuiltInRegistries.VILLAGER_PROFESSION.wrapAsHolder((Object)(profession = this.getVillagerData().getProfession())).is(ModTags.Professions.HAS_FACTION)) {
            int age = AgeingManager.getAge(player).getAge();
            int cumulativeAge = CapabilityHelper.getCumulativeTaintedAge(player);
            if (!Helper.isHunter((Player)player) || cumulativeAge >= (Integer)HunterAgeingConfig.taintedBloodWorseTradeDealsAge.get()) {
                for (MerchantOffer merchantoffer1 : this.getOffers()) {
                    double ageMult = !Helper.isHunter((Player)player) ? (Double)((List)CommonConfig.ageAffectTradePrices.get()).get(age) : (double)((Double)((List)HunterAgeingConfig.taintedBloodTradeDealPricesMultiplier.get()).get(cumulativeAge)).floatValue();
                    double d0 = 1.0 - ageMult;
                    int j = d0 != 0.0 ? (int)Math.floor((double)merchantoffer1.getBaseCostA().getCount() * (ageMult - 1.0)) : 0;
                    merchantoffer1.addToSpecialPriceDiff(j);
                }
            }
        }
    }
}

