/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.vampiricageing.items;

import com.thedrofdoctoring.vampiricageing.capabilities.AgeingManager;
import com.thedrofdoctoring.vampiricageing.config.CommonConfig;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class BloodTesterItem
extends Item {
    public BloodTesterItem(Item.Properties props) {
        super(props);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity source) {
        if (source instanceof Player) {
            Player player = (Player)source;
            if (!source.getCommandSenderWorld().isClientSide && target.isAlive() && Helper.isVampire((Entity)target) && (target.getType() == EntityType.PLAYER || target.getType().is(ModTags.Entities.ADVANCED_VAMPIRE) && ((Boolean)CommonConfig.advancedVampireAge.get()).booleanValue())) {
                int age = 0;
                if (AgeingManager.getAge(target).isPresent()) {
                    age = AgeingManager.getAge(target).get().getAge();
                }
                player.sendSystemMessage((Component)Component.translatable((String)"text.vampiricageing.vampire_blood_rank", (Object[])new Object[]{age}));
            }
        }
        return super.hurtEnemy(stack, target, source);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        pTooltipComponents.add((Component)Component.translatable((String)"text.vampiricageing.blood_tester_usage").withStyle(ChatFormatting.GRAY));
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
    }
}

