/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.vampiricageing.capabilities;

import com.thedrofdoctoring.vampiricageing.capabilities.AgeingManager;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.AgeingRegistry;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.IAgeMethod;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.IAgeType;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.types.HunterAgeingType;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.types.TypeState;
import com.thedrofdoctoring.vampiricageing.config.HunterAgeingConfig;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.werewolves.api.WReference;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;

public class CapabilityHelper {
    public static boolean isWerewolfCheckMod(Entity entity) {
        if (!ModList.get().isLoaded("werewolves")) {
            return false;
        }
        return de.teamlapen.werewolves.util.Helper.isWerewolf((Entity)entity);
    }

    public static boolean isWerewolfCheckMod(Entity entity, IPlayableFaction<?> faction) {
        if (!ModList.get().isLoaded("werewolves")) {
            return false;
        }
        return de.teamlapen.werewolves.util.Helper.isWerewolf((Entity)entity) || faction == WReference.WEREWOLF_FACTION;
    }

    public static boolean isRawMeat(@Nullable LivingEntity entity, ItemStack stack) {
        return de.teamlapen.werewolves.util.Helper.isRawMeat((LivingEntity)entity, (ItemStack)stack);
    }

    public static int getCumulativeTaintedAge(Player player) {
        if (!Helper.isHunter((Player)player) || !((Boolean)HunterAgeingConfig.taintedBloodAvailable.get()).booleanValue()) {
            return 0;
        }
        AgeingManager age = AgeingManager.getAge(player);
        TypeState typeState = age.getTypeState();
        if (typeState instanceof HunterAgeingType.HunterState) {
            HunterAgeingType.HunterState state = (HunterAgeingType.HunterState)typeState;
            boolean transformed = state.isTransformed();
            int tainted = state.getTemporaryTaintedAgeBonus();
            int bonus = transformed ? 6 : tainted;
            int rank = age.getAge();
            if (rank == 0 && !transformed) {
                return 0;
            }
            return rank + bonus;
        }
        return 0;
    }

    public static void setDefaultAgeTypeAndMethod(Player player) {
        AgeingManager manager = AgeingManager.getAge(player);
        for (IAgeType type : AgeingRegistry.getAgeingTypes()) {
            FactionPlayerHandler handler = FactionPlayerHandler.get((Player)player);
            if (!type.isEnabled() || handler.getCurrentLevel() < type.minFactionRank() || type.faction() != handler.getCurrentFaction()) continue;
            manager.setType(type);
        }
        for (IAgeMethod method : AgeingRegistry.getAgeingMethods()) {
            if (!method.isEnabled() || method.getValidType() != manager.getType()) continue;
            manager.setMethod(method);
        }
        manager.sync(false);
    }
}

