/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.vampiricageing.actions;

import com.thedrofdoctoring.vampiricageing.capabilities.CapabilityHelper;
import com.thedrofdoctoring.vampiricageing.capabilities.other.IHunterSpecialAttributes;
import com.thedrofdoctoring.vampiricageing.config.HunterAgeingConfig;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.hunter.DefaultHunterAction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.entity.AreaParticleCloudEntity;
import de.teamlapen.vampirism.entity.player.hunter.HunterPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class HunterTeleportAction
extends DefaultHunterAction {
    public boolean activate(@NotNull IHunterPlayer hunter, IAction.ActivationContext context) {
        Player player = hunter.getRepresentingPlayer();
        int dist = (Integer)HunterAgeingConfig.hunterTeleportActionMaxDistance.get();
        HitResult target = UtilLib.getPlayerLookingSpot((Player)player, (double)dist);
        double ox = player.getX();
        double oy = player.getY();
        double oz = player.getZ();
        if (target.getType() == HitResult.Type.MISS) {
            player.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value(), 1.0f, 1.0f);
            return false;
        }
        BlockPos pos = null;
        if (target.getType() == HitResult.Type.BLOCK) {
            if (player.getCommandSenderWorld().getBlockState(((BlockHitResult)target).getBlockPos()).blocksMotion()) {
                pos = ((BlockHitResult)target).getBlockPos().above();
            }
        } else if (player.getCommandSenderWorld().getBlockState(((EntityHitResult)target).getEntity().blockPosition()).blocksMotion()) {
            pos = ((EntityHitResult)target).getEntity().blockPosition();
        }
        if (pos != null) {
            player.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5);
            if (player.getCommandSenderWorld().containsAnyLiquid(player.getBoundingBox()) || !player.getCommandSenderWorld().isUnobstructed((Entity)player)) {
                pos = null;
            }
        }
        if (pos == null) {
            player.setPos(ox, oy, oz);
            player.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_BASEDRUM.value(), 1.0f, 1.0f);
            return false;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer playerMp = (ServerPlayer)player;
            playerMp.disconnect();
            playerMp.teleportTo((double)pos.getX() + 0.5, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5);
        }
        AreaParticleCloudEntity particleCloud = new AreaParticleCloudEntity((EntityType)ModEntities.PARTICLE_CLOUD.get(), player.getCommandSenderWorld());
        particleCloud.setPos(ox, oy, oz);
        particleCloud.setRadius(0.7f);
        particleCloud.setHeight(player.getBbHeight());
        particleCloud.setDuration(5);
        particleCloud.setSpawnRate(15.0f);
        player.getCommandSenderWorld().addFreshEntity((Entity)particleCloud);
        player.getCommandSenderWorld().playLocalSound(ox, oy, oz, SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f, false);
        player.getCommandSenderWorld().playLocalSound(player.getX(), player.getY(), player.getZ(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f, false);
        return true;
    }

    public boolean canBeUsedBy(@NotNull IHunterPlayer hunter) {
        IHunterSpecialAttributes atts = (IHunterSpecialAttributes)((HunterPlayer)hunter).getSpecialAttributes();
        boolean isBat = atts.ageing$getBatMode();
        return CapabilityHelper.getCumulativeTaintedAge(hunter.asEntity()) >= (Integer)HunterAgeingConfig.hunterTeleportActionAge.get() && !isBat;
    }

    public int getCooldown(@NotNull IHunterPlayer player) {
        return (Integer)HunterAgeingConfig.hunterTeleportActionCooldown.get() * 20;
    }

    public boolean isEnabled() {
        return (Boolean)HunterAgeingConfig.hunterTeleportAction.get();
    }
}

