/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.vampiricageing;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import com.thedrofdoctoring.vampiricageing.AgeingReference;
import com.thedrofdoctoring.vampiricageing.actions.VampiricAgeingActions;
import com.thedrofdoctoring.vampiricageing.capabilities.AgeingManager;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.AgeingRegistry;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.methods.BitingMethod;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.methods.DevourMethod;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.methods.DrinkBloodMethod;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.methods.HunterHuntingMethod;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.methods.TimeMethod;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.methods.VampHuntingMethod;
import com.thedrofdoctoring.vampiricageing.capabilities.handlers.WerewolfAgeingHandler;
import com.thedrofdoctoring.vampiricageing.client.init.ClientRegistryHandler;
import com.thedrofdoctoring.vampiricageing.command.VampiricAgeingCommands;
import com.thedrofdoctoring.vampiricageing.config.ClientConfig;
import com.thedrofdoctoring.vampiricageing.config.CommonConfig;
import com.thedrofdoctoring.vampiricageing.config.HunterAgeingConfig;
import com.thedrofdoctoring.vampiricageing.config.WerewolvesAgeingConfig;
import com.thedrofdoctoring.vampiricageing.data.AgeingBlockTagsProvider;
import com.thedrofdoctoring.vampiricageing.data.AgeingDataComponents;
import com.thedrofdoctoring.vampiricageing.data.EntityTypeTagProvider;
import com.thedrofdoctoring.vampiricageing.data.ItemTagProvider;
import com.thedrofdoctoring.vampiricageing.init.ModAttachments;
import com.thedrofdoctoring.vampiricageing.init.ModEffects;
import com.thedrofdoctoring.vampiricageing.init.ModItems;
import com.thedrofdoctoring.vampiricageing.init.ModOils;
import com.thedrofdoctoring.vampiricageing.skills.VampiricAgeingSkills;
import de.teamlapen.lib.HelperRegistry;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Mod(value="vampiricageing")
public class VampiricAgeing {
    public static final String MODID = "vampiricageing";
    public static final String WEREWOLVES_MODID = "werewolves";
    public static final Logger LOGGER = LogUtils.getLogger();
    private final IEventBus modBus;

    public VampiricAgeing(IEventBus modEventBus, ModContainer container) {
        modEventBus.addListener(this::gatherData);
        modEventBus.addListener(this::enqueueIMC);
        this.modBus = modEventBus;
        if (FMLEnvironment.dist == Dist.CLIENT) {
            container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
            ClientRegistryHandler.init(modEventBus);
        }
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.COMMON_CONFIG);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.CLIENT_CONFIG);
        VampiricAgeingActions.register(modEventBus);
        VampiricAgeingSkills.register(modEventBus);
        ModItems.register(modEventBus);
        ModAttachments.ATTACHMENT_TYPES.register(modEventBus);
        ModEffects.EFFECTS.register(modEventBus);
        ModOils.OILS.register(modEventBus);
        AgeingDataComponents.COMPONENTS.register(modEventBus);
        AgeingRegistry.registerAgeType(AgeingReference.VAMP);
        AgeingRegistry.registerAgeType(AgeingReference.HUNTER);
        AgeingRegistry.registerAgeMethod(new BitingMethod());
        AgeingRegistry.registerAgeMethod(new TimeMethod());
        AgeingRegistry.registerAgeMethod(new VampHuntingMethod());
        AgeingRegistry.registerAgeMethod(new HunterHuntingMethod());
        AgeingRegistry.registerAgeMethod(new DrinkBloodMethod());
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)HunterAgeingConfig.HUNTER_AGEING_CONFIG, "vampiricageing-hunterAgeing.toml");
        if (ModList.get().isLoaded(WEREWOLVES_MODID)) {
            AgeingRegistry.registerAgeType(AgeingReference.WEREWOLF);
            AgeingRegistry.registerAgeMethod(new DevourMethod());
            container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)WerewolvesAgeingConfig.WEREWOLF_AGEING_CONFIG, "vampiricageing-werewolfAgeing.toml");
            NeoForge.EVENT_BUS.register((Object)new WerewolfAgeingHandler());
        }
        NeoForge.EVENT_BUS.addListener(this::onCommandsRegister);
    }

    public void onCommandsRegister(@NotNull RegisterCommandsEvent event) {
        VampiricAgeingCommands.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        EntityTypeTagProvider entityTypeTagProvider = new EntityTypeTagProvider(packOutput, lookupProvider, existingFileHelper);
        AgeingBlockTagsProvider provider = new AgeingBlockTagsProvider(packOutput, lookupProvider, existingFileHelper);
        ItemTagProvider itemTagProvider = new ItemTagProvider(packOutput, lookupProvider, (TagsProvider<Block>)provider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)provider);
        generator.addProvider(event.includeServer(), (DataProvider)itemTagProvider);
        generator.addProvider(event.includeServer(), (DataProvider)entityTypeTagProvider);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        HelperRegistry.registerSyncablePlayerCapability((AttachmentType)((AttachmentType)ModAttachments.AGEING_MANAGER.get()), AgeingManager.class);
        HelperRegistry.registerSyncableEntityCapability((AttachmentType)((AttachmentType)ModAttachments.AGEING_MANAGER.get()), AgeingManager.class);
    }

    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }
}

