/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.alchemistarsenal.networking;

import github.nitespring.alchemistarsenal.common.item.equipment.SteampunkChestplateItem;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ShootRocketAction() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ShootRocketAction> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"alkhars", (String)"shoot"));
    public static final ShootRocketAction INSTANCE = new ShootRocketAction();
    public static final StreamCodec<ByteBuf, ShootRocketAction> STREAM_CODEC = StreamCodec.unit((Object)INSTANCE);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public class ServerPayloadHandler {
        public ServerPayloadHandler(ShootRocketAction this$0) {
        }

        public static void handleData(ShootRocketAction data, IPayloadContext ctx) {
            ctx.enqueueWork(() -> {
                Player player = ctx.player();
                if (player == null) {
                    return;
                }
                ItemStack itemstack = player.getItemBySlot(EquipmentSlot.CHEST);
                Item patt0$temp = itemstack.getItem();
                if (patt0$temp instanceof SteampunkChestplateItem) {
                    SteampunkChestplateItem wings = (SteampunkChestplateItem)patt0$temp;
                    wings.shoot(player, itemstack);
                }
            }).exceptionally(e -> {
                ctx.disconnect((Component)Component.translatable((String)"alkhars.networking.failed", (Object[])new Object[]{e.getMessage()}));
                return null;
            });
        }
    }
}

