/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.alchemistarsenal.core.init;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ArmorMaterialInit {
    public static final DeferredRegister<ArmorMaterial> MATERIALS = DeferredRegister.create((Registry)BuiltInRegistries.ARMOR_MATERIAL, (String)"alkhars");
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> TURTLE_MASTER = ArmorMaterialInit.register("turtle_master", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), p_323381_ -> {
        p_323381_.put(ArmorItem.Type.BOOTS, 4);
        p_323381_.put(ArmorItem.Type.LEGGINGS, 8);
        p_323381_.put(ArmorItem.Type.CHESTPLATE, 12);
        p_323381_.put(ArmorItem.Type.HELMET, 6);
        p_323381_.put(ArmorItem.Type.BODY, 13);
    }), 5, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_TURTLE, 5.0f, 0.5f, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> STEAMPUNK = ArmorMaterialInit.register("steampunk", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), p_323381_ -> {
        p_323381_.put(ArmorItem.Type.BOOTS, 3);
        p_323381_.put(ArmorItem.Type.LEGGINGS, 6);
        p_323381_.put(ArmorItem.Type.CHESTPLATE, 8);
        p_323381_.put(ArmorItem.Type.HELMET, 3);
        p_323381_.put(ArmorItem.Type.BODY, 11);
    }), 14, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, 3.0f, 0.1f, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}));

    private static DeferredHolder<ArmorMaterial, ArmorMaterial> register(String pName, EnumMap<ArmorItem.Type, Integer> pDefense, int pEnchantmentValue, Holder<SoundEvent> pEquipSound, float pToughness, float pKnockbackResistance, Supplier<Ingredient> pRepairIngredient) {
        List<ArmorMaterial.Layer> list = List.of(new ArmorMaterial.Layer(ResourceLocation.withDefaultNamespace((String)pName)));
        return ArmorMaterialInit.register(pName, pDefense, pEnchantmentValue, pEquipSound, pToughness, pKnockbackResistance, pRepairIngredient, list);
    }

    private static DeferredHolder<ArmorMaterial, ArmorMaterial> register(String pName, EnumMap<ArmorItem.Type, Integer> pDefense, int pEnchantmentValue, Holder<SoundEvent> pEquipSound, float pToughness, float pKnockbackResistance, Supplier<Ingredient> pRepairIngridient, List<ArmorMaterial.Layer> pLayers) {
        EnumMap<ArmorItem.Type, Integer> enummap = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        for (ArmorItem.Type armoritem$type : ArmorItem.Type.values()) {
            enummap.put(armoritem$type, pDefense.get(armoritem$type));
        }
        return MATERIALS.register(pName, () -> new ArmorMaterial((Map)enummap, pEnchantmentValue, pEquipSound, pRepairIngridient, pLayers, pToughness, pKnockbackResistance));
    }
}

