/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.alchemistarsenal.core.events;

import github.nitespring.alchemistarsenal.client.render.equipment.SteampunkSuitModel;
import github.nitespring.alchemistarsenal.client.render.equipment.SteampunkWingsLayer;
import github.nitespring.alchemistarsenal.client.render.equipment.SteampunkWingsModel;
import github.nitespring.alchemistarsenal.client.render.equipment.TurtleMasterArmourModel;
import github.nitespring.alchemistarsenal.client.render.projectile.AmethystArrowRenderer;
import github.nitespring.alchemistarsenal.client.render.projectile.BouncyArrowRenderer;
import github.nitespring.alchemistarsenal.client.render.projectile.DragonArrowRenderer;
import github.nitespring.alchemistarsenal.client.render.projectile.ExplosiveArrowRenderer;
import github.nitespring.alchemistarsenal.client.render.projectile.InfernalArrowRenderer;
import github.nitespring.alchemistarsenal.client.render.projectile.LightningArrowRenderer;
import github.nitespring.alchemistarsenal.client.render.projectile.ShrapnelRenderer;
import github.nitespring.alchemistarsenal.client.render.projectile.SquareTextureEntityModel;
import github.nitespring.alchemistarsenal.client.render.projectile.WindArrowRenderer;
import github.nitespring.alchemistarsenal.common.item.weapons.AutomaticCrossbow;
import github.nitespring.alchemistarsenal.common.item.weapons.RepeatingCrossbow;
import github.nitespring.alchemistarsenal.core.ClientItemExtensions;
import github.nitespring.alchemistarsenal.core.init.DataComponentInit;
import github.nitespring.alchemistarsenal.core.init.EntityInit;
import github.nitespring.alchemistarsenal.core.init.ItemInit;
import java.util.HashMap;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.FireworkEntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;

@EventBusSubscriber(modid="alkhars", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientListener {
    public static final ModelLayerLocation SQUARE_TEXTURE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"alkhars", (String)"square_texture"), "main");
    private static final HashMap<RenderLayer<?, ?>, LivingEntityRenderer> mappedfashion = new HashMap();

    @SubscribeEvent
    public static void addLayers(EntityRenderersEvent.AddLayers event) {
        mappedfashion.clear();
        event.getEntityTypes().forEach(entityTypeName -> {
            EntityRenderer patt0$temp = event.getRenderer(entityTypeName);
            if (patt0$temp instanceof LivingEntityRenderer) {
                LivingEntityRenderer renderer = (LivingEntityRenderer)patt0$temp;
                renderer.addLayer(new SteampunkWingsLayer((RenderLayerParent)renderer, event.getEntityModels()));
                mappedfashion.put((RenderLayer<?, ?>)new SteampunkWingsLayer((RenderLayerParent)renderer, event.getEntityModels()), renderer);
            }
        });
        event.getSkins().forEach(skinTypeName -> {
            if (event.getSkin(skinTypeName) instanceof PlayerRenderer) {
                PlayerRenderer renderer = (PlayerRenderer)event.getSkin(skinTypeName);
                renderer.addLayer(new SteampunkWingsLayer((RenderLayerParent)renderer, event.getEntityModels()));
                mappedfashion.put((RenderLayer<?, ?>)new SteampunkWingsLayer((RenderLayerParent)renderer, event.getEntityModels()), (LivingEntityRenderer)renderer);
            }
        });
    }

    public static HashMap<RenderLayer<?, ?>, LivingEntityRenderer> getMappedfashion() {
        return mappedfashion;
    }

    @SubscribeEvent
    public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(SQUARE_TEXTURE, SquareTextureEntityModel::createBodyLayer);
        event.registerLayerDefinition(SteampunkWingsModel.LAYER_LOCATION, SteampunkWingsModel::createBodyLayer);
        event.registerLayerDefinition(SteampunkSuitModel.LAYER_LOCATION, SteampunkSuitModel::createBodyLayer);
        event.registerLayerDefinition(TurtleMasterArmourModel.LAYER_LOCATION, TurtleMasterArmourModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)EntityInit.INFERNAL_ARROW.get(), InfernalArrowRenderer::new);
        event.registerEntityRenderer((EntityType)EntityInit.BOUNCY_ARROW.get(), BouncyArrowRenderer::new);
        event.registerEntityRenderer((EntityType)EntityInit.DRAGON_ARROW.get(), DragonArrowRenderer::new);
        event.registerEntityRenderer((EntityType)EntityInit.LIGHTNING_ARROW.get(), LightningArrowRenderer::new);
        event.registerEntityRenderer((EntityType)EntityInit.EXPLOSIVE_ARROW.get(), ExplosiveArrowRenderer::new);
        event.registerEntityRenderer((EntityType)EntityInit.AMETHYST_ARROW.get(), AmethystArrowRenderer::new);
        event.registerEntityRenderer((EntityType)EntityInit.WIND_ARROW.get(), WindArrowRenderer::new);
        event.registerEntityRenderer((EntityType)EntityInit.FIRE_BOTTLE.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)EntityInit.EXPLOSIVE_BOTTLE.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)EntityInit.SHRAPNEL.get(), ShrapnelRenderer::new);
        event.registerEntityRenderer((EntityType)EntityInit.ELYTRA_BOOSTER.get(), FireworkEntityRenderer::new);
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)ItemInit.AUTOMATIC_CROSSBOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pull"), (stack, level, player, seed) -> {
                if (player == null) {
                    return 0.0f;
                }
                return AutomaticCrossbow.isCharged(stack) ? 0.0f : (float)(stack.getUseDuration(player) - player.getUseItemRemainingTicks()) / (float)AutomaticCrossbow.getChargeDuration(stack, player);
            });
            ItemProperties.register((Item)((Item)ItemInit.AUTOMATIC_CROSSBOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pulling"), (stack, level, player, seed) -> player != null && player.isUsingItem() && player.getUseItem() == stack && !AutomaticCrossbow.isCharged(stack) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ItemInit.AUTOMATIC_CROSSBOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"charged"), (stack, level, player, seed) -> AutomaticCrossbow.isCharged(stack) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ItemInit.CROSSBOW_SCYTHE.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pull"), (stack, level, player, seed) -> {
                if (player == null) {
                    return 0.0f;
                }
                return CrossbowItem.isCharged((ItemStack)stack) ? 0.0f : (float)(stack.getUseDuration(player) - player.getUseItemRemainingTicks()) / (float)CrossbowItem.getChargeDuration((ItemStack)stack, (LivingEntity)player);
            });
            ItemProperties.register((Item)((Item)ItemInit.CROSSBOW_SCYTHE.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pulling"), (stack, level, player, seed) -> player != null && player.isUsingItem() && player.getUseItem() == stack && !CrossbowItem.isCharged((ItemStack)stack) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ItemInit.CROSSBOW_SCYTHE.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"charged"), (stack, level, player, seed) -> CrossbowItem.isCharged((ItemStack)stack) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ItemInit.CROSSBOW_SCYTHE.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"firework"), (stack, level, player, seed) -> {
                ChargedProjectiles chargedprojectiles = (ChargedProjectiles)stack.get(DataComponents.CHARGED_PROJECTILES);
                return chargedprojectiles != null && chargedprojectiles.contains(Items.FIREWORK_ROCKET) ? 1.0f : 0.0f;
            });
            ItemProperties.register((Item)((Item)ItemInit.REPEATING_CROSSBOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pull"), (stack, level, player, seed) -> {
                if (player == null) {
                    return 0.0f;
                }
                return CrossbowItem.isCharged((ItemStack)stack) ? 0.0f : (float)(stack.getUseDuration(player) - player.getUseItemRemainingTicks()) / (float)RepeatingCrossbow.getChargeDuration((ItemStack)stack, (LivingEntity)player);
            });
            ItemProperties.register((Item)((Item)ItemInit.REPEATING_CROSSBOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pulling"), (stack, level, player, seed) -> player != null && player.isUsingItem() && player.getUseItem() == stack && !RepeatingCrossbow.isCharged(stack) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ItemInit.REPEATING_CROSSBOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"charged"), (stack, level, player, seed) -> RepeatingCrossbow.isCharged(stack) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ItemInit.REPEATING_CROSSBOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"firework"), (stack, level, player, seed) -> {
                ChargedProjectiles chargedprojectiles = (ChargedProjectiles)stack.get(DataComponents.CHARGED_PROJECTILES);
                return chargedprojectiles != null && chargedprojectiles.contains(Items.FIREWORK_ROCKET) ? 1.0f : 0.0f;
            });
            ItemProperties.register((Item)((Item)ItemInit.REPEATING_CROSSBOW.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"alkhars", (String)"amount"), (stack, level, player, seed) -> {
                ChargedProjectiles chargedprojectiles1 = (ChargedProjectiles)stack.get(DataComponents.CHARGED_PROJECTILES);
                ChargedProjectiles chargedprojectiles2 = (ChargedProjectiles)stack.get(DataComponentInit.CHARGED_PROJECTILES2);
                ChargedProjectiles chargedprojectiles3 = (ChargedProjectiles)stack.get(DataComponentInit.CHARGED_PROJECTILES3);
                return chargedprojectiles3 != null && !chargedprojectiles3.isEmpty() ? 3.0f : (chargedprojectiles2 != null && !chargedprojectiles2.isEmpty() ? 2.0f : (chargedprojectiles1 != null && !chargedprojectiles1.isEmpty() ? 1.0f : 0.0f));
            });
        });
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(ClientItemExtensions.STEAMPUNK_ARMOUR_CLIENT_EXTENSIONS, new Holder[]{ItemInit.STEAMPUNK_HELMET});
        event.registerItem(ClientItemExtensions.STEAMPUNK_ARMOUR_CLIENT_EXTENSIONS, new Holder[]{ItemInit.STEAMPUNK_CHESTPLATE});
        event.registerItem(ClientItemExtensions.STEAMPUNK_ARMOUR_CLIENT_EXTENSIONS, new Holder[]{ItemInit.STEAMPUNK_LEGGINGS});
        event.registerItem(ClientItemExtensions.STEAMPUNK_ARMOUR_CLIENT_EXTENSIONS, new Holder[]{ItemInit.STEAMPUNK_BOOTS});
        event.registerItem(ClientItemExtensions.TURTLE_ARMOUR_CLIENT_EXTENSIONS, new Holder[]{ItemInit.TURTLE_MASTER_HELMET});
        event.registerItem(ClientItemExtensions.TURTLE_ARMOUR_CLIENT_EXTENSIONS, new Holder[]{ItemInit.TURTLE_MASTER_CHESTPLATE});
        event.registerItem(ClientItemExtensions.TURTLE_ARMOUR_CLIENT_EXTENSIONS, new Holder[]{ItemInit.TURTLE_MASTER_LEGGINGS});
        event.registerItem(ClientItemExtensions.TURTLE_ARMOUR_CLIENT_EXTENSIONS, new Holder[]{ItemInit.TURTLE_MASTER_BOOTS});
    }
}

