/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.alchemistarsenal.common.item.weapons;

import com.google.common.collect.Lists;
import github.nitespring.alchemistarsenal.core.init.DataComponentInit;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;

public class RepeatingCrossbow
extends CrossbowItem {
    public static final Predicate<ItemStack> FIREWORK_ONLY = p_43017_ -> p_43017_.is(Items.FIREWORK_ROCKET);

    public RepeatingCrossbow(Item.Properties pProperties) {
        super(pProperties.component(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY).component(DataComponentInit.CHARGED_PROJECTILES2, (Object)ChargedProjectiles.EMPTY).component(DataComponentInit.CHARGED_PROJECTILES3, (Object)ChargedProjectiles.EMPTY));
    }

    public boolean isValidRepairItem(ItemStack pToRepair, ItemStack pRepair) {
        return Tiers.DIAMOND.getRepairIngredient().test(pRepair);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return Tiers.DIAMOND.getEnchantmentValue();
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        ChargedProjectiles chargedprojectiles = (ChargedProjectiles)itemstack.get(DataComponents.CHARGED_PROJECTILES);
        if (chargedprojectiles != null && !chargedprojectiles.isEmpty()) {
            ItemStack projectile = (ItemStack)chargedprojectiles.getItems().getLast();
            this.performShooting(pLevel, (LivingEntity)pPlayer, pHand, itemstack, RepeatingCrossbow.getShootingPower(projectile), 1.0f, null);
            pPlayer.getCooldowns().addCooldown(itemstack.getItem(), 4);
            return InteractionResultHolder.consume((Object)itemstack);
        }
        if (!pPlayer.getProjectile(itemstack).isEmpty()) {
            pPlayer.startUsingItem(pHand);
            return InteractionResultHolder.consume((Object)itemstack);
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }

    private static float getShootingPower(ItemStack projectile) {
        return projectile.is(Items.FIREWORK_ROCKET) ? 1.6f : 3.15f;
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeLeft) {
        int i = this.getUseDuration(stack, livingEntity) - timeLeft;
        float f = RepeatingCrossbow.getPowerForTime(i, stack, livingEntity);
        if (f >= 1.0f && !RepeatingCrossbow.isCharged(stack) && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ItemStack ammo1 = player.getProjectile(stack);
            if (player.isCreative()) {
                stack.set(DataComponentInit.CHARGED_PROJECTILES2, (Object)ChargedProjectiles.of((ItemStack)ammo1));
                stack.set(DataComponentInit.CHARGED_PROJECTILES3, (Object)ChargedProjectiles.of((ItemStack)ammo1));
            }
            if (ammo1 != ItemStack.EMPTY) {
                stack.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.of((ItemStack)ammo1));
                if (ammo1.is(Items.FIREWORK_ROCKET)) {
                    ItemStack ammo2;
                    if (!player.isCreative()) {
                        RepeatingCrossbow.useAmmo((ItemStack)stack, (ItemStack)ammo1, (LivingEntity)livingEntity, (boolean)false);
                    }
                    if ((ammo2 = player.getItemBySlot(EquipmentSlot.OFFHAND)) != ItemStack.EMPTY) {
                        ItemStack ammo3;
                        if (ammo2.is(Items.FIREWORK_ROCKET)) {
                            stack.set(DataComponentInit.CHARGED_PROJECTILES2, (Object)ChargedProjectiles.of((ItemStack)ammo2));
                            if (!player.isCreative()) {
                                RepeatingCrossbow.useAmmo((ItemStack)stack, (ItemStack)ammo2, (LivingEntity)livingEntity, (boolean)false);
                            }
                        }
                        if ((ammo3 = player.getItemBySlot(EquipmentSlot.OFFHAND)) != ItemStack.EMPTY && ammo3.is(Items.FIREWORK_ROCKET)) {
                            stack.set(DataComponentInit.CHARGED_PROJECTILES3, (Object)ChargedProjectiles.of((ItemStack)ammo3));
                            if (!player.isCreative()) {
                                RepeatingCrossbow.useAmmo((ItemStack)stack, (ItemStack)ammo3, (LivingEntity)livingEntity, (boolean)false);
                            }
                        }
                    }
                } else {
                    if (!player.isCreative()) {
                        RepeatingCrossbow.useAmmo((ItemStack)stack, (ItemStack)ammo1, (LivingEntity)livingEntity, (boolean)false);
                    }
                    ItemStack ammo2 = ItemStack.EMPTY;
                    for (int j = 0; ammo2 == ItemStack.EMPTY && j < player.getInventory().getContainerSize(); ++j) {
                        ItemStack itemstack1 = player.getInventory().getItem(j);
                        if (!itemstack1.is(ItemTags.ARROWS)) continue;
                        ammo2 = itemstack1;
                        stack.set(DataComponentInit.CHARGED_PROJECTILES2, (Object)ChargedProjectiles.of((ItemStack)ammo2));
                        if (player.isCreative()) continue;
                        RepeatingCrossbow.useAmmo((ItemStack)stack, (ItemStack)itemstack1, (LivingEntity)livingEntity, (boolean)false);
                    }
                    ItemStack ammo3 = ItemStack.EMPTY;
                    for (int k = 0; ammo3 == ItemStack.EMPTY && k < player.getInventory().getContainerSize(); ++k) {
                        ItemStack itemstack1 = player.getInventory().getItem(k);
                        if (!itemstack1.is(ItemTags.ARROWS)) continue;
                        ammo3 = itemstack1;
                        stack.set(DataComponentInit.CHARGED_PROJECTILES3, (Object)ChargedProjectiles.of((ItemStack)ammo3));
                        if (player.isCreative()) continue;
                        RepeatingCrossbow.useAmmo((ItemStack)stack, (ItemStack)itemstack1, (LivingEntity)livingEntity, (boolean)false);
                    }
                }
            } else if (player.getAbilities().instabuild) {
                stack.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.of((ItemStack)this.getDefaultCreativeAmmo(player, stack)));
                stack.set(DataComponentInit.CHARGED_PROJECTILES2, (Object)ChargedProjectiles.of((ItemStack)this.getDefaultCreativeAmmo(player, stack)));
                stack.set(DataComponentInit.CHARGED_PROJECTILES3, (Object)ChargedProjectiles.of((ItemStack)this.getDefaultCreativeAmmo(player, stack)));
            }
        }
    }

    public static boolean isCharged(ItemStack pCrossbowStack) {
        ChargedProjectiles chargedprojectiles1 = (ChargedProjectiles)pCrossbowStack.get(DataComponents.CHARGED_PROJECTILES);
        ChargedProjectiles chargedprojectiles2 = (ChargedProjectiles)pCrossbowStack.get(DataComponentInit.CHARGED_PROJECTILES2);
        ChargedProjectiles chargedprojectiles3 = (ChargedProjectiles)pCrossbowStack.get(DataComponentInit.CHARGED_PROJECTILES3);
        return !chargedprojectiles1.isEmpty();
    }

    private static float getPowerForTime(int pTimeLeft, ItemStack pStack, LivingEntity pShooter) {
        float f = (float)pTimeLeft / (float)RepeatingCrossbow.getChargeDuration((ItemStack)pStack, (LivingEntity)pShooter);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public void performShooting(Level pLevel, LivingEntity pShooter, InteractionHand pHand, ItemStack pWeapon, float pVelocity, float pInaccuracy, @javax.annotation.Nullable LivingEntity pTarget) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)pLevel;
            if (pShooter instanceof Player) {
                Player player = (Player)pShooter;
                if (EventHooks.onArrowLoose((ItemStack)pWeapon, (Level)pShooter.level(), (Player)player, (int)1, (boolean)true) < 0) {
                    return;
                }
            }
            ChargedProjectiles chargedprojectiles1 = (ChargedProjectiles)pWeapon.get(DataComponents.CHARGED_PROJECTILES);
            ChargedProjectiles chargedprojectiles2 = (ChargedProjectiles)pWeapon.get(DataComponentInit.CHARGED_PROJECTILES2);
            ChargedProjectiles chargedprojectiles3 = (ChargedProjectiles)pWeapon.get(DataComponentInit.CHARGED_PROJECTILES3);
            if (chargedprojectiles3 != null && !chargedprojectiles3.isEmpty()) {
                this.shoot(serverlevel, pShooter, pHand, pWeapon, chargedprojectiles3.getItems(), pVelocity, pInaccuracy, pShooter instanceof Player, pTarget);
                pWeapon.set(DataComponentInit.CHARGED_PROJECTILES3, (Object)ChargedProjectiles.EMPTY);
                if (pShooter instanceof ServerPlayer) {
                    ServerPlayer serverplayer = (ServerPlayer)pShooter;
                    CriteriaTriggers.SHOT_CROSSBOW.trigger(serverplayer, pWeapon);
                    serverplayer.awardStat(Stats.ITEM_USED.get((Object)pWeapon.getItem()));
                }
            } else if (chargedprojectiles2 != null && !chargedprojectiles2.isEmpty()) {
                this.shoot(serverlevel, pShooter, pHand, pWeapon, chargedprojectiles2.getItems(), pVelocity, pInaccuracy, pShooter instanceof Player, pTarget);
                pWeapon.set(DataComponentInit.CHARGED_PROJECTILES2, (Object)ChargedProjectiles.EMPTY);
                if (pShooter instanceof ServerPlayer) {
                    ServerPlayer serverplayer = (ServerPlayer)pShooter;
                    CriteriaTriggers.SHOT_CROSSBOW.trigger(serverplayer, pWeapon);
                    serverplayer.awardStat(Stats.ITEM_USED.get((Object)pWeapon.getItem()));
                }
            } else if (chargedprojectiles1 != null && !chargedprojectiles1.isEmpty()) {
                this.shoot(serverlevel, pShooter, pHand, pWeapon, chargedprojectiles1.getItems(), pVelocity, pInaccuracy, pShooter instanceof Player, pTarget);
                pWeapon.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY);
                if (pShooter instanceof ServerPlayer) {
                    ServerPlayer serverplayer = (ServerPlayer)pShooter;
                    CriteriaTriggers.SHOT_CROSSBOW.trigger(serverplayer, pWeapon);
                    serverplayer.awardStat(Stats.ITEM_USED.get((Object)pWeapon.getItem()));
                }
            }
        }
    }

    protected void shoot(ServerLevel pLevel, LivingEntity pShooter, InteractionHand pHand, ItemStack pWeapon, List<ItemStack> pProjectileItems, float pVelocity, float pInaccuracy, boolean pIsCrit, @Nullable LivingEntity pTarget) {
        float f = EnchantmentHelper.processProjectileSpread((ServerLevel)pLevel, (ItemStack)pWeapon, (Entity)pShooter, (float)0.0f);
        int multiShot = pWeapon.getEnchantmentLevel((Holder)((Registry)pShooter.level().registryAccess().registry(Registries.ENCHANTMENT).get()).getHolder(Enchantments.MULTISHOT).get());
        int amount = 1 + 2 * multiShot;
        if (multiShot >= 1) {
            for (int i = -multiShot; i <= multiShot; ++i) {
                ItemStack itemstack = pProjectileItems.get(0);
                if (itemstack.isEmpty()) continue;
                float f4 = 1.0471976f / (float)multiShot * (float)i * 12.0f;
                Projectile projectile = this.createProjectile((Level)pLevel, pShooter, pWeapon, itemstack, pIsCrit);
                this.shootProjectile(pShooter, projectile, i, pVelocity, pInaccuracy, f4, pTarget);
                pLevel.addFreshEntity((Entity)projectile);
                pWeapon.hurtAndBreak(this.getDurabilityUse(itemstack), pShooter, LivingEntity.getSlotForHand((InteractionHand)pHand));
                if (!pWeapon.isEmpty()) {
                    continue;
                }
                break;
            }
        } else {
            float f1 = pProjectileItems.size() == 1 ? 0.0f : 2.0f * f / (float)(pProjectileItems.size() - 1);
            float f2 = (float)((pProjectileItems.size() - 1) % 2) * f1 / 2.0f;
            float f3 = 1.0f;
            for (int i = 0; i < pProjectileItems.size(); ++i) {
                ItemStack itemstack = pProjectileItems.get(i);
                if (itemstack.isEmpty()) continue;
                float f4 = f2 + f3 * (float)((i + 1) / 2) * f1;
                f3 = -f3;
                Projectile projectile = this.createProjectile((Level)pLevel, pShooter, pWeapon, itemstack, pIsCrit);
                this.shootProjectile(pShooter, projectile, i, pVelocity, pInaccuracy, f4, pTarget);
                pLevel.addFreshEntity((Entity)projectile);
                pWeapon.hurtAndBreak(this.getDurabilityUse(itemstack), pShooter, LivingEntity.getSlotForHand((InteractionHand)pHand));
                if (!pWeapon.isEmpty()) {
                    continue;
                }
                break;
            }
        }
    }

    public Predicate<ItemStack> getSupportedHeldProjectiles() {
        return ARROW_OR_FIREWORK;
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return ARROW_ONLY;
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        int i;
        ArrayList list;
        ItemStack itemstack;
        ChargedProjectiles chargedprojectiles1 = (ChargedProjectiles)pStack.get(DataComponents.CHARGED_PROJECTILES);
        ChargedProjectiles chargedprojectiles2 = (ChargedProjectiles)pStack.get(DataComponentInit.CHARGED_PROJECTILES2);
        ChargedProjectiles chargedprojectiles3 = (ChargedProjectiles)pStack.get(DataComponentInit.CHARGED_PROJECTILES3);
        if (chargedprojectiles1 != null && !chargedprojectiles1.isEmpty()) {
            itemstack = (ItemStack)chargedprojectiles1.getItems().get(0);
            pTooltipComponents.add((Component)Component.translatable((String)"item.minecraft.crossbow.projectile").append(CommonComponents.SPACE).append(itemstack.getDisplayName()));
            if (pTooltipFlag.isAdvanced() && itemstack.is(Items.FIREWORK_ROCKET)) {
                list = Lists.newArrayList();
                Items.FIREWORK_ROCKET.appendHoverText(itemstack, pContext, (List)list, pTooltipFlag);
                if (!list.isEmpty()) {
                    for (i = 0; i < list.size(); ++i) {
                        list.set(i, Component.literal((String)"  ").append((Component)list.get(i)).withStyle(ChatFormatting.GRAY));
                    }
                    pTooltipComponents.addAll(list);
                }
            }
        }
        if (chargedprojectiles2 != null && !chargedprojectiles2.isEmpty()) {
            itemstack = (ItemStack)chargedprojectiles2.getItems().get(0);
            pTooltipComponents.add((Component)Component.translatable((String)"item.minecraft.crossbow.projectile").append(CommonComponents.SPACE).append(itemstack.getDisplayName()));
            if (pTooltipFlag.isAdvanced() && itemstack.is(Items.FIREWORK_ROCKET)) {
                list = Lists.newArrayList();
                Items.FIREWORK_ROCKET.appendHoverText(itemstack, pContext, (List)list, pTooltipFlag);
                if (!list.isEmpty()) {
                    for (i = 0; i < list.size(); ++i) {
                        list.set(i, Component.literal((String)"  ").append((Component)list.get(i)).withStyle(ChatFormatting.GRAY));
                    }
                    pTooltipComponents.addAll(list);
                }
            }
        }
        if (chargedprojectiles3 != null && !chargedprojectiles3.isEmpty()) {
            itemstack = (ItemStack)chargedprojectiles3.getItems().get(0);
            pTooltipComponents.add((Component)Component.translatable((String)"item.minecraft.crossbow.projectile").append(CommonComponents.SPACE).append(itemstack.getDisplayName()));
            if (pTooltipFlag.isAdvanced() && itemstack.is(Items.FIREWORK_ROCKET)) {
                list = Lists.newArrayList();
                Items.FIREWORK_ROCKET.appendHoverText(itemstack, pContext, (List)list, pTooltipFlag);
                if (!list.isEmpty()) {
                    for (i = 0; i < list.size(); ++i) {
                        list.set(i, Component.literal((String)"  ").append((Component)list.get(i)).withStyle(ChatFormatting.GRAY));
                    }
                    pTooltipComponents.addAll(list);
                }
            }
        }
    }
}

