/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.alchemistarsenal.common.item.weapons;

import github.nitespring.alchemistarsenal.core.init.DataComponentInit;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class AutomaticCrossbow
extends ProjectileWeaponItem {
    public AutomaticCrossbow(Item.Properties pProperties) {
        super(pProperties.component(DataComponentInit.CHARGE, (Object)0));
    }

    public Predicate<ItemStack> getSupportedHeldProjectiles() {
        return ARROW_OR_FIREWORK;
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return ARROW_ONLY;
    }

    public int getDefaultProjectileRange() {
        return 0;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (AutomaticCrossbow.isCharged(stack)) {
            if (player.isCreative() || !player.getProjectile(stack).isEmpty()) {
                this.performShooting(level, (LivingEntity)player, hand, stack, AutomaticCrossbow.getShootingPower(player.getProjectile(stack)), 1.0f, null);
                player.getCooldowns().addCooldown(stack.getItem(), 4);
                this.decreaseCharge(stack);
                AutomaticCrossbow.useAmmo((ItemStack)stack, (ItemStack)player.getProjectile(stack), (LivingEntity)player, (boolean)false);
                if (AutomaticCrossbow.isCharged(stack)) {
                    player.level().playSound((Player)null, (Entity)player, (SoundEvent)SoundEvents.CROSSBOW_LOADING_END.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                player.level().playSound((Player)null, (Entity)player, SoundEvents.LEVER_CLICK, SoundSource.PLAYERS, 0.8f, 1.2f);
                return InteractionResultHolder.consume((Object)stack);
            }
            return InteractionResultHolder.fail((Object)stack);
        }
        player.startUsingItem(hand);
        player.level().playSound((Player)null, (Entity)player, (SoundEvent)SoundEvents.CROSSBOW_LOADING_START.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
        return InteractionResultHolder.pass((Object)stack);
    }

    public boolean isValidRepairItem(ItemStack pToRepair, ItemStack pRepair) {
        return Tiers.NETHERITE.getRepairIngredient().test(pRepair);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 12;
    }

    public void performShooting(Level pLevel, LivingEntity shooter, InteractionHand pHand, ItemStack weapon, float pVelocity, float pInaccuracy, @javax.annotation.Nullable LivingEntity pTarget) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)pLevel;
            if (shooter instanceof Player) {
                Player player = (Player)shooter;
                if (EventHooks.onArrowLoose((ItemStack)weapon, (Level)shooter.level(), (Player)player, (int)1, (boolean)true) < 0) {
                    return;
                }
            }
            ArrayList<ItemStack> projectiles = new ArrayList<ItemStack>();
            projectiles.add(shooter.getProjectile(weapon));
            this.shoot(serverlevel, shooter, pHand, weapon, projectiles, pVelocity, pInaccuracy, shooter instanceof Player, pTarget);
            if (shooter instanceof ServerPlayer) {
                ServerPlayer serverplayer = (ServerPlayer)shooter;
                CriteriaTriggers.SHOT_CROSSBOW.trigger(serverplayer, weapon);
                serverplayer.awardStat(Stats.ITEM_USED.get((Object)weapon.getItem()));
            }
        }
    }

    private static float getShootingPower(ItemStack pProjectile) {
        return pProjectile.is(Items.FIREWORK_ROCKET) ? 1.6f : 3.15f;
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entityLiving, int timeLeft) {
        int i = this.getUseDuration(stack, entityLiving) - timeLeft;
        float f = AutomaticCrossbow.getPowerForTime(i, stack, entityLiving);
        if (f >= 1.0f && !AutomaticCrossbow.isCharged(stack)) {
            this.setFullCharge(stack);
            entityLiving.level().playSound((Player)null, (Entity)entityLiving, (SoundEvent)SoundEvents.CROSSBOW_LOADING_END.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
            if (entityLiving instanceof Player) {
                Player player = (Player)entityLiving;
                player.getCooldowns().addCooldown(stack.getItem(), 8);
            }
        }
    }

    private static float getPowerForTime(int pTimeLeft, ItemStack pStack, LivingEntity pShooter) {
        float f = (float)pTimeLeft / (float)AutomaticCrossbow.getChargeDuration(pStack, pShooter);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        if (remainingUseDuration <= 1) {
            this.releaseUsing(stack, level, livingEntity, remainingUseDuration);
        }
        if (remainingUseDuration % 5 == 0) {
            livingEntity.level().playSound((Player)null, (Entity)livingEntity, SoundEvents.LEVER_CLICK, SoundSource.PLAYERS, 0.4f, 1.2f);
        }
        if (remainingUseDuration % 16 == 0) {
            livingEntity.level().playSound((Player)null, (Entity)livingEntity, (SoundEvent)SoundEvents.CROSSBOW_LOADING_MIDDLE.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if (remainingUseDuration % 2 == 0) {
            livingEntity.level().playSound((Player)null, (Entity)livingEntity, SoundEvents.CHAIN_STEP, SoundSource.PLAYERS, 0.6f, 0.4f + 0.3f * new Random().nextFloat());
        }
    }

    protected void shoot(ServerLevel pLevel, LivingEntity pShooter, InteractionHand pHand, ItemStack pWeapon, List<ItemStack> pProjectileItems, float pVelocity, float pInaccuracy, boolean pIsCrit, @Nullable LivingEntity pTarget) {
        float f = EnchantmentHelper.processProjectileSpread((ServerLevel)pLevel, (ItemStack)pWeapon, (Entity)pShooter, (float)0.0f);
        int multiShot = pWeapon.getEnchantmentLevel((Holder)((Registry)pShooter.level().registryAccess().registry(Registries.ENCHANTMENT).get()).getHolder(Enchantments.MULTISHOT).get());
        int amount = 1 + 2 * multiShot;
        if (multiShot >= 1) {
            for (int i = -multiShot; i <= multiShot; ++i) {
                ItemStack itemstack = pProjectileItems.get(0);
                if (itemstack.isEmpty()) continue;
                float f4 = 1.0471976f / (float)multiShot * (float)i * 12.0f;
                Projectile projectile = this.createProjectile((Level)pLevel, pShooter, pWeapon, itemstack, pIsCrit);
                this.shootProjectile(pShooter, projectile, i, pVelocity, pInaccuracy, f4, pTarget);
                pLevel.addFreshEntity((Entity)projectile);
                pWeapon.hurtAndBreak(this.getDurabilityUse(itemstack), pShooter, LivingEntity.getSlotForHand((InteractionHand)pHand));
                if (!pWeapon.isEmpty()) {
                    continue;
                }
                break;
            }
        } else {
            float f1 = pProjectileItems.size() == 1 ? 0.0f : 2.0f * f / (float)(pProjectileItems.size() - 1);
            float f2 = (float)((pProjectileItems.size() - 1) % 2) * f1 / 2.0f;
            float f3 = 1.0f;
            for (int i = 0; i < pProjectileItems.size(); ++i) {
                ItemStack itemstack = pProjectileItems.get(i);
                if (itemstack.isEmpty()) continue;
                float f4 = f2 + f3 * (float)((i + 1) / 2) * f1;
                f3 = -f3;
                Projectile projectile = this.createProjectile((Level)pLevel, pShooter, pWeapon, itemstack, pIsCrit);
                this.shootProjectile(pShooter, projectile, i, pVelocity, pInaccuracy, f4, pTarget);
                pLevel.addFreshEntity((Entity)projectile);
                pWeapon.hurtAndBreak(this.getDurabilityUse(itemstack), pShooter, LivingEntity.getSlotForHand((InteractionHand)pHand));
                if (!pWeapon.isEmpty()) {
                    continue;
                }
                break;
            }
        }
    }

    public int getUseDuration(ItemStack pStack, LivingEntity pEntity) {
        return AutomaticCrossbow.getChargeDuration(pStack, pEntity) + 12;
    }

    public static int getChargeDuration(ItemStack pStack, LivingEntity pShooter) {
        float f = EnchantmentHelper.modifyCrossbowChargingTime((ItemStack)pStack, (LivingEntity)pShooter, (float)1.25f);
        return Mth.floor((float)(f * 20.0f));
    }

    public void decreaseCharge(ItemStack stack) {
        this.setCharge(stack, Math.max(0, AutomaticCrossbow.getCharge(stack) - 1));
    }

    public void setCharge(ItemStack stack, int i) {
        stack.set(DataComponentInit.CHARGE, (Object)i);
    }

    public void setFullCharge(ItemStack stack) {
        this.setCharge(stack, 24);
    }

    public static int getCharge(ItemStack stack) {
        return stack.get(DataComponentInit.CHARGE) != null ? (Integer)stack.getOrDefault(DataComponentInit.CHARGE, (Object)0) : 0;
    }

    public static boolean isCharged(ItemStack stack) {
        return AutomaticCrossbow.getCharge(stack) > 0;
    }

    protected int getDurabilityUse(ItemStack pStack) {
        return pStack.is(Items.FIREWORK_ROCKET) ? 3 : 1;
    }

    protected void shootProjectile(LivingEntity pShooter, Projectile pProjectile, int pIndex, float pVelocity, float pInaccuracy, float pAngle, @javax.annotation.Nullable LivingEntity pTarget) {
        Vector3f vector3f;
        if (pTarget != null) {
            double d0 = pTarget.getX() - pShooter.getX();
            double d1 = pTarget.getZ() - pShooter.getZ();
            double d2 = Math.sqrt(d0 * d0 + d1 * d1);
            double d3 = pTarget.getY(0.3333333333333333) - pProjectile.getY() + d2 * (double)0.2f;
            vector3f = AutomaticCrossbow.getProjectileShotVector(pShooter, new Vec3(d0, d3, d1), pAngle);
        } else {
            Vec3 vec3 = pShooter.getUpVector(1.0f);
            Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(pAngle * ((float)Math.PI / 180)), vec3.x, vec3.y, vec3.z);
            Vec3 vec31 = pShooter.getViewVector(1.0f);
            vector3f = vec31.toVector3f().rotate((Quaternionfc)quaternionf);
        }
        pProjectile.shoot((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), pVelocity, pInaccuracy);
        float f = AutomaticCrossbow.getShotPitch(pShooter.getRandom(), pIndex);
        pShooter.level().playSound(null, pShooter.getX(), pShooter.getY(), pShooter.getZ(), SoundEvents.CROSSBOW_SHOOT, pShooter.getSoundSource(), 0.4f, f);
    }

    private static Vector3f getProjectileShotVector(LivingEntity pShooter, Vec3 pDistance, float pAngle) {
        Vector3f vector3f = pDistance.toVector3f().normalize();
        Vector3f vector3f1 = new Vector3f((Vector3fc)vector3f).cross((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
        if ((double)vector3f1.lengthSquared() <= 1.0E-7) {
            Vec3 vec3 = pShooter.getUpVector(1.0f);
            vector3f1 = new Vector3f((Vector3fc)vector3f).cross((Vector3fc)vec3.toVector3f());
        }
        Vector3f vector3f2 = new Vector3f((Vector3fc)vector3f).rotateAxis(1.5707964f, vector3f1.x, vector3f1.y, vector3f1.z);
        return new Vector3f((Vector3fc)vector3f).rotateAxis(pAngle * ((float)Math.PI / 180), vector3f2.x, vector3f2.y, vector3f2.z);
    }

    private static float getShotPitch(RandomSource pRandom, int pIndex) {
        return pIndex == 0 ? 1.0f : AutomaticCrossbow.getRandomShotPitch((pIndex & 1) == 1, pRandom);
    }

    private static float getRandomShotPitch(boolean pIsHighPitched, RandomSource pRandom) {
        float f = pIsHighPitched ? 0.63f : 0.43f;
        return 1.0f / (pRandom.nextFloat() * 0.5f + 1.8f) + f;
    }

    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.CROSSBOW;
    }

    public boolean useOnRelease(ItemStack pStack) {
        return true;
    }

    protected Projectile createProjectile(Level pLevel, LivingEntity pShooter, ItemStack pWeapon, ItemStack pAmmo, boolean pIsCrit) {
        if (pAmmo.is(Items.FIREWORK_ROCKET)) {
            return new FireworkRocketEntity(pLevel, pAmmo, (Entity)pShooter, pShooter.getX(), pShooter.getEyeY() - (double)0.15f, pShooter.getZ(), true);
        }
        Projectile projectile = super.createProjectile(pLevel, pShooter, pWeapon, pAmmo, pIsCrit);
        if (projectile instanceof AbstractArrow) {
            AbstractArrow abstractarrow = (AbstractArrow)projectile;
            abstractarrow.setSoundEvent(SoundEvents.CROSSBOW_HIT);
        }
        return projectile;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(this){

            @Nullable
            public HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
                return AutomaticCrossbow.isCharged(itemStack) && !entityLiving.swinging ? HumanoidModel.ArmPose.CROSSBOW_HOLD : HumanoidModel.ArmPose.ITEM;
            }
        });
    }
}

