/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.alchemistarsenal.common.item.equipment;

import github.nitespring.alchemistarsenal.common.item.equipment.ICustomElytra;
import github.nitespring.alchemistarsenal.core.init.KeybindInit;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class SteampunkWingsItem
extends ElytraItem
implements ICustomElytra {
    public static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"alkhars", (String)"textures/equipment/steampunk_wings.png");

    public SteampunkWingsItem(Item.Properties properties) {
        super(properties);
    }

    public static boolean isFlyEnabled(ItemStack pElytraStack) {
        return pElytraStack.getDamageValue() < pElytraStack.getMaxDamage() - 1;
    }

    public boolean isValidRepairItem(ItemStack pToRepair, ItemStack pRepair) {
        return pRepair.is(Items.COPPER_BLOCK);
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        return this.swapWithEquipmentSlot((Item)this, pLevel, pPlayer, pHand);
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return SteampunkWingsItem.isFlyEnabled(stack);
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        Vec3 pos = entity.position();
        Vec3 mov = entity.getDeltaMovement();
        Level level = entity.level();
        int nextFlightTick = flightTicks + 1;
        Random rand = new Random();
        if (!entity.level().isClientSide) {
            int i;
            if (nextFlightTick % 10 == 0) {
                if (nextFlightTick % 20 == 0) {
                    stack.hurtAndBreak(1, entity, EquipmentSlot.CHEST);
                }
                entity.gameEvent((Holder)GameEvent.ELYTRA_GLIDE);
            }
            if (nextFlightTick % 12 == 0) {
                for (i = 0; i <= 5; ++i) {
                    ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, pos.x - 0.1 * mov.x + 0.5 * (double)rand.nextFloat(-0.5f, 0.5f), pos.y + 0.5 - 0.1 * mov.y, pos.z - 0.1 * mov.z + 0.5 * (double)rand.nextFloat(-0.5f, 0.5f), 0, mov.x + 0.25 * (double)rand.nextFloat(-0.5f, 0.5f), mov.y + 0.1 * (double)rand.nextFloat(-0.5f, 0.5f), mov.z + 0.25 * (double)rand.nextFloat(-0.5f, 0.5f), (double)0.1f);
                }
            }
            if (mov.length() >= 0.25) {
                if (nextFlightTick % 8 == 0) {
                    for (i = 0; i < 3; ++i) {
                        ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_SIGNAL_SMOKE, pos.x - 0.1 * mov.x + 0.5 * (double)rand.nextFloat(-0.5f, 0.5f), pos.y + 0.5 - 0.1 * mov.y, pos.z - 0.1 * mov.z + 0.5 * (double)rand.nextFloat(-0.5f, 0.5f), 0, mov.x + 0.25 * (double)rand.nextFloat(-0.5f, 0.5f), mov.y + 0.1 * (double)rand.nextFloat(-0.5f, 0.5f), mov.z + 0.25 * (double)rand.nextFloat(-0.5f, 0.5f), (double)0.1f);
                    }
                }
                if (nextFlightTick % 2 == 0) {
                    for (i = 0; i < 5; ++i) {
                        ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SMOKE, pos.x - 0.1 * mov.x + 0.5 * (double)rand.nextFloat(-0.5f, 0.5f), pos.y + 0.5 - 0.1 * mov.y, pos.z - 0.1 * mov.z + 0.5 * (double)rand.nextFloat(-0.5f, 0.5f), 0, mov.x + 0.25 * (double)rand.nextFloat(-0.5f, 0.5f), mov.y + 0.1 * (double)rand.nextFloat(-0.5f, 0.5f), mov.z + 0.25 * (double)rand.nextFloat(-0.5f, 0.5f), (double)0.1f);
                    }
                }
                if (nextFlightTick % 5 == 0) {
                    for (i = 0; i < 2; ++i) {
                        ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, pos.x - 0.1 * mov.x + 0.5 * (double)rand.nextFloat(-0.5f, 0.5f), pos.y + 0.5 - 0.1 * mov.y, pos.z - 0.1 * mov.z + 0.5 * (double)rand.nextFloat(-0.5f, 0.5f), 0, mov.x + 0.25 * (double)rand.nextFloat(-0.5f, 0.5f), mov.y + 0.1 * (double)rand.nextFloat(-0.5f, 0.5f), mov.z + 0.25 * (double)rand.nextFloat(-0.5f, 0.5f), (double)0.1f);
                    }
                }
            }
        }
        if (entity.getDeltaMovement().length() >= 0.1 && nextFlightTick % 16 == 0) {
            entity.playSound(SoundEvents.PHANTOM_FLAP, 0.6f + 0.1f * rand.nextFloat(), 1.5f + 0.75f * rand.nextFloat());
        }
        if (nextFlightTick % 8 == 0) {
            entity.playSound(SoundEvents.FIRE_AMBIENT, 0.6f + 0.1f * rand.nextFloat(), 1.5f + 0.75f * rand.nextFloat());
        }
        return true;
    }

    public Holder<SoundEvent> getEquipSound() {
        return SoundEvents.ARMOR_EQUIP_ELYTRA;
    }

    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.CHEST;
    }

    @Override
    public ResourceLocation getDefaultElytraTexture() {
        return TEXTURE_LOCATION;
    }

    @Override
    public boolean shouldAutoboost() {
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"comment.alkhars.steampunk_wings1").append(((KeyMapping)KeybindInit.BOOST_KEYBIND.get()).getKey().getDisplayName()).append((Component)Component.translatable((String)"comment.alkhars.steampunk_wings2")).withStyle(ChatFormatting.AQUA));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

