/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.alchemistarsenal.common.item.equipment;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import org.jetbrains.annotations.Nullable;

public class SteampunkSuitItem
extends ArmorItem {
    public static final ResourceLocation TEXTURE_LOCATION_OUTER_LAYER = ResourceLocation.fromNamespaceAndPath((String)"alkhars", (String)"textures/equipment/steampunk_suit.png");
    public static final ResourceLocation TEXTURE_LOCATION_INNER_LAYER = ResourceLocation.fromNamespaceAndPath((String)"alkhars", (String)"textures/equipment/steampunk_leggings.png");
    private final Supplier<ItemAttributeModifiers> customModifiers = Suppliers.memoize(() -> {
        int defense = ((ArmorMaterial)material.value()).getDefense(type);
        float toughness = ((ArmorMaterial)material.value()).toughness();
        ItemAttributeModifiers.Builder itemattributemodifiers$builder = ItemAttributeModifiers.builder();
        EquipmentSlotGroup equipmentslotgroup = EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot());
        ResourceLocation resourcelocation = ResourceLocation.withDefaultNamespace((String)("armor." + type.getName()));
        itemattributemodifiers$builder.add(Attributes.ARMOR, new AttributeModifier(resourcelocation, (double)defense, AttributeModifier.Operation.ADD_VALUE), equipmentslotgroup);
        itemattributemodifiers$builder.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(resourcelocation, (double)toughness, AttributeModifier.Operation.ADD_VALUE), equipmentslotgroup);
        float knockbackResistance = ((ArmorMaterial)material.value()).knockbackResistance();
        if (knockbackResistance > 0.0f) {
            itemattributemodifiers$builder.add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(resourcelocation, (double)knockbackResistance, AttributeModifier.Operation.ADD_VALUE), equipmentslotgroup);
        }
        if (speedModifier != 0.0f) {
            itemattributemodifiers$builder.add(Attributes.MOVEMENT_SPEED, new AttributeModifier(resourcelocation, (double)speedModifier, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), equipmentslotgroup);
        }
        if (jumpModifier != 0.0f) {
            itemattributemodifiers$builder.add(Attributes.JUMP_STRENGTH, new AttributeModifier(resourcelocation, (double)jumpModifier, AttributeModifier.Operation.ADD_VALUE), equipmentslotgroup);
        }
        if (stepHeightModifier != 0.0f) {
            itemattributemodifiers$builder.add(Attributes.STEP_HEIGHT, new AttributeModifier(resourcelocation, (double)stepHeightModifier, AttributeModifier.Operation.ADD_VALUE), equipmentslotgroup);
        }
        if (miningEfficiencyModifier != 0.0f) {
            itemattributemodifiers$builder.add(Attributes.MINING_EFFICIENCY, new AttributeModifier(resourcelocation, (double)miningEfficiencyModifier, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), equipmentslotgroup);
        }
        if (blockBreakSpeed != 0.0f) {
            itemattributemodifiers$builder.add(Attributes.BLOCK_BREAK_SPEED, new AttributeModifier(resourcelocation, (double)blockBreakSpeed, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), equipmentslotgroup);
        }
        if (gravityModifier != 0.0f) {
            itemattributemodifiers$builder.add(Attributes.GRAVITY, new AttributeModifier(resourcelocation, (double)gravityModifier, AttributeModifier.Operation.ADD_VALUE), equipmentslotgroup);
        }
        if (fallDamageModifier != 0.0f) {
            itemattributemodifiers$builder.add(Attributes.FALL_DAMAGE_MULTIPLIER, new AttributeModifier(resourcelocation, (double)fallDamageModifier, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), equipmentslotgroup);
        }
        if (safeFallHeightModifier != 0.0f) {
            itemattributemodifiers$builder.add(Attributes.SAFE_FALL_DISTANCE, new AttributeModifier(resourcelocation, (double)safeFallHeightModifier, AttributeModifier.Operation.ADD_VALUE), equipmentslotgroup);
        }
        return itemattributemodifiers$builder.build();
    });

    public SteampunkSuitItem(float speedModifier, float jumpModifier, float stepHeightModifier, float miningEfficiencyModifier, float blockBreakSpeed, float fallDamageModifier, float gravityModifier, float safeFallHeightModifier, Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers() {
        return this.customModifiers.get();
    }

    @Nullable
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        return slot == EquipmentSlot.LEGS ? TEXTURE_LOCATION_INNER_LAYER : TEXTURE_LOCATION_OUTER_LAYER;
    }
}

