/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.alchemistarsenal.common.item.equipment;

import github.nitespring.alchemistarsenal.common.item.equipment.ICustomElytra;
import github.nitespring.alchemistarsenal.common.item.equipment.SteampunkSuitItem;
import github.nitespring.alchemistarsenal.common.item.equipment.SteampunkWingsItem;
import github.nitespring.alchemistarsenal.core.init.KeybindInit;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class SteampunkChestplateItem
extends SteampunkSuitItem
implements ICustomElytra {
    public static final Predicate<ItemStack> ROCKETS = predicate -> predicate.is(Items.FIREWORK_ROCKET);

    public SteampunkChestplateItem(float speedModifier, float jumpModifier, float stepHeightModifier, float miningEfficiencyModifier, float blockBreakSpeed, float fallDamageModifier, float gravityModifier, float safeFallHeightModifier, Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties) {
        super(speedModifier, jumpModifier, stepHeightModifier, miningEfficiencyModifier, blockBreakSpeed, fallDamageModifier, gravityModifier, safeFallHeightModifier, material, type, properties);
    }

    public static boolean isFlyEnabled(ItemStack pElytraStack) {
        return pElytraStack.getDamageValue() < pElytraStack.getMaxDamage() - 1;
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return SteampunkChestplateItem.isFlyEnabled(stack);
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        Vec3 pos = entity.position();
        Vec3 mov = entity.getDeltaMovement();
        Level level = entity.level();
        int nextFlightTick = flightTicks + 1;
        Random rand = new Random();
        if (!entity.level().isClientSide) {
            int i;
            if (nextFlightTick % 10 == 0) {
                if (nextFlightTick % 20 == 0) {
                    stack.hurtAndBreak(1, entity, EquipmentSlot.CHEST);
                }
                entity.gameEvent((Holder)GameEvent.ELYTRA_GLIDE);
            }
            if (nextFlightTick % 12 == 0) {
                for (i = 0; i <= 5; ++i) {
                    ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, pos.x - 0.1 * mov.x + 0.5 * (double)rand.nextFloat(-0.5f, 0.5f), pos.y + 0.5 - 0.1 * mov.y, pos.z - 0.1 * mov.z + 0.5 * (double)rand.nextFloat(-0.5f, 0.5f), 0, mov.x + 0.25 * (double)rand.nextFloat(-0.5f, 0.5f), mov.y + 0.1 * (double)rand.nextFloat(-0.5f, 0.5f), mov.z + 0.25 * (double)rand.nextFloat(-0.5f, 0.5f), (double)0.1f);
                }
            }
            if (mov.length() >= 0.25) {
                if (nextFlightTick % 8 == 0) {
                    for (i = 0; i < 3; ++i) {
                        ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_SIGNAL_SMOKE, pos.x - 0.1 * mov.x + 0.5 * (double)rand.nextFloat(-0.5f, 0.5f), pos.y + 0.5 - 0.1 * mov.y, pos.z - 0.1 * mov.z + 0.5 * (double)rand.nextFloat(-0.5f, 0.5f), 0, mov.x + 0.25 * (double)rand.nextFloat(-0.5f, 0.5f), mov.y + 0.1 * (double)rand.nextFloat(-0.5f, 0.5f), mov.z + 0.25 * (double)rand.nextFloat(-0.5f, 0.5f), (double)0.1f);
                    }
                }
                if (nextFlightTick % 2 == 0) {
                    for (i = 0; i < 5; ++i) {
                        ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SMOKE, pos.x - 0.1 * mov.x + 0.5 * (double)rand.nextFloat(-0.5f, 0.5f), pos.y + 0.5 - 0.1 * mov.y, pos.z - 0.1 * mov.z + 0.5 * (double)rand.nextFloat(-0.5f, 0.5f), 0, mov.x + 0.25 * (double)rand.nextFloat(-0.5f, 0.5f), mov.y + 0.1 * (double)rand.nextFloat(-0.5f, 0.5f), mov.z + 0.25 * (double)rand.nextFloat(-0.5f, 0.5f), (double)0.1f);
                    }
                }
                if (nextFlightTick % 5 == 0) {
                    for (i = 0; i < 2; ++i) {
                        ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, pos.x - 0.1 * mov.x + 0.5 * (double)rand.nextFloat(-0.5f, 0.5f), pos.y + 0.5 - 0.1 * mov.y, pos.z - 0.1 * mov.z + 0.5 * (double)rand.nextFloat(-0.5f, 0.5f), 0, mov.x + 0.25 * (double)rand.nextFloat(-0.5f, 0.5f), mov.y + 0.1 * (double)rand.nextFloat(-0.5f, 0.5f), mov.z + 0.25 * (double)rand.nextFloat(-0.5f, 0.5f), (double)0.1f);
                    }
                }
            }
        }
        if (entity.getDeltaMovement().length() >= 0.1 && nextFlightTick % 16 == 0) {
            entity.playSound(SoundEvents.PHANTOM_FLAP, 0.6f + 0.1f * rand.nextFloat(), 1.5f + 0.75f * rand.nextFloat());
        }
        if (nextFlightTick % 8 == 0) {
            entity.playSound(SoundEvents.FIRE_AMBIENT, 0.6f + 0.1f * rand.nextFloat(), 1.5f + 0.75f * rand.nextFloat());
        }
        return true;
    }

    @Override
    public ResourceLocation getDefaultElytraTexture() {
        return SteampunkWingsItem.TEXTURE_LOCATION;
    }

    @Override
    public boolean shouldAutoboost() {
        return true;
    }

    public void shoot(Player player, ItemStack stack) {
        if (player.isCreative() || player.getInventory().contains(ROCKETS)) {
            player.level().playSound(null, player.blockPosition(), SoundEvents.FIRECHARGE_USE, SoundSource.PLAYERS, 1.0f, 0.6f);
            player.level().playSound(null, player.blockPosition(), (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.PLAYERS, 0.2f, 0.6f);
            ItemStack rocketItem = new ItemStack((ItemLike)Items.FIREWORK_ROCKET);
            rocketItem.set(DataComponents.FIREWORKS, (Object)new Fireworks(1, Collections.singletonList(FireworkExplosion.DEFAULT)));
            int n = player.getInventory().getContainerSize();
            boolean hasAmmo = false;
            for (int i = 0; !hasAmmo && i <= n; ++i) {
                if (!ROCKETS.test(player.getInventory().getItem(i))) continue;
                rocketItem = player.getInventory().getItem(i);
                if (!player.isCreative()) {
                    player.getInventory().getItem(i).shrink(1);
                }
                hasAmmo = true;
            }
            Random rand = new Random();
            Level level = player.level();
            Vec3 pos = player.position();
            Vec3 poseye = new Vec3(pos.x, player.getEyeY(), pos.z);
            Vec3 aim = player.getLookAngle();
            Vec3 pos1 = poseye.add(1.5 * aim.x + (double)rand.nextFloat(-0.5f, 0.5f), 1.5 * aim.y + (double)rand.nextFloat(-0.15f, 0.15f) + 0.25, 1.5 * aim.z + (double)rand.nextFloat(-0.5f, 0.5f));
            if (!level.isClientSide()) {
                int k;
                FireworkRocketEntity rocket = new FireworkRocketEntity(level, rocketItem, (Entity)player, pos1.x, pos1.y, pos1.z, true);
                rocket.shoot(aim.x, aim.y, aim.z, 2.5f, 1.5f);
                level.addFreshEntity((Entity)rocket);
                for (k = 0; k <= 2; ++k) {
                    ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, pos1.x() + (double)rand.nextFloat(-0.5f, 0.5f), pos1.y() + 0.25 + (double)rand.nextFloat(-0.5f, 0.5f), pos1.z() + (double)rand.nextFloat(-0.5f, 0.5f), 0, player.getRandom().nextGaussian() * 0.05, -player.getDeltaMovement().y * 0.5, player.getRandom().nextGaussian() * 0.05, (double)0.1f);
                }
                for (k = 0; k <= 4; ++k) {
                    ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, pos1.x() + (double)rand.nextFloat(-0.5f, 0.5f), pos1.y() + 0.25 + (double)rand.nextFloat(-0.5f, 0.5f), pos1.z() + (double)rand.nextFloat(-0.5f, 0.5f), 0, player.getRandom().nextGaussian() * 0.05, -player.getDeltaMovement().y * 0.5, player.getRandom().nextGaussian() * 0.05, (double)0.1f);
                }
                for (k = 0; k <= 7; ++k) {
                    ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SMOKE, pos1.x() + (double)rand.nextFloat(-0.5f, 0.5f), pos1.y() + 0.25 + (double)rand.nextFloat(-0.5f, 0.5f), pos1.z() + (double)rand.nextFloat(-0.5f, 0.5f), 0, player.getRandom().nextGaussian() * 0.05, -player.getDeltaMovement().y * 0.5, player.getRandom().nextGaussian() * 0.05, (double)0.1f);
                }
            }
            stack.hurtAndBreak(3, (LivingEntity)player, EquipmentSlot.CHEST);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"comment.alkhars.steampunk_chestplate").withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.translatable((String)"comment.alkhars.steampunk_wings1").append(((KeyMapping)KeybindInit.BOOST_KEYBIND.get()).getKey().getDisplayName()).append((Component)Component.translatable((String)"comment.alkhars.steampunk_wings2")).withStyle(ChatFormatting.AQUA));
        tooltipComponents.add((Component)Component.translatable((String)"comment.alkhars.steampunk_chestplate1").append(((KeyMapping)KeybindInit.SHOOT_KEYBIND.get()).getKey().getDisplayName()).append((Component)Component.translatable((String)"comment.alkhars.steampunk_chestplate2")).withStyle(ChatFormatting.YELLOW));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

