/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.alchemistarsenal.common.item.equipment;

import github.nitespring.alchemistarsenal.common.entity.projectile.ElytraBooster;
import github.nitespring.alchemistarsenal.core.init.DataComponentInit;
import github.nitespring.alchemistarsenal.core.tags.CustomItemTags;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;

public interface ICustomElytra {
    default public ResourceLocation getElytraTexture(ItemStack stack) {
        if (stack.has(DataComponentInit.CUSTOM_WINGS_TEXTURE)) {
            return DataComponentInit.CUSTOM_WINGS_TEXTURE.getId();
        }
        return this.getDefaultElytraTexture();
    }

    public ResourceLocation getDefaultElytraTexture();

    default public void autoBoost(Player player, ItemStack stack) {
        if (player.isFallFlying() && (player.isCreative() || player.getInventory().contains(CustomItemTags.STEAMPUNK_WINGS_FUEL))) {
            if (!player.level().isClientSide()) {
                ItemStack item = new ItemStack((ItemLike)Items.FIREWORK_ROCKET);
                item.set(DataComponents.FIREWORKS, (Object)new Fireworks(5, List.of()));
                ElytraBooster rocket = new ElytraBooster(player.level(), item, (LivingEntity)player);
                rocket.setPos(player.position());
                player.level().addFreshEntity((Entity)rocket);
                Vec3 pos = player.position().add(0.0, (double)(player.getBbHeight() * 0.5f), 0.0);
                Vec3 aim = player.getLookAngle().normalize();
                Vec3 aim1 = new Vec3(aim.z, -aim.y, aim.x);
                Vec3 pos1 = pos.add(aim.scale(-0.25));
                float a = -0.5235988f;
                float d = 0.75f;
                for (int i = 0; i < 12; ++i) {
                    Vec3 aim2 = new Vec3((double)d * (aim.z * Math.cos((float)i * a) - aim.y * Math.sin((float)i * a)), (double)d * (aim.y * Math.cos((float)i * a) + Math.sqrt(aim.x * aim.x + aim.z * aim.z) * Math.sin((float)i * a)), (double)d * (-aim.x * Math.cos((float)i * a) - aim.y * Math.sin((float)i * a)));
                    Vec3 posf = pos1.add(aim2);
                    ((ServerLevel)player.level()).sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, posf.x(), posf.y(), posf.z(), 0, player.getRandom().nextGaussian() * 0.05, -player.getDeltaMovement().y * 0.5, player.getRandom().nextGaussian() * 0.05, (double)0.1f);
                }
            }
            player.level().playSound(null, player.blockPosition(), SoundEvents.FIRECHARGE_USE, SoundSource.PLAYERS, 1.0f, 0.6f);
            int n = player.getInventory().getContainerSize();
            boolean hasFuel = false;
            for (int i = 0; !hasFuel && i <= n; ++i) {
                if (!player.getInventory().getItem(i).is(CustomItemTags.STEAMPUNK_WINGS_FUEL)) continue;
                if (!player.isCreative()) {
                    player.getInventory().getItem(i).shrink(1);
                }
                hasFuel = true;
            }
            stack.hurtAndBreak(5, (LivingEntity)player, EquipmentSlot.CHEST);
        }
    }

    public boolean shouldAutoboost();
}

