/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.alchemistarsenal.common.item.concoctions;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class Fertilizer
extends Item {
    private final int intensity;
    private final int range;
    private final int type;
    public static DispenseItemBehavior FERTILIZER_DISPENSER_BEHAVIOUR = new OptionalDispenseItemBehavior(){

        protected ItemStack execute(BlockSource blockSource, ItemStack stack) {
            this.setSuccess(true);
            ServerLevel level = blockSource.level();
            if (level.isClientSide()) {
                this.setSuccess(false);
            } else {
                BlockPos pos = blockSource.pos().relative((Direction)blockSource.state().getValue((Property)DispenserBlock.FACING));
                BlockState block = level.getBlockState(pos);
                Block block2 = block.getBlock();
                if (block2 instanceof BonemealableBlock) {
                    BonemealableBlock bonemealableblock = (BonemealableBlock)block2;
                    if (blockSource.state().getValue((Property)DispenserBlock.FACING) != Direction.DOWN && blockSource.state().getValue((Property)DispenserBlock.FACING) != Direction.UP) {
                        pos = blockSource.pos().relative((Direction)blockSource.state().getValue((Property)DispenserBlock.FACING), 2);
                    }
                    for (int i = -1; i <= 1; ++i) {
                        for (int k = -1; k <= 1; ++k) {
                            for (int j = -1; j <= 1; ++j) {
                                BonemealableBlock bonemealableblock1;
                                BlockPos pos1 = new BlockPos(pos.getX() + i, pos.getY() + j, pos.getZ() + k);
                                BlockState block1 = level.getBlockState(pos1);
                                Block block3 = block1.getBlock();
                                if (!(block3 instanceof BonemealableBlock) || !(bonemealableblock1 = (BonemealableBlock)block3).isValidBonemealTarget((LevelReader)level, pos1, block1)) continue;
                                for (int n = 0; n < 1; ++n) {
                                    bonemealableblock1.performBonemeal(level, level.getRandom(), pos1, block1);
                                }
                                level.levelEvent(1505, pos1, 15);
                            }
                        }
                    }
                    stack.consume(1, null);
                } else {
                    this.setSuccess(false);
                }
            }
            return stack;
        }
    };
    public static DispenseItemBehavior ENHANCED_FERTILIZER_DISPENSER_BEHAVIOUR = new OptionalDispenseItemBehavior(){

        protected ItemStack execute(BlockSource blockSource, ItemStack stack) {
            this.setSuccess(true);
            ServerLevel level = blockSource.level();
            if (level.isClientSide()) {
                this.setSuccess(false);
            } else {
                BlockPos pos = blockSource.pos().relative((Direction)blockSource.state().getValue((Property)DispenserBlock.FACING));
                BlockState block = level.getBlockState(pos);
                Block block2 = block.getBlock();
                if (block2 instanceof BonemealableBlock) {
                    BonemealableBlock bonemealableblock = (BonemealableBlock)block2;
                    if (blockSource.state().getValue((Property)DispenserBlock.FACING) != Direction.DOWN && blockSource.state().getValue((Property)DispenserBlock.FACING) != Direction.UP) {
                        pos = blockSource.pos().relative((Direction)blockSource.state().getValue((Property)DispenserBlock.FACING), 3);
                    }
                    for (int i = -2; i <= 2; ++i) {
                        for (int k = -2; k <= 2; ++k) {
                            for (int j = -2; j <= 2; ++j) {
                                BonemealableBlock bonemealableblock1;
                                BlockPos pos1 = new BlockPos(pos.getX() + i, pos.getY() + j, pos.getZ() + k);
                                BlockState block1 = level.getBlockState(pos1);
                                Block block3 = block1.getBlock();
                                if (!(block3 instanceof BonemealableBlock) || !(bonemealableblock1 = (BonemealableBlock)block3).isValidBonemealTarget((LevelReader)level, pos1, block1)) continue;
                                for (int n = 0; n < 3; ++n) {
                                    bonemealableblock1.performBonemeal(level, level.getRandom(), pos1, block1);
                                }
                                level.levelEvent(1505, pos1, 15);
                            }
                        }
                    }
                    stack.consume(1, null);
                } else {
                    this.setSuccess(false);
                }
            }
            return stack;
        }
    };

    public Fertilizer(int range, int intensity, int type, Item.Properties properties) {
        super(properties);
        this.range = range;
        this.intensity = intensity;
        this.type = type;
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand usedHand) {
        if (this.type == 1) {
            Zoglin zoglin;
            Piglin piglin;
            Zombie zombie;
            AgeableMob mob;
            if (target instanceof AgeableMob && (mob = (AgeableMob)target).isBaby()) {
                mob.setBaby(false);
                mob.setAge(0);
                this.doGrowEntity(player, target, stack);
                return InteractionResult.CONSUME;
            }
            if (target instanceof Zombie && (zombie = (Zombie)target).isBaby()) {
                zombie.setBaby(false);
                this.doGrowEntity(player, target, stack);
                return InteractionResult.CONSUME;
            }
            if (target instanceof Piglin && (piglin = (Piglin)target).isBaby()) {
                piglin.setBaby(false);
                this.doGrowEntity(player, target, stack);
                return InteractionResult.CONSUME;
            }
            if (target instanceof Zoglin && (zoglin = (Zoglin)target).isBaby()) {
                zoglin.setBaby(false);
                this.doGrowEntity(player, target, stack);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public void doGrowEntity(Player player, LivingEntity entity, ItemStack stack) {
        Level level = player.level();
        if (!player.isCreative()) {
            stack.shrink(1);
        }
        if (!level.isClientSide()) {
            for (int i = 0; i <= 25; ++i) {
                ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, entity.getRandomX(0.75), entity.getRandomY(), entity.getRandomZ(0.75), 0, entity.getRandom().nextGaussian() * 0.05, entity.getRandom().nextGaussian() * 0.05, entity.getRandom().nextGaussian() * 0.05, (double)0.1f);
            }
        }
        entity.playSound(SoundEvents.BONE_MEAL_USE);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (!context.getLevel().isClientSide()) {
            BlockPos pos = context.getClickedPos();
            BlockState block = context.getLevel().getBlockState(pos);
            Block block2 = block.getBlock();
            if (block2 instanceof BonemealableBlock) {
                BonemealableBlock bonemealableblock = (BonemealableBlock)block2;
                for (int i = -this.range; i <= this.range; ++i) {
                    for (int k = -this.range; k <= this.range; ++k) {
                        for (int j = -this.range; j <= this.range; ++j) {
                            BonemealableBlock bonemealableblock1;
                            BlockPos pos1 = new BlockPos(pos.getX() + i, pos.getY() + j, pos.getZ() + k);
                            BlockState block1 = context.getLevel().getBlockState(pos1);
                            Block block3 = block1.getBlock();
                            if (!(block3 instanceof BonemealableBlock) || !(bonemealableblock1 = (BonemealableBlock)block3).isValidBonemealTarget((LevelReader)context.getLevel(), pos1, block1)) continue;
                            for (int n = 0; n < this.intensity; ++n) {
                                bonemealableblock1.performBonemeal((ServerLevel)context.getLevel(), context.getLevel().getRandom(), pos1, block1);
                            }
                            context.getPlayer().gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
                            context.getLevel().levelEvent(1505, pos1, 15);
                        }
                    }
                }
                context.getItemInHand().consume(1, (LivingEntity)context.getPlayer());
                return InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide);
            }
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        switch (this.type) {
            case 1: {
                tooltipComponents.add((Component)Component.translatable((String)"comment.alkhars.enhanced_fertilizer").withStyle(ChatFormatting.GOLD));
                break;
            }
            default: {
                tooltipComponents.add((Component)Component.translatable((String)"comment.alkhars.fertilizer").withStyle(ChatFormatting.AQUA));
            }
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

