/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.alchemistarsenal.common.item.concoctions;

import github.nitespring.alchemistarsenal.common.entity.projectile.throwable.ExplosiveBottle;
import github.nitespring.alchemistarsenal.core.init.EntityInit;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ExplosiveBottleItem
extends Item
implements ProjectileItem {
    public ExplosiveBottleItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public Projectile asProjectile(Level pLevel, Position pPos, ItemStack pStack, Direction pDirection) {
        ExplosiveBottle bottle = new ExplosiveBottle((EntityType<? extends ThrowableItemProjectile>)((EntityType)EntityInit.EXPLOSIVE_BOTTLE.get()), pLevel);
        bottle.setPos(pPos.x(), pPos.y(), pPos.z());
        return bottle;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        Vec3 pos = player.position();
        Vec3 aim = player.getLookAngle();
        player.playSound(SoundEvents.SPLASH_POTION_THROW);
        if (!level.isClientSide) {
            ExplosiveBottle bottle = new ExplosiveBottle((EntityType<? extends ThrowableItemProjectile>)((EntityType)EntityInit.EXPLOSIVE_BOTTLE.get()), level);
            bottle.setOwner((Entity)player);
            bottle.setPos(pos.add(aim.x() * 0.5, 1.75 + aim.y() * 0.5, aim.z() * 0.5));
            bottle.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), -20.0f, 0.8f, 1.0f);
            level.addFreshEntity((Entity)bottle);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        itemstack.consume(1, (LivingEntity)player);
        player.getCooldowns().addCooldown((Item)this, 2);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"comment.alkhars.unstable_concoction").withStyle(ChatFormatting.DARK_PURPLE));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

