/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.alchemistarsenal.common.entity.projectile.throwable;

import github.nitespring.alchemistarsenal.core.init.ItemInit;
import github.nitespring.alchemistarsenal.core.tags.CustomBlockTags;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.HitResult;

public class FireBottle
extends ThrowableItemProjectile
implements ItemSupplier {
    int explosionTick = 3;
    boolean exploding = false;

    public FireBottle(EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public FireBottle(EntityType<? extends ThrowableItemProjectile> pEntityType, double pX, double pY, double pZ, Level pLevel) {
        super(pEntityType, pX, pY, pZ, pLevel);
    }

    public FireBottle(EntityType<? extends ThrowableItemProjectile> pEntityType, LivingEntity pShooter, Level pLevel) {
        super(pEntityType, pShooter, pLevel);
    }

    protected Item getDefaultItem() {
        return (Item)ItemInit.FLAME_IN_A_BOTTLE.get();
    }

    protected double getDefaultGravity() {
        return 0.05;
    }

    public void tick() {
        super.tick();
        if (this.exploding) {
            this.explosion();
            this.setDeltaMovement(0.0, 0.0, 0.0);
            --this.explosionTick;
        }
        if (this.explosionTick <= 0) {
            this.discard();
        }
    }

    protected void onHit(HitResult pResult) {
        super.onHit(pResult);
        this.exploding = true;
        this.setDeltaMovement(0.0, 0.0, 0.0);
    }

    public void explosion() {
        this.playSound(SoundEvents.SPLASH_POTION_BREAK);
        for (LivingEntity livingentity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(4.0, 4.0, 4.0))) {
            if (!(livingentity instanceof Player) && livingentity == this.getOwner() || this.getOwner().isAlliedTo((Entity)livingentity)) continue;
            livingentity.igniteForTicks(60);
            if (livingentity.hurtTime > 0 || livingentity.fireImmune()) continue;
            livingentity.hurt(this.level().damageSources().mobProjectile((Entity)this, (LivingEntity)this.getOwner()), 2.5f);
        }
        int zSpread = 2;
        int ySpread = 2;
        double x0 = this.position().x();
        double y0 = this.position().y();
        double z0 = this.position().z();
        for (int i = 0; i <= 24; ++i) {
            for (int j = 0; j <= zSpread; ++j) {
                for (int k = -ySpread; k <= ySpread; ++k) {
                    double a = 0.2617993877991494;
                    double d = j;
                    float xVar = (float)(d * Math.sin((double)i * a));
                    float yVar = k;
                    float zVar = (float)(d * Math.cos((double)i * a));
                    int x = Math.round((float)x0 + xVar);
                    int z = Math.round((float)z0 + zVar);
                    int y = Math.round((float)y0 + yVar);
                    BlockPos blockPos = new BlockPos(x, y, z);
                    if (!this.level().isClientSide() && !this.isUnderWater()) {
                        Random random = new Random();
                        if (random.nextFloat() <= 0.15f) {
                            if (this.level().getBlockState(blockPos).is(CustomBlockTags.FLAME_BREAKABLE)) {
                                this.level().destroyBlock(blockPos, true, this.getOwner());
                                this.level().gameEvent((Entity)this, (Holder)GameEvent.BLOCK_DESTROY, blockPos);
                            }
                            if (BaseFireBlock.canBePlacedAt((Level)this.level(), (BlockPos)blockPos, (Direction)Direction.getNearest((double)x0, (double)y0, (double)z0))) {
                                BlockState blockstate1 = BaseFireBlock.getState((BlockGetter)this.level(), (BlockPos)blockPos);
                                this.level().setBlock(blockPos, blockstate1, 11);
                                this.level().gameEvent((Entity)this, (Holder)GameEvent.BLOCK_PLACE, blockPos);
                            }
                        }
                    }
                    if (!this.level().isClientSide()) continue;
                    for (int n = 0; n <= 1; ++n) {
                        double xVar1 = 0.5 * Math.sin((double)i * a);
                        float yVar1 = k / 2;
                        double zVar1 = 0.5 * Math.cos((double)i * a);
                        this.level().addParticle(this.getExplosionParticleI(), x0 + 0.6 * (1.0 + 2.5 * (double)n) * xVar1 + 0.75 * ((double)this.random.nextFloat() - 0.5), y0 + 0.05 * (1.0 + 2.5 * (double)n) * (double)yVar1 + 0.5 * ((double)this.random.nextFloat() - 0.5), z0 + 0.6 * (1.0 + 2.5 * (double)n) * zVar1 + 0.75 * ((double)this.random.nextFloat() - 0.5), 0.25 * xVar1 + 0.25 * ((double)this.random.nextFloat() - 0.5), 0.1 * (double)this.random.nextFloat() + (double)(0.025f * yVar1) + 0.05 * ((double)this.random.nextFloat() - 0.5), 0.25 * zVar1 + 0.25 * ((double)this.random.nextFloat() - 0.5));
                        this.level().addParticle(this.getExplosionParticleII(), x0 + 0.5 * (1.0 + 2.5 * (double)n) * xVar1 + 0.75 * ((double)this.random.nextFloat() - 0.5), y0 + 0.15 * (1.0 + 2.5 * (double)n) * (double)yVar1 + 0.25 * ((double)this.random.nextFloat() - 0.5), z0 + 0.5 * (1.0 + 2.5 * (double)n) * zVar1 + 0.75 * ((double)this.random.nextFloat() - 0.5), 0.25 * xVar1 + 0.25 * ((double)this.random.nextFloat() - 0.5), (double)(0.15f * yVar1) + 0.05 * ((double)this.random.nextFloat() - 0.5), 0.25 * zVar1 + 0.25 * ((double)this.random.nextFloat() - 0.5));
                    }
                }
            }
        }
    }

    public ParticleOptions getExplosionParticleI() {
        return ParticleTypes.FLAME;
    }

    public ParticleOptions getExplosionParticleII() {
        return ParticleTypes.EFFECT;
    }
}

