/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.alchemistarsenal.common.entity.projectile.arrow;

import github.nitespring.alchemistarsenal.core.init.EntityInit;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SimpleExplosionDamageCalculator;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class WindArrow
extends AbstractArrow {
    protected int hitBlocks;
    public static final int MAX_HIT_BLOCKS = 3;

    public WindArrow(EntityType<? extends AbstractArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public WindArrow(double pX, double pY, double pZ, Level pLevel, ItemStack pPickupItemStack, @Nullable ItemStack pFiredFromWeapon) {
        super((EntityType)EntityInit.WIND_ARROW.get(), pX, pY, pZ, pLevel, pPickupItemStack, pFiredFromWeapon);
    }

    public WindArrow(LivingEntity pOwner, Level pLevel, ItemStack pPickupItemStack, @Nullable ItemStack pFiredFromWeapon) {
        super((EntityType)EntityInit.WIND_ARROW.get(), pOwner, pLevel, pPickupItemStack, pFiredFromWeapon);
    }

    protected ItemStack getPickupItem() {
        return Items.ARROW.getDefaultInstance();
    }

    protected ItemStack getDefaultPickupItem() {
        return Items.ARROW.getDefaultInstance();
    }

    public void tick() {
        super.tick();
        Vec3 mov = this.getDeltaMovement();
        Random rng = new Random();
        double ox = mov.x;
        double oy = mov.y;
        double oz = mov.z;
        for (int i = 0; i < 2; ++i) {
            this.level().addParticle((ParticleOptions)ParticleTypes.GUST, this.getX() + ox * (double)i / 4.0 + 0.5 * ((double)rng.nextFloat() - 0.5), this.getY() + oy * (double)i / 4.0 + 0.5 * ((double)rng.nextFloat() - 0.5), this.getZ() + oz * (double)i / 4.0 + 0.5 * ((double)rng.nextFloat() - 0.5), -0.05 * ox + 0.05 * ((double)rng.nextFloat() - 0.5), -0.05 * oy - 0.1 + 0.05 * ((double)rng.nextFloat() - 0.5), -0.05 * oz + 0.05 * ((double)rng.nextFloat() - 0.5));
        }
    }

    protected void onHit(HitResult pResult) {
        super.onHit(pResult);
        Vec3 pos = this.position();
        if (!this.level().isClientSide) {
            this.level().explode((Entity)this, null, (ExplosionDamageCalculator)new SimpleExplosionDamageCalculator(true, true, Optional.of(Float.valueOf(1.75f)), BuiltInRegistries.BLOCK.getTag(BlockTags.BLOCKS_WIND_CHARGE_EXPLOSIONS).map(Function.identity())), pos.x(), pos.y(), pos.z(), 1.5f, this.isOnFire(), Level.ExplosionInteraction.TRIGGER, (ParticleOptions)ParticleTypes.GUST_EMITTER_SMALL, (ParticleOptions)ParticleTypes.GUST_EMITTER_LARGE, (Holder)SoundEvents.WIND_CHARGE_BURST);
        }
        this.discard();
    }

    protected void onHitBlock(BlockHitResult pResult) {
        super.onHitBlock(pResult);
    }

    protected void onHitEntity(EntityHitResult pResult) {
        super.onHitEntity(pResult);
    }
}

