/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.alchemistarsenal.common.entity.projectile.arrow;

import github.nitespring.alchemistarsenal.core.init.EntityInit;
import github.nitespring.alchemistarsenal.core.init.ItemInit;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LightningArrow
extends AbstractArrow {
    protected int hitBlocks;
    public static final int MAX_HIT_BLOCKS = 3;

    public LightningArrow(EntityType<? extends AbstractArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public LightningArrow(double pX, double pY, double pZ, Level pLevel, ItemStack pPickupItemStack, @Nullable ItemStack pFiredFromWeapon) {
        super((EntityType)EntityInit.LIGHTNING_ARROW.get(), pX, pY, pZ, pLevel, pPickupItemStack, pFiredFromWeapon);
    }

    public LightningArrow(LivingEntity pOwner, Level pLevel, ItemStack pPickupItemStack, @Nullable ItemStack pFiredFromWeapon) {
        super((EntityType)EntityInit.LIGHTNING_ARROW.get(), pOwner, pLevel, pPickupItemStack, pFiredFromWeapon);
    }

    protected ItemStack getPickupItem() {
        return ((ArrowItem)ItemInit.LIGHTNING_ARROW.get()).getDefaultInstance();
    }

    protected ItemStack getDefaultPickupItem() {
        return ((ArrowItem)ItemInit.LIGHTNING_ARROW.get()).getDefaultInstance();
    }

    protected void onHit(HitResult pResult) {
        super.onHit(pResult);
    }

    protected void onHitBlock(BlockHitResult pResult) {
        super.onHitBlock(pResult);
        Random rand = new Random();
        if (pResult.getDirection() == Direction.UP) {
            BlockPos bPos = this.blockPosition();
            if (this.level().isThundering() && this.level().canSeeSky(bPos) && rand.nextFloat() <= 0.45f && !this.level().isClientSide()) {
                Vec3 pos = new Vec3(this.position().x, (double)bPos.getY(), this.position().z);
                LightningBolt lightning = new LightningBolt(EntityType.LIGHTNING_BOLT, this.level());
                lightning.setPos(pos);
                Entity entity = this.getOwner();
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    lightning.setCause(player);
                }
                this.level().addFreshEntity((Entity)lightning);
            }
        } else if (pResult.getDirection() == Direction.DOWN) {
            BlockPos bPos = pResult.getBlockPos();
            if (this.level().isThundering() && rand.nextFloat() <= 0.45f && !this.level().isClientSide()) {
                for (int i = 0; i <= 2; ++i) {
                    if (this.level().getBlockState(bPos.above()).isAir()) continue;
                    bPos = bPos.above();
                }
                if (this.level().canSeeSky(bPos)) {
                    Vec3 pos = new Vec3((double)bPos.getX(), (double)bPos.getY(), (double)bPos.getZ());
                    LightningBolt lightning = new LightningBolt(EntityType.LIGHTNING_BOLT, this.level());
                    lightning.setPos(pos);
                    Entity entity = this.getOwner();
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)entity;
                        lightning.setCause(player);
                    }
                    this.level().addFreshEntity((Entity)lightning);
                }
            }
        } else {
            BlockPos bPos = pResult.getBlockPos();
            if (this.level().isThundering() && rand.nextFloat() <= 0.45f && !this.level().isClientSide()) {
                for (int i = 0; i <= 2; ++i) {
                    if (this.level().getBlockState(bPos.above()).isAir()) continue;
                    bPos = bPos.above();
                }
                if (this.level().canSeeSky(bPos)) {
                    Vec3 pos = new Vec3((double)bPos.getX(), (double)bPos.getY(), (double)bPos.getZ());
                    LightningBolt lightning = new LightningBolt(EntityType.LIGHTNING_BOLT, this.level());
                    lightning.setPos(pos);
                    Entity entity = this.getOwner();
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)entity;
                        lightning.setCause(player);
                    }
                    this.level().addFreshEntity((Entity)lightning);
                }
            }
        }
    }

    protected void onHitEntity(EntityHitResult pResult) {
        super.onHitEntity(pResult);
        Entity entity = pResult.getEntity();
        BlockPos bPos = this.blockPosition();
        if (this.level().isThundering() && this.level().canSeeSky(bPos)) {
            Random random = new Random();
            if (random.nextFloat() <= 0.65f && !this.level().isClientSide()) {
                Vec3 pos = new Vec3(entity.position().x, entity.position().y, entity.position().z);
                LightningBolt lightning = new LightningBolt(EntityType.LIGHTNING_BOLT, this.level());
                lightning.setPos(pos);
                Entity entity2 = this.getOwner();
                if (entity2 instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity2;
                    lightning.setCause(player);
                }
                this.level().addFreshEntity((Entity)lightning);
            }
        }
    }
}

