/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.alchemistarsenal.common.entity.projectile.arrow;

import github.nitespring.alchemistarsenal.core.init.EntityInit;
import github.nitespring.alchemistarsenal.core.tags.CustomBlockTags;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class InfernalArrow
extends AbstractArrow {
    public InfernalArrow(EntityType<? extends AbstractArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public InfernalArrow(double pX, double pY, double pZ, Level pLevel, ItemStack pPickupItemStack, @Nullable ItemStack pFiredFromWeapon) {
        super((EntityType)EntityInit.INFERNAL_ARROW.get(), pX, pY, pZ, pLevel, pPickupItemStack, pFiredFromWeapon);
    }

    public InfernalArrow(LivingEntity pOwner, Level pLevel, ItemStack pPickupItemStack, @Nullable ItemStack pFiredFromWeapon) {
        super((EntityType)EntityInit.INFERNAL_ARROW.get(), pOwner, pLevel, pPickupItemStack, pFiredFromWeapon);
    }

    protected ItemStack getPickupItem() {
        return Items.ARROW.getDefaultInstance();
    }

    protected ItemStack getDefaultPickupItem() {
        return Items.ARROW.getDefaultInstance();
    }

    public void tick() {
        super.tick();
        Vec3 mov = this.getDeltaMovement();
        Random rng = new Random();
        double ox = mov.x;
        double oy = mov.y;
        double oz = mov.z;
        if (!this.isInWater()) {
            int i;
            if (!this.inGround) {
                for (i = 0; i < 4; ++i) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX() + ox * (double)i / 4.0 + 0.5 * ((double)rng.nextFloat() - 0.5), this.getY() + oy * (double)i / 4.0 + 0.5 * ((double)rng.nextFloat() - 0.5), this.getZ() + oz * (double)i / 4.0 + 0.5 * ((double)rng.nextFloat() - 0.5), -0.05 * ox + 0.1 * ((double)rng.nextFloat() - 0.5), -0.05 * oy + 0.1 * ((double)rng.nextFloat() - 0.5), -0.05 * oz + 0.1 * ((double)rng.nextFloat() - 0.5));
                }
            } else {
                if (this.tickCount % 4 == 0) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX() + ((double)rng.nextFloat() - 0.5), this.getY() + ((double)rng.nextFloat() - 0.5), this.getZ() + ((double)rng.nextFloat() - 0.5), 0.1 * ((double)rng.nextFloat() - 0.5), 0.15, 0.1 * ((double)rng.nextFloat() - 0.5));
                }
                if (this.tickCount % 24 == 0) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.getX() + ((double)rng.nextFloat() - 0.5), this.getY() + ((double)rng.nextFloat() - 0.5), this.getZ() + ((double)rng.nextFloat() - 0.5), 0.1 * ((double)rng.nextFloat() - 0.5), 0.1, 0.1 * ((double)rng.nextFloat() - 0.5));
                }
            }
            if (!this.inGround) {
                for (i = 0; i < 8; ++i) {
                    this.level().addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.FLAME, this.getX() + ox * (double)i / 6.0 + 0.5 * ((double)rng.nextFloat() - 0.5), this.getY() + oy * (double)i / 6.0 + 0.5 * ((double)rng.nextFloat() - 0.5), this.getZ() + oz * (double)i / 6.0 + 0.5 * ((double)rng.nextFloat() - 0.5), -0.1 * ox + 0.1 * ((double)rng.nextFloat() - 0.5), -0.1 * oy + 0.1 * ((double)rng.nextFloat() - 0.5), -0.1 * oz + 0.1 * ((double)rng.nextFloat() - 0.5));
                }
            } else if (this.tickCount % 6 == 0) {
                this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getX() + ((double)rng.nextFloat() - 0.5), this.getY() + ((double)rng.nextFloat() - 0.5), this.getZ() + ((double)rng.nextFloat() - 0.5), 0.15 * ((double)rng.nextFloat() - 0.5), 0.2, 0.15 * ((double)rng.nextFloat() - 0.5));
            }
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        BlockState blockstate;
        super.onHitBlock(result);
        BlockState block = this.level().getBlockState(result.getBlockPos());
        Vec3 mov = this.getDeltaMovement();
        BlockPos blockPos = result.getBlockPos().relative(result.getDirection());
        if (this.level().getBlockState(blockPos).is(CustomBlockTags.FLAME_BREAKABLE)) {
            this.level().destroyBlock(blockPos, true, this.getOwner());
            this.level().gameEvent((Entity)this, (Holder)GameEvent.BLOCK_DESTROY, blockPos);
        }
        if (BaseFireBlock.canBePlacedAt((Level)this.level(), (BlockPos)blockPos, (Direction)result.getDirection())) {
            blockstate = BaseFireBlock.getState((BlockGetter)this.level(), (BlockPos)blockPos);
            this.level().setBlock(blockPos, blockstate, 11);
            this.level().gameEvent((Entity)this, (Holder)GameEvent.BLOCK_PLACE, blockPos);
        }
        if (BaseFireBlock.canBePlacedAt((Level)this.level(), (BlockPos)blockPos, (Direction)Direction.UP)) {
            blockstate = BaseFireBlock.getState((BlockGetter)this.level(), (BlockPos)blockPos);
            this.level().setBlock(blockPos, blockstate, 11);
            this.level().gameEvent((Entity)this, (Holder)GameEvent.BLOCK_PLACE, blockPos);
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        result.getEntity().igniteForTicks(40);
        BlockState block = this.level().getBlockState(this.blockPosition());
        BlockPos blockPos = this.blockPosition();
        if (this.level().getBlockState(blockPos).is(CustomBlockTags.FLAME_BREAKABLE)) {
            this.level().destroyBlock(blockPos, true, this.getOwner());
            this.level().gameEvent((Entity)this, (Holder)GameEvent.BLOCK_DESTROY, blockPos);
        }
        if (BaseFireBlock.canBePlacedAt((Level)this.level(), (BlockPos)blockPos, (Direction)Direction.getNearest((Vec3)this.position()))) {
            BlockState blockstate = BaseFireBlock.getState((BlockGetter)this.level(), (BlockPos)blockPos);
            this.level().setBlock(blockPos, blockstate, 11);
            this.level().gameEvent((Entity)this, (Holder)GameEvent.BLOCK_PLACE, blockPos);
        }
    }
}

