/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.alchemistarsenal.common.entity.projectile.arrow;

import github.nitespring.alchemistarsenal.common.entity.projectile.Shrapnel;
import github.nitespring.alchemistarsenal.core.init.EntityInit;
import github.nitespring.alchemistarsenal.core.init.ItemInit;
import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FragmentingArrow
extends AbstractArrow {
    public FragmentingArrow(EntityType<? extends AbstractArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public FragmentingArrow(EntityType<? extends AbstractArrow> pEntityType, double pX, double pY, double pZ, Level pLevel, ItemStack pPickupItemStack, @Nullable ItemStack pFiredFromWeapon) {
        super(pEntityType, pX, pY, pZ, pLevel, pPickupItemStack, pFiredFromWeapon);
    }

    public FragmentingArrow(EntityType<? extends AbstractArrow> pEntityType, LivingEntity pOwner, Level pLevel, ItemStack pPickupItemStack, @Nullable ItemStack pFiredFromWeapon) {
        super(pEntityType, pOwner, pLevel, pPickupItemStack, pFiredFromWeapon);
    }

    protected ItemStack getPickupItem() {
        return ((ArrowItem)ItemInit.AMETHYST_ARROW.get()).getDefaultInstance();
    }

    protected ItemStack getDefaultPickupItem() {
        return ((ArrowItem)ItemInit.AMETHYST_ARROW.get()).getDefaultInstance();
    }

    protected void onHit(HitResult pResult) {
        super.onHit(pResult);
        for (int i = 0; i <= 2; ++i) {
            this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.AMETHYST_CLUSTER.defaultBlockState()), this.getRandomX(0.75), this.getRandomY(), this.getRandomZ(0.75), 0.0, 0.0, 0.0);
        }
    }

    protected void onHitBlock(BlockHitResult pResult) {
        super.onHitBlock(pResult);
        Vec3 pos0 = this.position();
        this.playSound(SoundEvents.GLASS_BREAK);
        this.spawnShrapnel(pos0.x(), pos0.y() + (double)(this.getBbHeight() / 2.0f), pos0.z(), 0.5);
        this.discard();
    }

    protected void onHitEntity(EntityHitResult pResult) {
        super.onHitEntity(pResult);
        Vec3 pos0 = pResult.getEntity().position();
        this.playSound(SoundEvents.GLASS_BREAK);
        this.spawnShrapnel(pos0.x(), pos0.y() + (double)0.1f + (double)(this.getBbHeight() / 2.0f), pos0.z(), pResult.getEntity().getBbWidth() + 0.25f);
    }

    public void spawnShrapnel(double x0, double y0, double z0, double d) {
        float movementSpeed = (float)this.getDeltaMovement().length();
        double baseArrowDamage = this.getBaseDamage();
        if (this.getWeaponItem() != null) {
            baseArrowDamage += (double)this.getWeaponItem().getEnchantmentLevel((Holder)((Registry)this.level().registryAccess().registry(Registries.ENCHANTMENT).get()).getHolder(Enchantments.POWER).get());
        }
        int approximateArrowDamage = Mth.ceil((double)Mth.clamp((double)((double)movementSpeed * baseArrowDamage), (double)0.0, (double)2.147483647E9));
        if (this.isCritArrow()) {
            long k = this.random.nextInt(approximateArrowDamage / 2 + 2);
            approximateArrowDamage = (int)Math.min(k + (long)approximateArrowDamage, Integer.MAX_VALUE);
        }
        Random rand = new Random();
        double oVarI = (double)rand.nextFloat() * Math.PI / 2.0;
        for (int i = -1; i <= 1; ++i) {
            double yVarI = (double)i * Math.PI / 3.0;
            for (int j = 0; j <= 5; ++j) {
                double yVarII = (double)rand.nextFloat() * Math.PI / 6.0;
                double oVarII = (double)j * Math.PI / 4.0;
                for (int k = 0; k <= 1; ++k) {
                    int c = 1 - 2 * k;
                    double oVarIII = (double)rand.nextFloat() * Math.PI / 12.0;
                    double yVarIII = (double)rand.nextFloat() * Math.PI / 16.0;
                    double oRad = (double)c * (oVarI + oVarII + oVarIII);
                    double yRad = (double)c * (yVarI + yVarII + yVarIII);
                    double x = x0 + d * Math.cos(oRad) + 0.5 * (double)rand.nextFloat(-1.0f, 1.0f);
                    double y = y0 + d * Math.sin(yRad) + 0.25 * (double)rand.nextFloat(-1.0f, 1.0f);
                    double z = z0 + d * Math.sin(oRad) + 0.5 * (double)rand.nextFloat(-1.0f, 1.0f);
                    Vec3 aim = new Vec3(x - x0, y - y0, z - z0).normalize();
                    if (!this.random.nextBoolean() || this.level().isClientSide) continue;
                    Shrapnel shrapnel = new Shrapnel((EntityType<? extends AbstractHurtingProjectile>)((EntityType)EntityInit.SHRAPNEL.get()), this.level());
                    Entity entity = this.getOwner();
                    if (entity instanceof LivingEntity) {
                        shrapnel.setOwner((Entity)((LivingEntity)entity));
                    }
                    shrapnel.setPos(x, y, z);
                    float a = 0.2f;
                    shrapnel.accelerationPower = a;
                    shrapnel.setDeltaMovement(aim.scale((double)a));
                    shrapnel.setDamage((float)approximateArrowDamage * 0.75f);
                    if (this.isOnFire()) {
                        shrapnel.setFire(true);
                    }
                    this.level().addFreshEntity((Entity)shrapnel);
                }
            }
        }
    }
}

