/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.alchemistarsenal.common.entity.projectile.arrow;

import github.nitespring.alchemistarsenal.core.init.EntityInit;
import github.nitespring.alchemistarsenal.core.init.ItemInit;
import java.util.List;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class DragonArrow
extends AbstractArrow {
    protected int hitBlocks;
    public static final int MAX_HIT_BLOCKS = 3;

    public DragonArrow(EntityType<? extends AbstractArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public DragonArrow(double pX, double pY, double pZ, Level pLevel, ItemStack pPickupItemStack, @Nullable ItemStack pFiredFromWeapon) {
        super((EntityType)EntityInit.DRAGON_ARROW.get(), pX, pY, pZ, pLevel, pPickupItemStack, pFiredFromWeapon);
    }

    public DragonArrow(LivingEntity pOwner, Level pLevel, ItemStack pPickupItemStack, @Nullable ItemStack pFiredFromWeapon) {
        super((EntityType)EntityInit.DRAGON_ARROW.get(), pOwner, pLevel, pPickupItemStack, pFiredFromWeapon);
    }

    protected ItemStack getPickupItem() {
        return ((ArrowItem)ItemInit.DRAGON_ARROW.get()).getDefaultInstance();
    }

    protected ItemStack getDefaultPickupItem() {
        return ((ArrowItem)ItemInit.DRAGON_ARROW.get()).getDefaultInstance();
    }

    public void tick() {
        super.tick();
        Vec3 mov = this.getDeltaMovement();
        Random rng = new Random();
        double ox = mov.x;
        double oy = mov.y;
        double oz = mov.z;
        if (!this.inGround) {
            for (int i = 0; i < 4; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH, this.getX() + ox * (double)i / 4.0 + ((double)rng.nextFloat() - 0.5), this.getY() + oy * (double)i / 4.0 + ((double)rng.nextFloat() - 0.5), this.getZ() + oz * (double)i / 4.0 + ((double)rng.nextFloat() - 0.5), -0.1 * ox, -0.1 * oy, -0.1 * oz);
            }
        } else if (this.tickCount % 3 == 0) {
            this.level().addParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH, this.getX() + ((double)rng.nextFloat() - 0.5), this.getY() + ((double)rng.nextFloat() - 0.5), this.getZ() + ((double)rng.nextFloat() - 0.5), 0.2 * ((double)rng.nextFloat() - 0.5), 0.25, 0.2 * ((double)rng.nextFloat() - 0.5));
        }
    }

    protected void onHit(HitResult pResult) {
        super.onHit(pResult);
        if (!this.level().isClientSide) {
            List list = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(4.0, 2.0, 4.0));
            AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
            Entity entity = this.getOwner();
            if (entity instanceof LivingEntity) {
                areaeffectcloud.setOwner((LivingEntity)entity);
            }
            areaeffectcloud.setParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH);
            areaeffectcloud.setRadius(1.5f);
            areaeffectcloud.setDuration(100);
            areaeffectcloud.setRadiusPerTick((1.5f - areaeffectcloud.getRadius()) / (float)areaeffectcloud.getDuration());
            areaeffectcloud.addEffect(new MobEffectInstance(MobEffects.HARM, 1, 1));
            if (!list.isEmpty()) {
                for (LivingEntity livingentity : list) {
                    double d0 = this.distanceToSqr((Entity)livingentity);
                    if (!(d0 < 16.0)) continue;
                    areaeffectcloud.setPos(livingentity.getX(), livingentity.getY(), livingentity.getZ());
                    break;
                }
            }
            this.level().addFreshEntity((Entity)areaeffectcloud);
        }
        this.discard();
    }

    protected void onHitBlock(BlockHitResult pResult) {
        super.onHitBlock(pResult);
    }

    protected void onHitEntity(EntityHitResult pResult) {
        super.onHitEntity(pResult);
    }
}

