/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.alchemistarsenal.common.effect;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FlamingFistMobEffect
extends MobEffect {
    public FlamingFistMobEffect(MobEffectCategory p_19451_, int p_19452_) {
        super(p_19451_, p_19452_);
    }

    public boolean applyEffectTick(LivingEntity entityIn, int id) {
        SimpleParticleType flame = ParticleTypes.FLAME;
        float width = entityIn.getBbWidth();
        float height = entityIn.getBbHeight();
        Vec3 pos = new Vec3(entityIn.position().x(), entityIn.position().y(), entityIn.position().z());
        Level world = entityIn.level();
        RandomSource rng = entityIn.getRandom();
        for (int i = 0; i < 1; ++i) {
            Vec3 off = new Vec3(rng.nextDouble() * (double)width - (double)(width / 2.0f), rng.nextDouble() * (double)height - (double)(height / 2.0f), rng.nextDouble() * (double)width - (double)(width / 2.0f));
            if (!(world instanceof ServerLevel)) continue;
            ((ServerLevel)world).sendParticles((ParticleOptions)flame, pos.x + 0.5 * off.x, pos.y + 0.8 + 0.5 * off.y, pos.z + 0.5 * off.z, 1, 0.05 * off.x, 0.05 * off.y + 0.2, 0.05 * off.z, 0.05);
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int a, int b) {
        return true;
    }
}

