/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.alchemistarsenal.client.render.projectile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import github.nitespring.alchemistarsenal.client.render.projectile.SquareTextureEntityModel;
import github.nitespring.alchemistarsenal.core.events.ClientListener;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ShrapnelRenderer<T extends Entity, M extends SquareTextureEntityModel<T>>
extends EntityRenderer<T> {
    private final SquareTextureEntityModel<T> model;

    public ShrapnelRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new SquareTextureEntityModel(context.bakeLayer(ClientListener.SQUARE_TEXTURE));
    }

    public ResourceLocation getTextureLocation(Entity entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"alkhars", (String)"textures/entity/projectiles/crystal_shard.png");
    }

    public void render(T entity, float entityYaw, float partialTick, PoseStack stack, MultiBufferSource bufferSource, int packedLight) {
        stack.pushPose();
        stack.mulPose(Axis.YP.rotationDegrees(-135.0f + entity.getYRot()));
        stack.mulPose(Axis.ZP.rotationDegrees(18.0f + entity.getXRot()));
        stack.translate(0.1, -0.5, 0.0);
        stack.scale(0.4f, 0.4f, 0.4f);
        VertexConsumer vertexconsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.getTextureLocation((Entity)entity)));
        this.model.renderToBuffer(stack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY, packedLight);
        stack.popPose();
        super.render(entity, entityYaw, partialTick, stack, bufferSource, packedLight);
    }
}

