/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.alchemistarsenal.client.render.equipment;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class SteampunkWingsModel<T extends LivingEntity>
extends ElytraModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"alkhars", (String)"steampunk_wings"), "main");
    private final ModelPart leftWing;
    private final ModelPart rightWing;
    private final ModelPart boiler;
    private final ModelPart boosters;
    private final ModelPart booster_right;
    private final ModelPart booster_left;

    public SteampunkWingsModel(ModelPart root) {
        super(root);
        this.leftWing = root.getChild("left_wing");
        this.rightWing = root.getChild("right_wing");
        this.boiler = root.getChild("boiler");
        this.boosters = this.boiler.getChild("boosters");
        this.booster_right = this.boosters.getChild("booster_right");
        this.booster_left = this.boosters.getChild("booster_left");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition left_wing = partdefinition.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(22, 0).addBox(-4.5f, 0.0f, -1.0f, 10.0f, 24.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(48, 42).addBox(3.5f, 0.0f, -0.5f, 2.0f, 16.0f, 2.0f, new CubeDeformation(0.15f)), PartPose.offsetAndRotation((float)0.0f, (float)24.0f, (float)0.0f, (float)-3.1416f, (float)0.0f, (float)3.1416f));
        PartDefinition left_wing_r1 = left_wing.addOrReplaceChild("left_wing_r1", CubeListBuilder.create().texOffs(56, 42).addBox(2.5f, 15.5f, -0.5f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)8.65f, (float)0.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.48f));
        PartDefinition right_wing = partdefinition.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(22, 0).mirror().addBox(-5.5f, 0.0f, -1.0f, 10.0f, 24.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(48, 42).mirror().addBox(-5.5f, 0.0f, -0.5f, 2.0f, 16.0f, 2.0f, new CubeDeformation(0.15f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)24.0f, (float)0.0f, (float)-3.1416f, (float)0.0f, (float)-3.1416f));
        PartDefinition right_wing_r1 = right_wing.addOrReplaceChild("right_wing_r1", CubeListBuilder.create().texOffs(56, 42).mirror().addBox(-4.5f, 15.5f, -0.5f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.1f)).mirror(false), PartPose.offsetAndRotation((float)-8.65f, (float)0.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.48f));
        PartDefinition boiler = partdefinition.addOrReplaceChild("boiler", CubeListBuilder.create().texOffs(0, 56).addBox(-4.0f, -16.0f, -2.0f, 8.0f, 4.0f, 4.0f, new CubeDeformation(0.6f)).texOffs(0, 48).addBox(-4.0f, -16.0f, -2.0f, 8.0f, 4.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition boosters = boiler.addOrReplaceChild("boosters", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)3.0f));
        PartDefinition booster_right = boosters.addOrReplaceChild("booster_right", CubeListBuilder.create().texOffs(29, 40).addBox(-2.5f, -16.5f, 0.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(-0.7f)).texOffs(29, 52).addBox(-2.5f, -16.5f, 0.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)6.0f, (float)-1.0f, (float)-0.5f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition booster_left = boosters.addOrReplaceChild("booster_left", CubeListBuilder.create().texOffs(29, 40).mirror().addBox(-1.5f, -16.5f, 0.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(-0.7f)).mirror(false).texOffs(29, 52).mirror().addBox(-1.5f, -16.5f, 0.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(-0.4f)).mirror(false), PartPose.offsetAndRotation((float)-6.0f, (float)-1.0f, (float)-0.5f, (float)0.3054f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.leftWing, (Object)this.rightWing, (Object)this.boiler);
    }

    public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        float f = 0.2617994f;
        float f1 = -0.2617994f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f11 = 24.0f;
        float f12 = 0.0f;
        float f13 = 0.0f;
        if (pEntity.isFallFlying()) {
            float f4 = 1.0f;
            Vec3 vec3 = pEntity.getDeltaMovement();
            if (vec3.y < 0.0) {
                Vec3 vec31 = vec3.normalize();
                f4 = 1.0f - (float)Math.pow(-vec31.y, 1.5);
            }
            f = f4 * 0.34906584f + (1.0f - f4) * f;
            f1 = f4 * -1.5707964f + (1.0f - f4) * f1;
            f2 = 5.0f;
            if (f4 > 0.0f && f1 <= -0.75f) {
                f5 = (float)(0.5 * Math.cos(0.35 * (double)pAgeInTicks));
            }
            f6 = 1.0f;
            f7 = 0.5f;
            f11 = 22.0f;
            f12 = 1.5f;
        } else if (pEntity.isCrouching()) {
            f = 0.6981317f;
            f1 = -0.7853982f;
            f2 = 6.0f;
            f3 = 0.08726646f;
            f6 = -1.0f;
            f7 = 1.5f;
            f11 = 26.5f;
            f12 = 4.0f;
        }
        this.boiler.y = f11;
        this.boiler.z = f12;
        this.leftWing.y = f2;
        this.leftWing.x = f6;
        this.leftWing.z = f7;
        if (pEntity instanceof AbstractClientPlayer) {
            AbstractClientPlayer abstractclientplayer = (AbstractClientPlayer)pEntity;
            abstractclientplayer.elytraRotX = abstractclientplayer.elytraRotX + (f - abstractclientplayer.elytraRotX) * 0.1f + (f5 - abstractclientplayer.elytraRotY) * 0.1f;
            abstractclientplayer.elytraRotY += (f3 - abstractclientplayer.elytraRotY) * 0.1f;
            abstractclientplayer.elytraRotZ += (f1 - abstractclientplayer.elytraRotZ) * 0.1f;
            this.leftWing.xRot = abstractclientplayer.elytraRotX;
            this.leftWing.yRot = abstractclientplayer.elytraRotY;
            this.leftWing.zRot = abstractclientplayer.elytraRotZ;
        } else {
            this.leftWing.xRot = f + f5;
            this.leftWing.zRot = f1;
            this.leftWing.yRot = f3;
        }
        this.rightWing.yRot = -this.leftWing.yRot;
        this.rightWing.y = this.leftWing.y;
        this.rightWing.x = -this.leftWing.x;
        this.rightWing.z = this.leftWing.z;
        this.rightWing.xRot = this.leftWing.xRot;
        this.rightWing.zRot = -this.leftWing.zRot;
    }
}

