/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.alchemistarsenal.client.render.equipment;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import github.nitespring.alchemistarsenal.client.render.equipment.SteampunkWingsModel;
import github.nitespring.alchemistarsenal.common.item.equipment.ICustomElytra;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class SteampunkWingsLayer<T extends LivingEntity, M extends EntityModel<T>>
extends ElytraLayer<T, M> {
    private final ElytraModel<T> wingsModel;

    public SteampunkWingsLayer(RenderLayerParent pRenderer, EntityModelSet pModelSet) {
        super(pRenderer, pModelSet);
        this.wingsModel = new SteampunkWingsModel(pModelSet.bakeLayer(SteampunkWingsModel.LAYER_LOCATION));
    }

    public void render(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        ItemStack itemstack = pLivingEntity.getItemBySlot(EquipmentSlot.CHEST);
        if (this.shouldRender(itemstack, pLivingEntity)) {
            ResourceLocation resourcelocation;
            if (pLivingEntity instanceof AbstractClientPlayer) {
                AbstractClientPlayer abstractclientplayer = (AbstractClientPlayer)pLivingEntity;
                PlayerSkin playerskin = abstractclientplayer.getSkin();
                resourcelocation = this.getElytraTexture(itemstack, pLivingEntity);
            } else {
                resourcelocation = this.getElytraTexture(itemstack, pLivingEntity);
            }
            pPoseStack.pushPose();
            pPoseStack.translate(0.0f, 0.0f, 0.125f);
            this.getParentModel().copyPropertiesTo(this.wingsModel);
            this.wingsModel.setupAnim(pLivingEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
            VertexConsumer vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)pBuffer, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)resourcelocation), (boolean)itemstack.hasFoil());
            this.wingsModel.renderToBuffer(pPoseStack, vertexconsumer, pPackedLight, OverlayTexture.NO_OVERLAY);
            pPoseStack.popPose();
        }
    }

    public boolean shouldRender(ItemStack stack, T entity) {
        return stack.getItem().asItem() instanceof ICustomElytra;
    }

    public ResourceLocation getElytraTexture(ItemStack stack, T entity) {
        return ((ICustomElytra)stack.getItem().asItem()).getElytraTexture(stack);
    }
}

